/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.FontQueryInfo;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PgAlpha_t;
import org.eclipse.swt.internal.photon.PgMap_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhImage_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PhRect_t;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    int dirtyBits;
    static final int DefaultBack = 0xFFFFFF;
    static final int DefaultFore = 0;
    static final byte[][] DashList = new byte[][]{new byte[0], {18, 6}, {3, 3}, {9, 6, 3, 6}, {9, 3, 3, 3, 3, 3}};
    static int DrawBufferSize = 49152;
    static final int DIRTY_BACKGROUND = 1;
    static final int DIRTY_FOREGROUND = 2;
    static final int DIRTY_CLIPPING = 4;
    static final int DIRTY_FONT = 8;
    static final int DIRTY_LINESTYLE = 16;
    static final int DIRTY_LINEWIDTH = 32;
    static final int DIRTY_LINECAP = 64;
    static final int DIRTY_LINEJOIN = 128;
    static final int DIRTY_XORMODE = 256;

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        int flags = OS.PtEnter(0);
        try {
            if (drawable == null) {
                SWT.error(4);
            }
            GCData data = new GCData();
            data.style = GC.checkStyle(style);
            int hDC = drawable.internal_new_GC(data);
            Device device = data.device;
            if (device == null) {
                device = Device.getDevice();
            }
            if (device == null) {
                SWT.error(4);
            }
            this.device = data.device = device;
            this.init(drawable, data, hDC);
            this.init();
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        int flags = OS.PtEnter(0);
        try {
            Rectangle bounds = image.getBounds();
            int memImage = 0;
            PhRect_t rect = new PhRect_t();
            rect.ul_x = (short)x;
            rect.ul_y = (short)y;
            rect.lr_x = (short)(x + bounds.width - 1);
            rect.lr_y = (short)(y + bounds.height - 1);
            boolean sharedMem = true;
            int rid = this.data.rid;
            int widget = this.data.widget;
            if (rid == 1) {
                memImage = OS.PgShmemCreate(OS.PgReadScreenSize(rect), null);
                if (memImage != 0) {
                    memImage = OS.PgReadScreen(rect, memImage);
                }
            } else if (widget != 0) {
                short[] widget_x = new short[1];
                short[] widget_y = new short[1];
                OS.PtGetAbsPosition(widget, widget_x, widget_y);
                rect.ul_x = (short)(rect.ul_x + widget_x[0]);
                rect.ul_y = (short)(rect.ul_y + widget_y[0]);
                rect.lr_x = (short)(rect.lr_x + widget_y[0]);
                rect.lr_y = (short)(rect.lr_y + widget_y[0]);
                memImage = OS.PgShmemCreate(OS.PgReadScreenSize(rect), null);
                if (memImage != 0) {
                    memImage = OS.PgReadScreen(rect, memImage);
                }
            } else if (this.data.image != null) {
                memImage = OS.PiCropImage(this.data.image.handle, rect, 0);
                sharedMem = false;
            }
            if (memImage == 0) {
                SWT.error(2);
            }
            PhImage_t phImage = new PhImage_t();
            OS.memmove(phImage, memImage, 56);
            PhPoint_t trans = new PhPoint_t();
            PhPoint_t pos = new PhPoint_t();
            PhDim_t scale = new PhDim_t();
            scale.w = (short)bounds.width;
            scale.h = (short)bounds.height;
            int mc = OS.PmMemCreateMC(image.handle, scale, trans);
            int prevContext = OS.PmMemStart(mc);
            OS.PgSetDrawBufferSize(DrawBufferSize);
            if (phImage.palette != 0) {
                OS.PgSetPalette(phImage.palette, 0, (short)0, (short)phImage.colors, 0, 0);
            }
            OS.PgDrawImage(phImage.image, phImage.type, pos, scale, phImage.bpl, 0);
            if (phImage.palette != 0) {
                OS.PgSetPalette(0, 0, (short)0, (short)-1, 0, 0);
            }
            OS.PmMemFlush(mc, image.handle);
            OS.PmMemStop(mc);
            OS.PmMemReleaseMC(mc);
            OS.PhDCSetCurrent(prevContext);
            if (sharedMem) {
                OS.PgShmemDestroy(memImage);
            } else {
                phImage.flags = (byte)31;
                OS.memmove(memImage, phImage, 56);
                OS.PhReleaseImage(memImage);
                OS.free(memImage);
            }
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void copyArea(int x, int y, int width, int height, int destX, int destY) {
        this.copyArea(x, y, width, height, destX, destY, true);
    }

    public void copyArea(int x, int y, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        int flags = OS.PtEnter(0);
        try {
            boolean overlaps = destX < x + width && destY < y + height && destX + width > x && destY + height > y;
            int widget = this.data.widget;
            Image image = this.data.image;
            if (image != null) {
                int drawImage = image.handle;
                PhImage_t phDrawImage = new PhImage_t();
                OS.memmove(phDrawImage, drawImage, 56);
                if (overlaps) {
                    PhPoint_t trans = new PhPoint_t();
                    PhDim_t scale = new PhDim_t();
                    scale.w = (short)width;
                    scale.h = (short)height;
                    PhPoint_t pos = new PhPoint_t();
                    pos.x = (short)(-x);
                    pos.y = (short)(-y);
                    PhDim_t dim = new PhDim_t();
                    dim.w = (short)Math.min(phDrawImage.size_w, x + width);
                    dim.h = (short)Math.min(phDrawImage.size_h, y + height);
                    int type = 16;
                    if ((phDrawImage.type & 0x38) == 32) {
                        type = 33;
                    }
                    int memImage = OS.PhCreateImage(null, (short)width, (short)height, type, phDrawImage.palette, phDrawImage.colors, 0);
                    int mc = OS.PmMemCreateMC(memImage, scale, trans);
                    int prevContext = OS.PmMemStart(mc);
                    OS.PgSetDrawBufferSize(DrawBufferSize);
                    if (phDrawImage.palette != 0) {
                        OS.PgSetPalette(phDrawImage.palette, 0, (short)0, (short)phDrawImage.colors, 0, 0);
                    }
                    OS.PgDrawImage(phDrawImage.image, phDrawImage.type, pos, dim, phDrawImage.bpl, 0);
                    if (phDrawImage.palette != 0) {
                        OS.PgSetPalette(0, 0, (short)0, (short)-1, 0, 0);
                    }
                    OS.PmMemFlush(mc, memImage);
                    OS.PmMemStop(mc);
                    OS.PmMemReleaseMC(mc);
                    OS.PhDCSetCurrent(prevContext);
                    x = 0;
                    y = 0;
                    drawImage = memImage;
                    OS.memmove(phDrawImage, drawImage, 56);
                    phDrawImage.flags = (byte)31;
                    OS.memmove(drawImage, phDrawImage, 56);
                }
                PhPoint_t pos = new PhPoint_t();
                pos.x = (short)(destX - x);
                pos.y = (short)(destY - y);
                PhRect_t clip = new PhRect_t();
                clip.ul_x = (short)destX;
                clip.ul_y = (short)destY;
                clip.lr_x = (short)(destX + width - 1);
                clip.lr_y = (short)(destY + height - 1);
                PhDim_t dim = new PhDim_t();
                dim.w = (short)Math.min(phDrawImage.size_w, x + width);
                dim.h = (short)Math.min(phDrawImage.size_h, y + height);
                int prevContext = this.setGC();
                this.setGCTranslation();
                this.setGCClipping();
                OS.PgSetUserClip(clip);
                if (phDrawImage.palette != 0) {
                    OS.PgSetPalette(phDrawImage.palette, 0, (short)0, (short)phDrawImage.colors, 0, 0);
                }
                OS.PgDrawImage(phDrawImage.image, phDrawImage.type, pos, dim, phDrawImage.bpl, 0);
                if (phDrawImage.palette != 0) {
                    OS.PgSetPalette(0, 0, (short)0, (short)-1, 0, 0);
                }
                OS.PgSetUserClip(null);
                this.unsetGC(prevContext);
                if (drawImage != image.handle) {
                    OS.PhReleaseImage(drawImage);
                    OS.free(drawImage);
                }
            } else if (widget != 0) {
                PhRect_t rect = new PhRect_t();
                rect.ul_x = (short)x;
                rect.ul_y = (short)y;
                rect.lr_x = (short)(x + width - 1);
                rect.lr_y = (short)(y + height - 1);
                PhPoint_t delta = new PhPoint_t();
                delta.x = (short)deltaX;
                delta.y = (short)deltaY;
                int visibleTiles = this.getClipping(widget, this.data.topWidget, true, true, null);
                if (visibleTiles == 0) {
                    OS.PtBlit(widget, rect, delta);
                } else {
                    int srcTile = OS.PhGetTile();
                    OS.memmove(srcTile, rect, 8);
                    OS.PtClippedBlit(widget, srcTile, delta, visibleTiles);
                    OS.PhFreeTiles(srcTile);
                    OS.PhFreeTiles(visibleTiles);
                }
            }
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    void destroy() {
        int flags = OS.PtEnter(0);
        try {
            Image image;
            int clipRects = this.data.clipRects;
            if (clipRects != 0) {
                OS.free(clipRects);
                this.data.clipRectsCount = 0;
                this.data.clipRects = 0;
            }
            if ((image = this.data.image) != null) {
                this.flushImage();
                if (image.transparentPixel != -1) {
                    PhImage_t phImage = new PhImage_t();
                    OS.memmove(phImage, image.handle, 56);
                    if (phImage.mask_bm == 0) {
                        GC.createMask(image.handle, phImage.type, image.transparentPixel);
                    }
                }
                image.memGC = null;
            }
            this.drawable.internal_dispose_GC(this.handle, this.data);
            this.drawable = null;
            this.handle = 0;
            this.data.image = null;
            this.data.font = null;
            this.data.topWidget = 0;
            this.data.widget = 0;
            this.data.rid = 0;
            this.data = null;
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        if (startAngle > 0) {
            if (arcAngle > 0) {
                arcAngle += startAngle;
            } else {
                int newStopAngle = startAngle;
                int newStartAngle = startAngle > Math.abs(arcAngle) ? startAngle - Math.abs(arcAngle) : startAngle + 360 - Math.abs(arcAngle);
                startAngle = newStartAngle;
                arcAngle = newStopAngle;
            }
        } else if (arcAngle > 0) {
            arcAngle += startAngle;
            startAngle = 360 - Math.abs(startAngle);
        } else {
            int newStopAngle = 360 + startAngle;
            startAngle = newStopAngle - Math.abs(arcAngle);
            arcAngle = newStopAngle;
        }
        startAngle = startAngle * 65536 / 360;
        arcAngle = arcAngle * 65536 / 360;
        PhPoint_t center = new PhPoint_t();
        center.x = (short)(x + width / 2);
        center.y = (short)(y + height / 2);
        PhPoint_t radii = new PhPoint_t();
        radii.x = (short)(width / 2);
        radii.y = (short)(height / 2);
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawArc(center, radii, startAngle, arcAngle, 8208);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            if (width < 0) {
                width -= width;
            }
            if (height < 0) {
                height -= height;
            }
            OS.PgSetStrokeColor(9476344);
            OS.PgDrawIRect(x, y, x + width - 1, y + height - 1, 16);
            OS.PgSetStrokeColor(this.data.foreground);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int flags = OS.PtEnter(0);
        try {
            if (image.memGC != null) {
                image.memGC.flushImage();
            }
            int drawImage = image.handle;
            PhImage_t phDrawImage = new PhImage_t();
            OS.memmove(phDrawImage, drawImage, 56);
            short imgWidth = phDrawImage.size_w;
            short imgHeight = phDrawImage.size_h;
            if (simple) {
                short s = imgWidth;
                destWidth = s;
                srcWidth = s;
                short s2 = imgHeight;
                destHeight = s2;
                srcHeight = s2;
            } else {
                boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
                if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                    SWT.error(5);
                }
            }
            if (srcWidth != destWidth || srcHeight != destHeight) {
                drawImage = GC.scaleImage(image, phDrawImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight);
                if (drawImage == 0) {
                    return;
                }
                srcX = 0;
                srcY = 0;
                srcWidth = (short)destWidth;
                srcHeight = (short)destHeight;
                OS.memmove(phDrawImage, drawImage, 56);
            }
            PhPoint_t pos = new PhPoint_t();
            pos.x = (short)(destX - srcX);
            pos.y = (short)(destY - srcY);
            PhDim_t dim = new PhDim_t();
            dim.w = (short)Math.min(phDrawImage.size_w, srcX + srcWidth);
            dim.h = (short)Math.min(phDrawImage.size_h, srcY + srcHeight);
            PhRect_t clip = new PhRect_t();
            clip.ul_x = (short)destX;
            clip.ul_y = (short)destY;
            clip.lr_x = (short)(destX + destWidth - 1);
            clip.lr_y = (short)(destY + destHeight - 1);
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgSetDrawMode(this.data.xorMode ? 26240 : 52352);
            this.dirtyBits |= 0x100;
            OS.PgSetUserClip(clip);
            if (phDrawImage.palette != 0) {
                OS.PgSetPalette(phDrawImage.palette, 0, (short)0, (short)phDrawImage.colors, 0, 0);
            }
            if (phDrawImage.alpha != 0) {
                this.drawImageAlpha(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, phDrawImage, drawImage, pos, dim);
            } else if (image.transparentPixel != -1) {
                this.drawImageTransparent(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, phDrawImage, drawImage, pos, dim);
            } else if (phDrawImage.mask_bm != 0) {
                this.drawImageMask(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, phDrawImage, drawImage, pos, dim);
            } else {
                this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, phDrawImage, drawImage, pos, dim);
            }
            if (phDrawImage.palette != 0) {
                OS.PgSetPalette(0, 0, (short)0, (short)-1, 0, 0);
            }
            OS.PgSetUserClip(null);
            this.unsetGC(prevContext);
            if (drawImage != image.handle) {
                phDrawImage.flags = (byte)31;
                OS.memmove(drawImage, phDrawImage, 56);
                OS.PhReleaseImage(drawImage);
                OS.free(drawImage);
            }
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    void drawImageAlpha(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, PhImage_t phImage, int imgHandle, PhPoint_t pos, PhDim_t dim) {
        PgAlpha_t phAlpha = new PgAlpha_t();
        OS.memmove(phAlpha, phImage.alpha, 104);
        if ((phAlpha.alpha_op & 0x40000) != 0) {
            OS.PgSetAlpha(phAlpha.alpha_op, null, 0, phAlpha.src_global_alpha, phAlpha.dest_global_alpha);
            OS.PgAlphaOn();
            OS.PgDrawImage(phImage.image, phImage.type, pos, dim, phImage.bpl, 0);
            OS.PgAlphaOff();
            return;
        }
        PgMap_t imageMap = new PgMap_t();
        OS.memmove(imageMap, phImage.alpha + 4, 12);
        PgMap_t lineMap = new PgMap_t();
        lineMap.dim_w = imageMap.dim_w;
        lineMap.dim_h = 1;
        lineMap.map = OS.malloc(lineMap.dim_w);
        OS.PgSetAlpha(phAlpha.alpha_op, lineMap, 0, phAlpha.src_global_alpha, phAlpha.dest_global_alpha);
        OS.PgAlphaOn();
        pos.y = (short)destY;
        short end = dim.h;
        dim.h = 1;
        int y = srcY;
        while (y < end) {
            OS.memmove(lineMap.map, imageMap.map + imageMap.dim_w * y, (int)lineMap.dim_w);
            if (this.data.image != null && pos.x < 0) {
                OS.memmove(lineMap.map, lineMap.map - pos.x, lineMap.dim_w + pos.x);
            }
            OS.PgDrawImage(phImage.image + phImage.bpl * y, phImage.type, pos, dim, phImage.bpl, 0);
            if (this.data.image != null) {
                OS.PmMemFlush(this.handle, this.data.image.handle);
            } else {
                OS.PgFlush();
            }
            pos.y = (short)(pos.y + lineMap.dim_h);
            y += lineMap.dim_h;
        }
        OS.PgAlphaOff();
    }

    void drawImageTransparent(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, PhImage_t phImage, int imgHandle, PhPoint_t pos, PhDim_t dim) {
        if (phImage.mask_bm == 0) {
            GC.createMask(imgHandle, phImage.type, image.transparentPixel);
            OS.memmove(phImage, imgHandle, 56);
        }
        OS.PgDrawTImage(phImage.image, phImage.type, pos, dim, phImage.bpl, 0, phImage.mask_bm, phImage.mask_bpl);
        if (image.memGC != null && image.handle == imgHandle) {
            OS.free(phImage.mask_bm);
            phImage.mask_bm = 0;
            phImage.mask_bpl = 0;
            OS.memmove(imgHandle, phImage, 56);
        }
    }

    void drawImageMask(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, PhImage_t phImage, int imgHandle, PhPoint_t pos, PhDim_t dim) {
        OS.PgDrawTImage(phImage.image, phImage.type, pos, dim, phImage.bpl, 0, phImage.mask_bm, phImage.mask_bpl);
    }

    void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, PhImage_t phImage, int imgHandle, PhPoint_t pos, PhDim_t dim) {
        OS.PgDrawImage(phImage.image, phImage.type, pos, dim, phImage.bpl, 0);
    }

    static void createMask(int image, int type, int transparent) {
        if ((type & 0x38) == 16) {
            transparent = transparent & 0xFF | 0x2000000;
        } else {
            switch (type) {
                case 33: {
                    transparent = (transparent & 0xFF) << 16 | transparent & 0xFF00 | (transparent & 0xFF0000) >> 16;
                    break;
                }
                case 32: {
                    transparent = (transparent & 0xFF00) << 8 | (transparent & 0xFF0000) >> 8 | (transparent & 0xFF000000) >> 24;
                    break;
                }
                case 34: {
                    transparent = (transparent & 0xF800) << 8 | (transparent & 0x7E0) << 5 | (transparent & 0x1F) << 3;
                    break;
                }
                case 35: {
                    transparent = (transparent & 0x7C00) << 9 | (transparent & 0x3E0) << 6 | (transparent & 0x1F) << 3;
                    break;
                }
                case 36: {
                    transparent = (transparent & 0xF00) << 12 | (transparent & 0xF0) << 8 | (transparent & 0xF) << 4;
                }
            }
        }
        OS.PhMakeTransBitmap(image, transparent);
    }

    static int scaleImage(Image image, PhImage_t phImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        int memImage;
        PhPoint_t trans = new PhPoint_t();
        PhDim_t scale = new PhDim_t();
        scale.w = (short)srcWidth;
        scale.h = (short)srcHeight;
        PhPoint_t pos = new PhPoint_t();
        pos.x = (short)(-srcX);
        pos.y = (short)(-srcY);
        PhDim_t dim = new PhDim_t();
        dim.w = (short)Math.min(phImage.size_w, srcX + srcWidth);
        dim.h = (short)Math.min(phImage.size_h, srcY + srcHeight);
        int type = 16;
        if ((phImage.type & 0x38) == 32) {
            type = 33;
        }
        if ((memImage = OS.PhCreateImage(null, (short)destWidth, (short)destHeight, type, phImage.palette, phImage.colors, 0)) == 0) {
            return 0;
        }
        int mc = OS.PmMemCreateMC(memImage, scale, trans);
        if (mc == 0) {
            Image.destroyImage(memImage);
            return 0;
        }
        int prevContext = OS.PmMemStart(mc);
        OS.PgSetDrawBufferSize(DrawBufferSize);
        if (phImage.palette != 0) {
            OS.PgSetPalette(phImage.palette, 0, (short)0, (short)phImage.colors, 0, 0);
        }
        OS.PgDrawImage(phImage.image, phImage.type, pos, dim, phImage.bpl, 0);
        if (phImage.palette != 0) {
            OS.PgSetPalette(0, 0, (short)0, (short)-1, 0, 0);
        }
        OS.PmMemFlush(mc, memImage);
        OS.PmMemStop(mc);
        OS.PmMemReleaseMC(mc);
        OS.PhDCSetCurrent(prevContext);
        PhImage_t phMemImage = new PhImage_t();
        OS.memmove(phMemImage, memImage, 56);
        if (image.transparentPixel != -1) {
            if (phImage.mask_bm != 0) {
                GC.createMask(memImage, phImage.type, image.transparentPixel);
            }
        } else if (phImage.mask_bm != 0) {
            int[] palette = new int[]{0, 0xFFFFFF};
            int palettePtr = OS.malloc(palette.length * 4);
            OS.memmove(palettePtr, palette, palette.length * 4);
            int maskImage = OS.PhCreateImage(null, (short)destWidth, (short)destHeight, 16, palettePtr, palette.length, 0);
            if (maskImage == 0) {
                Image.destroyImage(memImage);
                return 0;
            }
            mc = OS.PmMemCreateMC(maskImage, scale, trans);
            if (mc == 0) {
                Image.destroyImage(maskImage);
                Image.destroyImage(memImage);
                return 0;
            }
            prevContext = OS.PmMemStart(mc);
            OS.PgSetDrawBufferSize(DrawBufferSize);
            OS.PgSetFillColor(palette[0]);
            OS.PgSetTextColor(palette[1]);
            OS.PgDrawBitmap(phImage.mask_bm, 256, pos, dim, phImage.mask_bpl, 0);
            OS.PmMemFlush(mc, maskImage);
            OS.PmMemStop(mc);
            OS.PmMemReleaseMC(mc);
            OS.PhDCSetCurrent(prevContext);
            OS.free(palettePtr);
            OS.PhMakeTransBitmap(maskImage, 0x2000000);
            PhImage_t phMaskImage = new PhImage_t();
            OS.memmove(phMaskImage, maskImage, 56);
            phMemImage.mask_bm = phMaskImage.mask_bm;
            phMemImage.mask_bpl = phMaskImage.mask_bpl;
            OS.memmove(memImage, phMemImage, 56);
            phMaskImage.mask_bm = 0;
            phMaskImage.mask_bpl = 0;
            phMaskImage.flags = (byte)31;
            OS.memmove(maskImage, phMaskImage, 56);
            OS.PhReleaseImage(maskImage);
            OS.free(maskImage);
        } else if (phImage.alpha != 0) {
            PgAlpha_t alpha = new PgAlpha_t();
            OS.memmove(alpha, phImage.alpha, 104);
            int alphaPtr = OS.malloc(104);
            if (alphaPtr == 0) {
                Image.destroyImage(memImage);
                return 0;
            }
            if (alpha.src_alpha_map_map != 0) {
                int[] palette = new int[256];
                int i = 0;
                while (i < palette.length) {
                    palette[i] = i;
                    ++i;
                }
                int palettePtr = OS.malloc(palette.length * 4);
                OS.memmove(palettePtr, palette, palette.length * 4);
                int alphaImage = OS.PhCreateImage(null, (short)destWidth, (short)destHeight, 16, palettePtr, palette.length, 0);
                if (alphaImage == 0) {
                    OS.free(palettePtr);
                    OS.free(alphaPtr);
                    Image.destroyImage(memImage);
                    return 0;
                }
                mc = OS.PmMemCreateMC(alphaImage, scale, trans);
                if (mc == 0) {
                    OS.free(palettePtr);
                    OS.free(alphaPtr);
                    Image.destroyImage(alphaImage);
                    Image.destroyImage(memImage);
                    return 0;
                }
                prevContext = OS.PmMemStart(mc);
                OS.PgSetPalette(palettePtr, 0, (short)0, (short)palette.length, 0, 0);
                OS.PgDrawImage(alpha.src_alpha_map_map, 16, pos, dim, alpha.src_alpha_map_bpl, 0);
                OS.PgSetPalette(0, 0, (short)0, (short)-1, 0, 0);
                OS.PmMemFlush(mc, alphaImage);
                OS.PmMemStop(mc);
                OS.PmMemReleaseMC(mc);
                OS.PhDCSetCurrent(prevContext);
                OS.free(palettePtr);
                PhImage_t phAlphaImage = new PhImage_t();
                OS.memmove(phAlphaImage, alphaImage, 56);
                alpha.src_alpha_map_bpl = (short)phAlphaImage.bpl;
                alpha.src_alpha_map_dim_w = (short)phAlphaImage.bpl;
                alpha.src_alpha_map_dim_h = phAlphaImage.size_h;
                alpha.src_alpha_map_map = phAlphaImage.image;
                phAlphaImage.image = 0;
                phAlphaImage.bpl = 0;
                phAlphaImage.flags = (byte)31;
                OS.memmove(alphaImage, phAlphaImage, 56);
                OS.PhReleaseImage(alphaImage);
                OS.free(alphaImage);
            }
            OS.memmove(alphaPtr, alpha, 104);
            phMemImage.alpha = alphaPtr;
            OS.memmove(memImage, phMemImage, 56);
        }
        return memImage;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawILine(x1, y1, x2, y2);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        PhPoint_t center = new PhPoint_t();
        center.x = (short)x;
        center.y = (short)y;
        PhPoint_t radii = new PhPoint_t();
        radii.x = (short)(x + width);
        radii.y = (short)(y + height);
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawEllipse(center, radii, 272);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawIPixel(x, y);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        short[] points = new short[pointArray.length];
        int i = pointArray.length - 1;
        while (i >= 0) {
            points[i] = (short)pointArray[i];
            --i;
        }
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawPolygon(points, pointArray.length / 2, new PhPoint_t(), 4112);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        short[] points = new short[pointArray.length];
        int i = pointArray.length - 1;
        while (i >= 0) {
            points[i] = (short)pointArray[i];
            --i;
        }
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawPolygon(points, pointArray.length / 2, new PhPoint_t(), 16);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawIRect(x, y, x + width, y + height, 16);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        PhRect_t rect = new PhRect_t();
        rect.ul_x = (short)x;
        rect.ul_y = (short)y;
        rect.lr_x = (short)(x + width);
        rect.lr_y = (short)(y + height);
        PhPoint_t radii = new PhPoint_t();
        radii.x = (short)(arcWidth / 2);
        radii.y = (short)(arcHeight / 2);
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawRoundRect(rect, radii, 16);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        int drawFlags = 20480;
        if (!isTransparent) {
            drawFlags |= 0x100;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            PhPoint_t pos = new PhPoint_t();
            pos.x = (short)x;
            pos.y = (short)y;
            if (!this.data.xorMode) {
                OS.PgDrawText(buffer, buffer.length, pos, drawFlags);
            } else if (isTransparent) {
                Font font = this.data.font;
                PhRect_t rect = new PhRect_t();
                OS.PfExtentText(rect, null, font.handle, buffer, buffer.length);
                short width = (short)(rect.lr_x - rect.ul_x + 1);
                short height = (short)(rect.lr_y - rect.ul_y + 1);
                int image = OS.PhCreateImage(null, width, height, 33, 0, 0, 0);
                PhDim_t dim = new PhDim_t();
                dim.w = width;
                dim.h = height;
                PhPoint_t point = new PhPoint_t();
                int pmMC = OS.PmMemCreateMC(image, dim, point);
                if (pmMC == 0) {
                    SWT.error(2);
                }
                int prevCont = OS.PmMemStart(pmMC);
                OS.PgSetTextColor(this.data.foreground);
                OS.PgSetFont(font.handle);
                pos.y = 0;
                pos.x = 0;
                OS.PgDrawText(buffer, buffer.length, pos, drawFlags);
                OS.PmMemFlush(pmMC, image);
                OS.PmMemStop(pmMC);
                OS.PhDCSetCurrent(prevCont);
                OS.PmMemReleaseMC(pmMC);
                point.x = (short)x;
                point.y = (short)y;
                PhImage_t phImage = new PhImage_t();
                OS.memmove(phImage, image, 56);
                OS.PgSetDrawMode(26240);
                this.dirtyBits |= 0x100;
                OS.PgDrawImage(phImage.image, phImage.type, point, dim, phImage.bpl, 0);
                phImage.flags = (byte)31;
                OS.memmove(image, phImage, 56);
                OS.PhReleaseImage(image);
                OS.free(image);
            } else {
                OS.PgSetTextXORColor(this.data.foreground, this.data.background);
                OS.PgSetDrawMode(52352);
                OS.PgDrawText(buffer, buffer.length, pos, drawFlags);
                this.dirtyBits |= 0x102;
            }
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((flags & 0xFFFFFFFE) == 0) {
            this.drawString(string, x, y, (flags & 1) != 0);
        } else {
            this.drawText(string, x, y, flags, true);
        }
    }

    Point drawText(String text, int x, int y, int flags, boolean draw) {
        int length = text.length();
        char[] buffer = new char[length];
        text.getChars(0, length, buffer, 0);
        int spaceWidth = this.stringExtent((String)" ").x;
        int tabWidth = spaceWidth * 8 + 1;
        boolean transparent = (flags & 1) != 0;
        int mnemonic = -1;
        int start = 0;
        int i = 0;
        int j = 0;
        int initialX = x;
        int initialY = y;
        int maxX = x;
        int maxY = y;
        while (i < length) {
            char c = buffer[j] = buffer[i];
            switch (c) {
                case '\t': {
                    if ((flags & 4) == 0) break;
                    String string = new String(buffer, start, j - start);
                    if (draw) {
                        this.drawString(string, x, y, transparent);
                    }
                    Point extent = this.stringExtent(string);
                    maxX = Math.max(x += extent.x + tabWidth, maxX);
                    maxY = Math.max(y + extent.y, maxY);
                    start = j + 1;
                    break;
                }
                case '\n': {
                    if ((flags & 2) == 0) break;
                    String string = new String(buffer, start, j - start);
                    if (draw) {
                        this.drawString(string, x, y, transparent);
                    }
                    Point extent = this.stringExtent(string);
                    maxX = Math.max(x + extent.x, maxX);
                    x = initialX;
                    maxY = Math.max(y += extent.y, maxY);
                    start = j + 1;
                    break;
                }
                case '&': {
                    Point extent;
                    String string;
                    if ((flags & 8) == 0 || i + 1 == length) break;
                    if (buffer[i + 1] == '&') {
                        ++i;
                        break;
                    }
                    if (mnemonic == -1) {
                        mnemonic = i + 1;
                        string = new String(buffer, start, j - start);
                        if (draw) {
                            this.drawString(string, x, y, transparent);
                        }
                        extent = this.stringExtent(string);
                        x += extent.x;
                        start = mnemonic;
                        string = new String(buffer, start, 1);
                        if (draw) {
                            this.drawString(string, x, y, transparent);
                        }
                        extent = this.stringExtent(string);
                        int underlineY = y + extent.y - 1;
                        if (draw) {
                            this.drawLine(x, underlineY, x + extent.x, underlineY);
                        }
                        maxX = Math.max(x += extent.x, maxX);
                        maxY = Math.max(y + extent.y, maxY);
                        start = j + 1;
                    }
                    --j;
                }
            }
            ++j;
            ++i;
        }
        if (start != j) {
            String string = new String(buffer, start, j - start);
            if (draw) {
                this.drawString(string, x, y, transparent);
            }
            Point extent = this.stringExtent(string);
            maxX = Math.max(x + extent.x, maxX);
            maxY = Math.max(y + extent.y, maxY);
        }
        return new Point(maxX - initialX, maxY - initialY);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        if (startAngle > 0) {
            if (arcAngle > 0) {
                arcAngle += startAngle;
            } else {
                int newStopAngle = startAngle;
                int newStartAngle = startAngle > Math.abs(arcAngle) ? startAngle - Math.abs(arcAngle) : startAngle + 360 - Math.abs(arcAngle);
                startAngle = newStartAngle;
                arcAngle = newStopAngle;
            }
        } else if (arcAngle > 0) {
            arcAngle += startAngle;
            startAngle = 360 - Math.abs(startAngle);
        } else {
            int newStopAngle = 360 + startAngle;
            startAngle = newStopAngle - Math.abs(arcAngle);
            arcAngle = newStopAngle;
        }
        startAngle = startAngle * 65536 / 360;
        arcAngle = arcAngle * 65536 / 360;
        PhPoint_t center = new PhPoint_t();
        center.x = (short)(x + width / 2);
        center.y = (short)(y + height / 2);
        PhPoint_t radii = new PhPoint_t();
        radii.x = (short)(width / 2);
        radii.y = (short)(height / 2);
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawArc(center, radii, startAngle, arcAngle, 4128);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        int fromColor = this.data.foreground;
        int toColor = this.data.background;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            int t = toColor;
            toColor = fromColor;
            fromColor = t;
        }
        if (fromColor == toColor) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        PhPoint_t upperLeft = new PhPoint_t();
        upperLeft.x = (short)x;
        upperLeft.y = (short)y;
        PhPoint_t lowerRight = new PhPoint_t();
        lowerRight.x = (short)(x + width - 1);
        lowerRight.y = (short)(y + height - 1);
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawGradient(upperLeft, lowerRight, vertical ? 4 : 3, 0, vertical ? height : width, fromColor, toColor, 0, 0, 0, null);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        PhPoint_t center = new PhPoint_t();
        center.x = (short)x;
        center.y = (short)y;
        PhPoint_t radii = new PhPoint_t();
        radii.x = (short)(x + width);
        radii.y = (short)(y + height);
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawEllipse(center, radii, 288);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        short[] points = new short[pointArray.length];
        int i = pointArray.length - 1;
        while (i >= 0) {
            points[i] = (short)pointArray[i];
            --i;
        }
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawPolygon(points, pointArray.length / 2, new PhPoint_t(), 4128);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawIRect(x, y, x + width - 1, y + height - 1, 32);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        PhRect_t rect = new PhRect_t();
        rect.ul_x = (short)x;
        rect.ul_y = (short)y;
        rect.lr_x = (short)(x + width - 1);
        rect.lr_y = (short)(y + height - 1);
        PhPoint_t radii = new PhPoint_t();
        radii.x = (short)(arcWidth / 2);
        radii.y = (short)(arcHeight / 2);
        int flags = OS.PtEnter(0);
        try {
            int prevContext = this.setGC();
            this.setGCTranslation();
            this.setGCClipping();
            OS.PgDrawRoundRect(rect, radii, 32);
            this.unsetGC(prevContext);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    void flushImage() {
        Image image = this.data.image;
        if (image == null) {
            return;
        }
        int prevContext = OS.PmMemStart(this.handle);
        OS.PmMemFlush(this.handle, image.handle);
        OS.PmMemStop(this.handle);
        OS.PhDCSetCurrent(prevContext);
    }

    public int getAdvanceWidth(char ch) {
        return this.getCharWidth(ch);
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return false;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return 255;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.photon_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return null;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        String string = new String(new char[]{ch});
        Point point = this.stringExtent(string);
        return point.x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int flags = OS.PtEnter(0);
        try {
            PhRect_t rect = new PhRect_t();
            int rid = this.data.rid;
            int widget = this.data.widget;
            Image image = this.data.image;
            if (rid == 1) {
                OS.PhRegionQuery(rid, null, rect, 0, 0);
            } else if (widget != 0) {
                OS.PtWidgetCanvas(widget, rect);
            } else if (image != null) {
                PhImage_t img = new PhImage_t();
                OS.memmove(img, image.handle, 56);
                rect.lr_x = (short)(img.size_w - 1);
                rect.lr_y = (short)(img.size_h - 1);
            }
            int clipRects = this.data.clipRects;
            if (clipRects != 0) {
                int clipRectsCount = this.data.clipRectsCount;
                int clip_ptr = OS.malloc(8);
                OS.memmove(clip_ptr, clipRects, 8);
                int i = 1;
                while (i < clipRectsCount) {
                    OS.PhRectUnion(clip_ptr, clipRects + i * 8);
                    ++i;
                }
                int rect_ptr = OS.malloc(8);
                OS.memmove(rect_ptr, rect, 8);
                boolean intersect = OS.PhRectIntersect(rect_ptr, clip_ptr) != 0;
                OS.memmove(rect, rect_ptr, 8);
                OS.free(rect_ptr);
                OS.free(clip_ptr);
                if (!intersect) {
                    Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                    return rectangle;
                }
            }
            int width = rect.lr_x - rect.ul_x + 1;
            int height = rect.lr_y - rect.ul_y + 1;
            Rectangle rectangle = new Rectangle(rect.ul_x, rect.ul_y, width, height);
            return rectangle;
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        int flags = OS.PtEnter(0);
        try {
            int clipRects;
            if (region.handle != 0 && region.handle != Region.EMPTY_REGION) {
                OS.PhFreeTiles(region.handle);
            }
            if ((clipRects = this.data.clipRects) != 0) {
                region.handle = OS.PhRectsToTiles(clipRects, this.data.clipRectsCount);
            } else {
                region.handle = OS.PhGetTile();
                PhRect_t rect = new PhRect_t();
                int rid = this.data.rid;
                int widget = this.data.widget;
                Image image = this.data.image;
                if (rid == 1) {
                    OS.PhRegionQuery(rid, null, rect, 0, 0);
                } else if (widget != 0) {
                    OS.PtWidgetCanvas(widget, rect);
                } else if (image != null) {
                    PhImage_t img = new PhImage_t();
                    OS.memmove(img, image.handle, 56);
                    rect.lr_x = (short)(img.size_w - 1);
                    rect.lr_y = (short)(img.size_h - 1);
                }
                OS.memmove(region.handle, rect, 8);
            }
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return 1;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        FontQueryInfo info = new FontQueryInfo();
        OS.PfQueryFontInfo(this.data.font.handle, info);
        return FontMetrics.photon_new(info);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.photon_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return null;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] dashes = null;
        if (this.data.dashes != null) {
            dashes = new float[this.data.dashes.length];
            int i = 0;
            while (i < dashes.length) {
                dashes[i] = this.data.dashes[i];
                ++i;
            }
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, 0.0f, 10.0f);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        byte[] dashList;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((dashList = this.data.dashes) == null) {
            return null;
        }
        int[] dashes = new int[dashList.length];
        int i = 0;
        while (i < dashes.length) {
            dashes[i] = dashList[i] & 0xFF;
            ++i;
        }
        return dashes;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData data, int context) {
        if (data.foreground == -1) {
            data.foreground = 0;
        }
        if (data.background == -1) {
            data.background = 0xFFFFFF;
        }
        if (data.font == null) {
            data.font = data.device.systemFont;
        }
        this.dirtyBits = 11;
        Image image = data.image;
        if (image != null) {
            image.memGC = this;
            int prevContext = OS.PmMemStart(context);
            OS.PgSetDrawBufferSize(DrawBufferSize);
            OS.PmMemStop(context);
            OS.PhDCSetCurrent(prevContext);
            if (image.transparentPixel != -1) {
                PhImage_t phImage = new PhImage_t();
                OS.memmove(phImage, image.handle, 56);
                if (phImage.mask_bm != 0) {
                    OS.free(phImage.mask_bm);
                    phImage.mask_bm = 0;
                    phImage.mask_bpl = 0;
                    OS.memmove(image.handle, phImage, 56);
                }
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = context;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRects != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!advanced) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.setClipping((Rectangle)null);
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0) {
            SWT.error(44);
        }
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (antialias) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.dirtyBits |= 1;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern == null) {
            SWT.error(4);
        }
        if (pattern.isDisposed()) {
            SWT.error(5);
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        int clipRects;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if ((clipRects = this.data.clipRects) != 0) {
            OS.free(clipRects);
        }
        clipRects = OS.malloc(8);
        int clipRectsCount = 1;
        PhRect_t rect = new PhRect_t();
        rect.ul_x = (short)x;
        rect.ul_y = (short)y;
        rect.lr_x = (short)(x + width - 1);
        rect.lr_y = (short)(y + height - 1);
        OS.memmove(clipRects, rect, 8);
        this.data.clipRects = clipRects;
        this.data.clipRectsCount = clipRectsCount;
        this.dirtyBits |= 4;
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            int clipRects = this.data.clipRects;
            if (clipRects != 0) {
                OS.free(clipRects);
            }
            this.data.clipRectsCount = 0;
            this.data.clipRects = 0;
            this.dirtyBits |= 4;
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        int clipRects = this.data.clipRects;
        int clipRectsCount = this.data.clipRectsCount;
        if (clipRects != 0) {
            OS.free(clipRects);
        }
        if (region == null || region.handle == 0) {
            clipRectsCount = 0;
            clipRects = 0;
        } else if (region.handle == Region.EMPTY_REGION) {
            clipRects = OS.malloc(8);
            OS.memset(clipRects, 0, 8);
            clipRectsCount = 1;
        } else {
            int[] clip_rects_count = new int[1];
            clipRects = OS.PhTilesToRects(region.handle, clip_rects_count);
            clipRectsCount = clip_rects_count[0];
        }
        this.data.clipRects = clipRects;
        this.data.clipRectsCount = clipRectsCount;
        this.dirtyBits |= 4;
    }

    public void setFillRule(int rule) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (rule) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font == null ? this.data.device.systemFont : font;
        this.dirtyBits |= 8;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.dirtyBits |= 2;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (interpolation) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern == null) {
            SWT.error(4);
        }
        if (pattern.isDisposed()) {
            SWT.error(5);
        }
    }

    public void setLineAttributes(LineAttributes attributes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (attributes == null) {
            SWT.error(4);
        }
    }

    public void setLineCap(int cap) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (cap) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        this.dirtyBits |= 0x40;
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (dashes != null && dashes.length != 0) {
            byte[] dashList = new byte[dashes.length];
            int i = 0;
            while (i < dashes.length) {
                dashList[i] = (byte)dashes[i];
                ++i;
            }
            this.data.dashes = dashList;
            this.data.lineStyle = 6;
        } else {
            this.data.dashes = null;
            this.data.lineStyle = 1;
        }
        this.dirtyBits |= 0x10;
    }

    public void setLineJoin(int join) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (join) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        this.dirtyBits |= 0x80;
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (lineStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.dashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
                return;
            }
        }
        this.data.lineStyle = lineStyle;
        this.dirtyBits |= 0x10;
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.lineWidth = lineWidth;
        this.dirtyBits |= 0x20;
    }

    int setGC() {
        int result = 0;
        if (this.data.image != null) {
            result = OS.PmMemStart(this.handle);
        } else if (this.data.rid == 1 || this.data.widget != 0) {
            result = OS.PgSetGC(this.handle);
        } else {
            return result;
        }
        if (this.dirtyBits != 0) {
            if ((this.dirtyBits & 1) != 0) {
                OS.PgSetFillColor(this.data.background);
            }
            if ((this.dirtyBits & 2) != 0) {
                int foreColor = this.data.foreground;
                OS.PgSetStrokeColor(foreColor);
                OS.PgSetTextColor(foreColor);
            }
            if ((this.dirtyBits & 8) != 0) {
                Font font = this.data.font;
                OS.PfLoadMetrics(font.handle);
                OS.PgSetFont(font.handle);
            }
            if ((this.dirtyBits & 4) != 0) {
                OS.PgSetMultiClip(this.data.clipRectsCount, this.data.clipRects);
            }
            if ((this.dirtyBits & 0x40) != 0) {
                int cap_style = 0;
                switch (this.data.lineCap) {
                    case 2: {
                        cap_style = 1;
                        break;
                    }
                    case 1: {
                        cap_style = 0;
                        break;
                    }
                    case 3: {
                        cap_style = 2;
                    }
                }
                OS.PgSetStrokeCap(cap_style);
            }
            if ((this.dirtyBits & 0x80) != 0) {
                int join_style = 0;
                switch (this.data.lineJoin) {
                    case 2: {
                        join_style = 1;
                        break;
                    }
                    case 1: {
                        join_style = 0;
                        break;
                    }
                    case 3: {
                        join_style = 2;
                    }
                }
                OS.PgSetStrokeJoin(join_style);
            }
            if ((this.dirtyBits & 0x10) != 0) {
                byte[] dashList = null;
                switch (this.data.lineStyle) {
                    case 1: {
                        dashList = DashList[0];
                        break;
                    }
                    case 2: {
                        dashList = DashList[1];
                        break;
                    }
                    case 3: {
                        dashList = DashList[2];
                        break;
                    }
                    case 4: {
                        dashList = DashList[3];
                        break;
                    }
                    case 5: {
                        dashList = DashList[4];
                        break;
                    }
                    case 6: {
                        dashList = this.data.dashes;
                    }
                }
                OS.PgSetStrokeDash(dashList, dashList.length, 65536);
            }
            if ((this.dirtyBits & 0x20) != 0) {
                OS.PgSetStrokeWidth(this.data.lineWidth);
            }
            if ((this.dirtyBits & 0x100) != 0) {
                OS.PgSetDrawMode(this.data.xorMode ? 1 : 0);
            }
            this.dirtyBits = 0;
        }
        return result;
    }

    void setGCClipping() {
        int rid = this.data.rid;
        int widget = this.data.widget;
        if (OS.QNX_MAJOR >= 6 && OS.QNX_MINOR >= 3) {
            if (widget > 0) {
                int visibleTiles = OS.PtGetVisibleTiles(widget);
                if (this.data.clipRects != 0) {
                    int gcClip = OS.PhRectsToTiles(this.data.clipRects, this.data.clipRectsCount);
                    PhPoint_t pt = new PhPoint_t();
                    PhRect_t tran_rect = new PhRect_t();
                    OS.PtWidgetExtent(widget, tran_rect);
                    OS.PtWidgetOffset(widget, pt);
                    pt.x = (short)(pt.x + tran_rect.ul_x);
                    pt.y = (short)(pt.y + tran_rect.ul_y);
                    OS.PhTranslateTiles(gcClip, pt);
                    int inter = OS.PhIntersectTilings(visibleTiles, gcClip, new short[1]);
                    if (inter != 0) {
                        OS.PgSetMultiClipTiles(inter);
                        OS.free(inter);
                    }
                    OS.free(gcClip);
                } else {
                    OS.PgSetMultiClipTiles(visibleTiles);
                }
                OS.free(visibleTiles);
            }
            return;
        }
        if (rid == 1) {
            OS.PgSetRegion(rid);
        } else if (widget != 0) {
            OS.PgSetRegion(OS.PtWidgetRid(widget));
        } else if (this.data.image != null) {
            return;
        }
        if (widget == 0) {
            return;
        }
        OS.PgSetMultiClip(this.data.clipRectsCount, this.data.clipRects);
        int clip_tile = this.getClipping(widget, this.data.topWidget, true, true, null);
        int[] clip_rects_count = new int[1];
        int clip_rects = OS.PhTilesToRects(clip_tile, clip_rects_count);
        OS.PhFreeTiles(clip_tile);
        if (clip_rects_count[0] == 0) {
            clip_rects_count[0] = 1;
            OS.free(clip_rects);
            clip_rects = OS.malloc(8);
            OS.memset(clip_rects, 0, 8);
        }
        OS.PgSetClipping((short)clip_rects_count[0], clip_rects);
        OS.free(clip_rects);
    }

    void setGCTranslation() {
        PhPoint_t pt = new PhPoint_t();
        PhRect_t tran_rect = new PhRect_t();
        if (this.data.widget <= 0) {
            return;
        }
        OS.PtWidgetExtent(this.data.widget, tran_rect);
        OS.PtWidgetOffset(this.data.widget, pt);
        pt.x = (short)(pt.x + tran_rect.ul_x);
        pt.y = (short)(pt.y + tran_rect.ul_y);
        OS.PgSetTranslation(pt, 0);
    }

    int getClipping(int widget, int topWidget, boolean clipChildren, boolean clipSiblings, int[] child_tiles) {
        int basic_flags;
        int tile;
        int temp_widget;
        if (OS.QNX_MAJOR >= 6 && OS.QNX_MINOR >= 3) {
            if (widget > 0) {
                int visTiles = OS.PtGetVisibleTiles(widget);
                PhPoint_t pt = new PhPoint_t();
                PhRect_t tranRect = new PhRect_t();
                OS.PtWidgetExtent(widget, tranRect);
                OS.PtWidgetOffset(widget, pt);
                pt.x = (short)(pt.x + tranRect.ul_x);
                pt.y = (short)(pt.y + tranRect.ul_y);
                int tranPoint = OS.malloc(4);
                OS.memmove(tranPoint, pt, 4);
                OS.PhDeTranslateTiles(visTiles, tranPoint);
                return visTiles;
            }
            return 0;
        }
        int child_tile = 0;
        int widget_tile = OS.PhGetTile();
        PhRect_t rect = new PhRect_t();
        int[] nArray = new int[6];
        nArray[0] = 1006;
        nArray[3] = 2015;
        int[] args = nArray;
        if (clipSiblings && OS.PtWidgetClass(topWidget) != OS.PtWindow()) {
            temp_widget = topWidget;
            while ((temp_widget = OS.PtWidgetBrotherInFront(temp_widget)) != 0) {
                if (!OS.PtWidgetIsRealized(temp_widget)) continue;
                tile = OS.PhGetTile();
                child_tile = child_tile == 0 ? tile : OS.PhAddMergeTiles(tile, child_tile, null);
                OS.PtWidgetExtent(temp_widget, tile);
                args[4] = 0;
                args[1] = 0;
                OS.PtGetResources(temp_widget, args.length / 3, args);
                if ((args[1] & 0x100) == 0) continue;
                basic_flags = args[4];
                OS.memmove(rect, tile, 8);
                if ((basic_flags & 1) != 0) {
                    rect.ul_y = (short)(rect.ul_y + 1);
                }
                if ((basic_flags & 2) != 0) {
                    rect.lr_y = (short)(rect.lr_y - 1);
                }
                if ((basic_flags & 8) != 0) {
                    rect.ul_x = (short)(rect.ul_x + 1);
                }
                if ((basic_flags & 4) != 0) {
                    rect.lr_x = (short)(rect.lr_x - 1);
                }
                OS.memmove(tile, rect, 8);
            }
            OS.PtWidgetCanvas(topWidget, widget_tile);
            OS.PhDeTranslateTiles(child_tile, widget_tile);
        }
        if (clipChildren) {
            temp_widget = OS.PtWidgetChildBack(widget);
            while (temp_widget != 0) {
                if (OS.PtWidgetIsRealized(temp_widget)) {
                    tile = OS.PhGetTile();
                    child_tile = child_tile == 0 ? tile : OS.PhAddMergeTiles(tile, child_tile, null);
                    OS.PtWidgetExtent(temp_widget, tile);
                    args[4] = 0;
                    args[1] = 0;
                    OS.PtGetResources(temp_widget, args.length / 3, args);
                    if ((args[1] & 0x100) != 0) {
                        basic_flags = args[4];
                        OS.memmove(rect, tile, 8);
                        if ((basic_flags & 1) != 0) {
                            rect.ul_y = (short)(rect.ul_y + 1);
                        }
                        if ((basic_flags & 2) != 0) {
                            rect.lr_y = (short)(rect.lr_y - 1);
                        }
                        if ((basic_flags & 8) != 0) {
                            rect.ul_x = (short)(rect.ul_x + 1);
                        }
                        if ((basic_flags & 4) != 0) {
                            rect.lr_x = (short)(rect.lr_x - 1);
                        }
                        OS.memmove(tile, rect, 8);
                    }
                }
                temp_widget = OS.PtWidgetBrotherInFront(temp_widget);
            }
        }
        OS.PtWidgetCanvas(widget, widget_tile);
        OS.PhDeTranslateTiles(widget_tile, widget_tile);
        if (child_tile != 0) {
            if (child_tiles != null) {
                child_tiles[0] = OS.PhIntersectTilings(widget_tile, child_tile, new short[1]);
            }
            int clip_tile = OS.PhClipTilings(widget_tile, child_tile, null);
            OS.PhFreeTiles(child_tile);
            return clip_tile;
        }
        return widget_tile;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (antialias) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.xorMode = xor;
        this.dirtyBits |= 0x100;
    }

    public Point stringExtent(String string) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        PhRect_t rect = new PhRect_t();
        int size = string.length();
        char[] buffer = new char[size];
        string.getChars(0, size, buffer, 0);
        int flags = OS.PtEnter(0);
        try {
            OS.PfExtentWideText(rect, null, this.data.font.handle, buffer, size * 2);
        }
        finally {
            if (flags >= 0) {
                OS.PtLeave(flags);
            }
        }
        int width = size == 0 ? 0 : rect.lr_x - (rect.ul_x < 0 ? rect.ul_x : (short)0) + 1;
        int height = rect.lr_y - rect.ul_y + 1;
        return new Point(width, height);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((flags & 0xFFFFFFFE) == 0 || string.length() == 0) {
            return this.stringExtent(string);
        }
        return this.drawText(string, 0, 0, flags, false);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    void unsetGC(int prevContext) {
        Image image = this.data.image;
        if (image != null) {
            OS.PmMemStop(this.handle);
            OS.PhDCSetCurrent(prevContext);
        } else if (this.data.rid == 1 || this.data.widget != 0) {
            OS.PgSetGC(prevContext);
        }
    }

    public static GC photon_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int context = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, context);
        return gc;
    }
}

