/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class Snippet013TableViewerEditing {
    public static void main(String[] args) {
        final Display display = new Display();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                ViewModel viewModel = new ViewModel();
                Shell shell = new View(viewModel).createShell();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private static class InlineEditingSupport
    extends ObservableValueEditingSupport {
        private CellEditor cellEditor;

        public InlineEditingSupport(ColumnViewer viewer, DataBindingContext dbc) {
            super(viewer, dbc);
            this.cellEditor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            return SWTObservables.observeText((Control)cellEditor.getControl(), (int)24);
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            return BeansObservables.observeValue((Object)element, (String)"name");
        }
    }

    static class Person
    extends AbstractModelObject {
        String name = "John Smith";

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }
    }

    static class View {
        private ViewModel viewModel;
        private Table committers;
        private Label selectedCommitter;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new FillLayout(512));
            this.committers = new Table((Composite)shell, 67584);
            this.committers.setLinesVisible(true);
            this.selectedCommitter = new Label((Composite)shell, 0);
            DataBindingContext bindingContext = new DataBindingContext();
            this.bindGUI(bindingContext);
            shell.setSize(100, 300);
            shell.open();
            return shell;
        }

        protected void bindGUI(DataBindingContext bindingContext) {
            TableViewer peopleViewer = new TableViewer(this.committers);
            TableViewerColumn column = new TableViewerColumn(peopleViewer, 0);
            column.setEditingSupport((EditingSupport)new InlineEditingSupport((ColumnViewer)peopleViewer, bindingContext));
            column.getColumn().setWidth(100);
            ViewerSupport.bind((StructuredViewer)peopleViewer, (IObservableList)new WritableList(this.viewModel.getPeople(), Person.class), (IValueProperty)BeanProperties.value(Person.class, (String)"name"));
            IViewerObservableValue selection = ViewersObservables.observeSingleSelection((Viewer)peopleViewer);
            bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.selectedCommitter), BeansObservables.observeDetailValue((IObservableValue)selection, (String)"name", String.class));
        }
    }

    static class ViewModel {
        private List people = new LinkedList();

        ViewModel() {
            this.people.add(new Person("Steve Northover"));
            this.people.add(new Person("Grant Gayed"));
            this.people.add(new Person("Veronika Irvine"));
            this.people.add(new Person("Mike Wilson"));
            this.people.add(new Person("Christophe Cornu"));
            this.people.add(new Person("Lynne Kues"));
            this.people.add(new Person("Silenio Quarti"));
        }

        public List getPeople() {
            return this.people;
        }
    }
}

