/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.Collections;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ListeningLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.examples.databinding.contentprovider.test.RenamableItem;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LabelProviderTest {
    private Shell shell;
    private ListViewer list;
    private WritableSet setOfRenamables;
    private Button addButton;
    private Button removeButton;
    private Button renameButton;
    private SelectionListener buttonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button pressed = (Button)e.widget;
            if (pressed == LabelProviderTest.this.addButton) {
                LabelProviderTest.this.setOfRenamables.add((Object)new RenamableItem());
            } else if (pressed == LabelProviderTest.this.removeButton) {
                LabelProviderTest.this.setOfRenamables.remove((Object)LabelProviderTest.this.getCurrentSelection());
            } else if (pressed == LabelProviderTest.this.renameButton) {
                LabelProviderTest.this.rename(LabelProviderTest.this.getCurrentSelection());
            }
            super.widgetSelected(e);
        }
    };
    private IObservableValue selectedRenamable;

    public LabelProviderTest() {
        this.shell = new Shell(Display.getCurrent());
        this.setOfRenamables = new WritableSet();
        this.list = new ListViewer((Composite)this.shell);
        ObservableSetContentProvider contentProvider = new ObservableSetContentProvider();
        this.list.setContentProvider((IContentProvider)contentProvider);
        this.list.setLabelProvider((IBaseLabelProvider)new ListeningLabelProvider(contentProvider.getKnownElements()){
            RenamableItem.Listener listener;
            {
                this.listener = new RenamableItem.Listener(){

                    public void handleChanged(RenamableItem item) {
                        this.fireChangeEvent(Collections.singleton(item));
                    }
                };
            }

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof RenamableItem) {
                    RenamableItem item = (RenamableItem)element;
                    label.setText(item.getName());
                }
            }

            protected void addListenerTo(Object next) {
                RenamableItem item = (RenamableItem)next;
                item.addListener(this.listener);
            }

            protected void removeListenerFrom(Object next) {
                RenamableItem item = (RenamableItem)next;
                item.removeListener(this.listener);
            }
        });
        this.list.setInput((Object)this.setOfRenamables);
        this.selectedRenamable = ViewersObservables.observeSingleSelection((Viewer)this.list);
        Composite buttonBar = new Composite((Composite)this.shell, 0);
        this.addButton = new Button(buttonBar, 8);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener(this.buttonSelectionListener);
        this.removeButton = new Button(buttonBar, 8);
        this.removeButton.addSelectionListener(this.buttonSelectionListener);
        this.removeButton.setText("Remove");
        this.renameButton = new Button(buttonBar, 8);
        this.renameButton.addSelectionListener(this.buttonSelectionListener);
        this.renameButton.setText("Rename");
        this.selectedRenamable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                boolean shouldEnable = LabelProviderTest.this.selectedRenamable.getValue() != null;
                LabelProviderTest.this.removeButton.setEnabled(shouldEnable);
                LabelProviderTest.this.renameButton.setEnabled(shouldEnable);
            }
        });
        this.removeButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        GridLayoutFactory.fillDefaults().generateLayout(buttonBar);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)this.shell);
    }

    protected void rename(RenamableItem currentSelection) {
        InputDialog inputDialog = new InputDialog(this.shell, "Edit name", "Enter the new item name", currentSelection.getName(), null);
        if (inputDialog.open() == 0) {
            currentSelection.setName(inputDialog.getValue());
        }
    }

    protected RenamableItem getCurrentSelection() {
        return (RenamableItem)this.selectedRenamable.getValue();
    }

    public static void main(String[] args) {
        final Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                LabelProviderTest test = new LabelProviderTest();
                Shell s = test.getShell();
                s.pack();
                s.setVisible(true);
                while (!s.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
        display.dispose();
    }

    private Shell getShell() {
        return this.shell;
    }
}

