/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class SelectionAnalyzer
extends GenericVisitor {
    private Selection fSelection;
    private boolean fTraverseSelectedNode;
    private ASTNode fLastCoveringNode;
    private List fSelectedNodes;

    public SelectionAnalyzer(Selection selection, boolean traverseSelectedNode) {
        super(true);
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
        this.fTraverseSelectedNode = traverseSelectedNode;
    }

    public boolean hasSelectedNodes() {
        return this.fSelectedNodes != null && !this.fSelectedNodes.isEmpty();
    }

    public ASTNode[] getSelectedNodes() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return new ASTNode[0];
        }
        return this.fSelectedNodes.toArray(new ASTNode[this.fSelectedNodes.size()]);
    }

    public ASTNode getFirstSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return (ASTNode)this.fSelectedNodes.get(0);
    }

    public ASTNode getLastSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return (ASTNode)this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
    }

    public boolean isExpressionSelected() {
        if (!this.hasSelectedNodes()) {
            return false;
        }
        return this.fSelectedNodes.get(0) instanceof Expression;
    }

    public IRegion getSelectedNodeRange() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        ASTNode firstNode = (ASTNode)this.fSelectedNodes.get(0);
        ASTNode lastNode = (ASTNode)this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
        int start = firstNode.getStartPosition();
        return new Region(start, lastNode.getStartPosition() + lastNode.getLength() - start);
    }

    public ASTNode getLastCoveringNode() {
        return this.fLastCoveringNode;
    }

    protected Selection getSelection() {
        return this.fSelection;
    }

    protected boolean visitNode(ASTNode node) {
        if (this.fSelection.liesOutside(node)) {
            return false;
        }
        if (this.fSelection.covers(node)) {
            if (this.isFirstNode()) {
                this.handleFirstSelectedNode(node);
            } else {
                this.handleNextSelectedNode(node);
            }
            return this.fTraverseSelectedNode;
        }
        if (this.fSelection.coveredBy(node)) {
            this.fLastCoveringNode = node;
            return true;
        }
        if (this.fSelection.endsIn(node)) {
            return this.handleSelectionEndsIn(node);
        }
        return true;
    }

    protected void reset() {
        this.fSelectedNodes = null;
    }

    protected void handleFirstSelectedNode(ASTNode node) {
        this.fSelectedNodes = new ArrayList(5);
        this.fSelectedNodes.add(node);
    }

    protected void handleNextSelectedNode(ASTNode node) {
        if (this.getFirstSelectedNode().getParent() == node.getParent()) {
            this.fSelectedNodes.add(node);
        }
    }

    protected boolean handleSelectionEndsIn(ASTNode node) {
        return false;
    }

    protected List internalGetSelectedNodes() {
        return this.fSelectedNodes;
    }

    private boolean isFirstNode() {
        return this.fSelectedNodes == null;
    }
}

