/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.examples.ui.pda.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MidiLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        IFile file;
        ILaunchConfiguration configuration;
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IFile && (configuration = this.getConfiguration(file = (IFile)element)) != null) {
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
    }

    private ILaunchConfiguration getConfiguration(IFile file) {
        ArrayList<ILaunchConfiguration> candiates = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configurations = this.getLaunchManager().getLaunchConfigurations(this.getLaunchType());
            int i = 0;
            while (i < configurations.length) {
                ILaunchConfiguration configuration = configurations[i];
                IResource[] resources = configuration.getMappedResources();
                if (resources != null && resources.length == 1 && resources[0].equals((Object)file)) {
                    candiates.add(configuration);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        if (!candiates.isEmpty()) {
            return this.chooseConfiguration(candiates);
        }
        return this.newConfiguration(file);
    }

    private ILaunchConfigurationType getLaunchType() {
        ILaunchManager manager = this.getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("midi.launchType");
        return type;
    }

    private ILaunchManager getLaunchManager() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager;
    }

    private ILaunchConfiguration chooseConfiguration(List configList) {
        if (configList.size() == 1) {
            return (ILaunchConfiguration)configList.get(0);
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DebugUIPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select Configuraiton");
        dialog.setMessage("&Select an existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration newConfiguration(IFile file) {
        ILaunchConfigurationType type = this.getLaunchType();
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName("[" + file.getProject().getName() + "] " + file.getName()));
            workingCopy.setAttribute("midi.file", file.getFullPath().toString());
            workingCopy.setMappedResources(new IResource[]{file});
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }
}

