/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.core.builders;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ds.core.Activator;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.Messages;
import org.eclipse.pde.internal.ds.core.builders.DSJavaHelper;
import org.eclipse.pde.internal.ds.core.builders.XMLErrorReporter;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.osgi.framework.InvalidSyntaxException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DSErrorReporter
extends XMLErrorReporter {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int IGNORE = 2;

    public DSErrorReporter(IFile file) {
        super(file);
    }

    public void validateContent(IProgressMonitor monitor) {
        try {
            Document textDocument = CoreUtility.getTextDocument((InputStream)this.fFile.getContents());
            DSModel model = new DSModel((IDocument)textDocument, false);
            model.load();
            IDSComponent component = model.getDSComponent();
            this.validateComponentElement(component);
            this.validateImplementationElement(component.getImplementation());
            this.validateServiceElement(component.getService());
            this.validatePropertyElements(component.getPropertyElements());
            this.validatePropertiesElements(component.getPropertiesElements());
            this.validateReferenceElements(component.getReferences());
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private void validateBoolean(Element element, Attr attr) {
        String value;
        if (attr != null && !(value = attr.getValue()).equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            this.reportIllegalAttributeValue(element, attr);
        }
    }

    private void reportIllegalAttributeValue(Element element, Attr attr) {
        if (attr == null || attr.getValue() == null || attr.getName() == null) {
            return;
        }
        String message = NLS.bind((String)Messages.DSErrorReporter_attrValue, (Object)attr.getValue(), (Object)attr.getName());
        this.report(message, this.getLine(element, attr.getName()), 0, "");
    }

    private void validateReferenceElements(IDSReference[] references) {
        Hashtable referencedNames = new Hashtable();
        int i = 0;
        while (i < references.length) {
            IDSReference reference = references[i];
            Element element = (Element)this.getElements((IDocumentElementNode)reference).item(i);
            if (reference.getReferenceInterface() == null) {
                this.reportMissingRequiredAttribute(element, "interface", 0);
            } else {
                this.validateJavaElement(reference.getReferenceInterface(), "reference", "interface", i);
            }
            this.validateReferenceCardinality(element);
            this.validateReferencePolicy(element);
            this.validateReferenceElementNames(referencedNames, element);
            this.validateTargetAttribute(element);
            ++i;
        }
    }

    private void validateTargetAttribute(Element element) {
        Attr attr = element.getAttributeNode("target");
        if (attr != null) {
            String value = attr.getValue();
            try {
                Activator.getDefault().getBundle().getBundleContext().createFilter(value);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                this.reportInvalidTarget(element, value);
            }
        }
    }

    private void reportInvalidTarget(Element element, String target) {
        String name = element.getAttribute("name");
        String message = NLS.bind((String)Messages.DSErrorReporter_invalidTarget, (Object)name, (Object)target);
        this.report(message, this.getLine(element), 0, "");
    }

    private void validateReferenceElementNames(Hashtable referencedNames, Element element) {
        String name = element.getAttribute("name");
        if (name != null && referencedNames.containsKey(name)) {
            this.reportDuplicateReferenceElementName(element, name);
        } else {
            referencedNames.put(name, name);
        }
    }

    private void reportDuplicateReferenceElementName(Element element, String name) {
        Attr attr = element.getAttributeNode("name");
        if (attr == null || attr.getValue() == null || attr.getName() == null) {
            return;
        }
        String message = NLS.bind((String)Messages.DSErrorReporter_duplicateReferenceName, (Object)name);
        this.report(message, this.getLine(element, "name"), 0, "");
    }

    private void validateReferencePolicy(Element element) {
        String attribute = element.getAttribute("policy");
        String[] allowedValues = new String[]{"dynamic", "static"};
        if (attribute != null && attribute.length() > 0) {
            int i = 0;
            while (i < allowedValues.length) {
                if (allowedValues[i].equalsIgnoreCase(attribute)) {
                    return;
                }
                ++i;
            }
            this.reportIllegalPolicy(element, attribute);
        }
    }

    private void reportIllegalPolicy(Element element, String policy) {
        String name = element.getAttribute("name");
        if (name == null) {
            name = element.getAttribute("interface");
        }
        String message = NLS.bind((String)Messages.DSErrorReporter_invalidPolicyValue, (Object)name, (Object)policy);
        Attr attr = element.getAttributeNode("policy");
        this.report(message, this.getLine(element, attr.getName()), 0, "");
    }

    private void validateReferenceCardinality(Element element) {
        String cardinality = element.getAttribute("cardinality");
        String[] allowedValues = new String[]{"1..n", "1..1", "0..n", "0..1"};
        if (cardinality != null) {
            int i = 0;
            while (i < allowedValues.length) {
                if (allowedValues[i].equalsIgnoreCase(cardinality)) {
                    return;
                }
                ++i;
            }
            this.reportIllegalCardinality(element, cardinality);
        }
    }

    private void reportIllegalCardinality(Element element, String cardinality) {
        String name = element.getAttribute("name");
        if (name == null) {
            name = element.getAttribute("interface");
        }
        String message = NLS.bind((String)Messages.DSErrorReporter_invalidCardinalityValue, (Object)name, (Object)cardinality);
        Attr attr = element.getAttributeNode("cardinality");
        if (attr == null || attr.getValue() == null || attr.getName() == null) {
            return;
        }
        this.report(message, this.getLine(element, attr.getName()), 0, "");
    }

    private void validatePropertiesElements(IDSProperties[] propertiesElements) {
        int i = 0;
        while (i < propertiesElements.length) {
            IDSProperties properties = propertiesElements[i];
            Element element = (Element)this.getElements((IDocumentElementNode)properties).item(i);
            if (properties.getEntry() == null || properties.getEntry().length() == 0) {
                this.reportMissingRequiredAttribute(element, "entry", 0);
            } else if (!this.fProject.exists((IPath)new Path(properties.getEntry()))) {
                this.report(NLS.bind((String)Messages.DSErrorReporter_cannotFindProperties, (Object)properties.getEntry()), this.getLine(element), 1, "");
            }
            ++i;
        }
    }

    private void validatePropertyElements(IDSProperty[] propertyElements) {
        int i = 0;
        while (i < propertyElements.length) {
            IDSProperty property = propertyElements[i];
            Element element = (Element)this.getElements((IDocumentElementNode)property).item(i);
            String name = property.getName();
            if (name == null || name.length() == 0) {
                this.reportMissingRequiredAttribute(element, "name", 0);
            }
            this.validatePropertyTypes(element);
            this.validatePropertyAttrValueAndBody(element, property);
            this.validatePropertyTypesValues(element, property);
            ++i;
        }
    }

    private void validatePropertyTypesValues(Element element, IDSProperty property) {
        String type = property.getPropertyType();
        String value = property.getPropertyValue();
        String body = property.getPropertyElemBody();
        if (value != null && value.length() > 0) {
            this.validatePropertySpecificTypeValue(type, value, element);
        } else if (body != null && body.length() > 0) {
            this.validatePropertySpecificTypeBody(type, body, element);
        }
    }

    private void validatePropertySpecificTypeBody(String type, String body, Element element) {
        StringTokenizer st = new StringTokenizer(body, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = token.trim()).length() <= 0) continue;
            this.validatePropertySpecificTypeValue(type, token, element);
        }
    }

    private void validatePropertySpecificTypeValue(String type, String value, Element element) {
        if (type == null) {
            type = "String";
        }
        if (!type.equals("Character") && !type.equals("Boolean")) {
            try {
                Class<?> forName = Class.forName("java.lang." + type);
                Constructor<?>[] constructors = forName.getConstructors();
                int i = 0;
                while (i < constructors.length) {
                    Constructor<?> constructor = constructors[i];
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length == 1 && parameterTypes[0].equals(Class.forName("java.lang.String"))) {
                        constructor.newInstance(value);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                this.reportPropertyTypeCastException(element, value, type);
            }
        } else if (type.equals("Boolean")) {
            if (!value.equals("false") && !value.equals("true")) {
                this.reportPropertyTypeCastException(element, value, type);
            }
        } else if (type.equals("Character") && value.length() > 1) {
            this.reportPropertyTypeCastException(element, value, type);
        }
    }

    private void reportPropertyTypeCastException(Element element, String value, String type) {
        String message = NLS.bind((String)Messages.DSErrorReporter_propertyTypeCastException, (Object[])new String[]{value, type});
        this.report(message, this.getLine(element), 1, "");
    }

    private void validatePropertyAttrValueAndBody(Element element, IDSProperty property) {
        if (property.getPropertyValue() != null) {
            String propertyType;
            if (property.getPropertyElemBody() != null && !property.getPropertyElemBody().equals("")) {
                String propertyName = property.getPropertyName();
                this.reportSingleAndMultiplePropertyValues(element, propertyName, property.getPropertyValue());
            }
            if ((propertyType = property.getPropertyType()) == null || propertyType.equals("String")) {
                return;
            }
            if (property.getPropertyValue().equals("")) {
                String propertyName = property.getPropertyName();
                this.reportEmptyPropertyValue(element, propertyName);
            }
        } else if (property.getPropertyElemBody() == null || property.getPropertyElemBody().equals("")) {
            String propertyName = property.getPropertyName();
            this.reportEmptyPropertyValue(element, propertyName);
        }
    }

    private void reportEmptyPropertyValue(Element element, String propertyName) {
        String message = NLS.bind((String)Messages.DSErrorReporter_emptyPropertyValue, (Object)propertyName);
        this.report(message, this.getLine(element), 1, "");
    }

    private void reportSingleAndMultiplePropertyValues(Element element, String propertyName, String value) {
        String message = NLS.bind((String)Messages.DSErrorReporter_singleAndMultipleAttrValue, (Object)propertyName, (Object)value);
        this.report(message, this.getLine(element), 1, "");
    }

    private void validatePropertyTypes(Element element) {
        String attribute = element.getAttribute("type");
        String[] allowedValues = new String[]{"Boolean", "Byte", "Character", "Double", "Float", "Integer", "Long", "Short", "String"};
        if (attribute != null) {
            int i = 0;
            while (i < allowedValues.length) {
                if (allowedValues[i].equalsIgnoreCase(attribute)) {
                    return;
                }
                ++i;
            }
            this.reportIllegalAttributeValue(element, element.getAttributeNode("type"));
        }
    }

    private void validateImplementationElement(IDSImplementation implementation) {
        if (implementation != null) {
            String className = implementation.getClassName();
            Element element = (Element)this.getElements((IDocumentElementNode)implementation).item(0);
            if (className == null) {
                this.reportMissingRequiredAttribute(element, "class", 0);
            } else {
                this.validateJavaElement(className, "implementation", "class", 0);
            }
        }
    }

    private void validateJavaElement(String fullyQualifiedName, String elementName, String attrName, int index) {
        try {
            IJavaProject jp;
            if (this.fProject.hasNature("org.eclipse.jdt.core.javanature") && !DSJavaHelper.isOnClasspath(fullyQualifiedName, jp = JavaCore.create((IProject)this.fProject))) {
                this.reportJavaTypeNotFound(elementName, attrName, fullyQualifiedName, index);
            }
        }
        catch (CoreException coreException) {}
    }

    private void reportMissingRequiredAttribute(Element element, String attName, int severity) {
        String message = NLS.bind((String)Messages.DSErrorReporter_requiredAttribute, (Object)attName, (Object)element.getNodeName());
        this.report(message, this.getLine(element), severity, "");
    }

    private void reportJavaTypeNotFound(String elementConstant, String attributeConstant, String resource, int index) {
        Element documentRoot = this.getDocumentRoot();
        NodeList elementsByTagName = documentRoot.getElementsByTagName(elementConstant);
        Element element = (Element)elementsByTagName.item(index);
        this.report(NLS.bind((String)Messages.DSErrorReporter_cannotFindJavaType, (Object)resource, (Object)attributeConstant), this.getLine(element), 1, "");
    }

    private void validateComponentElement(IDSComponent component) {
        if (component != null) {
            Element element = this.getDocumentRoot();
            if (component.getImplementation() == null) {
                this.report(NLS.bind((String)Messages.DSErrorReporter_requiredElement, (Object)"implementation"), this.getLine(this.getDocumentRoot()), 0, "");
            }
            this.validateBoolean(element, element.getAttributeNode("immediate"));
            this.validateBoolean(element, element.getAttributeNode("enabled"));
            this.validateEmpty(element, element.getAttributeNode("factory"));
            this.validateEmpty(element, element.getAttributeNode("name"));
            this.validateImmediateAttribute(element, component);
            this.validateConfigurationPolicyAttribute(element, component);
        }
    }

    private void validateConfigurationPolicyAttribute(Element element, IDSComponent component) {
        String modified = component.getModifiedMethod();
        String policy = component.getConfigurationPolicy();
        if (policy != null && policy.length() > 0 && policy.equalsIgnoreCase("ignore") && modified != null && modified.length() > 0) {
            this.report(Messages.DSErrorReporter_invalidConfigurationPolicyValue, this.getLine(element), 1, "");
        }
    }

    private void validateImmediateAttribute(Element element, IDSComponent component) {
        IDSProvide[] providedServices;
        boolean isService = false;
        boolean isFactory = component.getFactory() != null;
        boolean isImmediate = component.getImmediate();
        if (component.getService() != null && (providedServices = component.getService().getProvidedServices()) != null && providedServices.length > 0) {
            isService = true;
        }
        if (!(isService || isFactory || isImmediate || component.getXMLAttributeValue("immediate") == null)) {
            this.reportInvalidImmediate(element);
        }
        if (isFactory && isImmediate) {
            this.reportInvalidImmediateFactory(element);
        }
    }

    private void reportInvalidImmediateFactory(Element element) {
        this.report(Messages.DSErrorReporter_invalidImmediateValueFactory, this.getLine(element), 1, "");
    }

    private void reportInvalidImmediate(Element element) {
        this.report(Messages.DSErrorReporter_invalidImmediateValue, this.getLine(element), 1, "");
    }

    private void validateEmpty(Element element, Attr attr) {
        String value;
        if (attr != null && (value = attr.getValue()).equalsIgnoreCase("")) {
            this.reportIllegalEmptyAttributeValue(element, attr);
        }
    }

    private void reportIllegalEmptyAttributeValue(Element element, Attr attr) {
        if (attr == null || attr.getValue() == null || attr.getName() == null) {
            return;
        }
        String message = NLS.bind((String)Messages.DSErrorReporter_emptyAttrValue, (Object)attr.getName());
        this.report(message, this.getLine(element, attr.getName()), 0, "");
    }

    private void validateServiceElement(IDSService service) {
        if (service != null) {
            Element element = (Element)this.getElements((IDocumentElementNode)service).item(0);
            this.validateBoolean(element, element.getAttributeNode("servicefactory"));
            this.validateServiceFactory(element, service);
            IDSProvide[] providedServices = service.getProvidedServices();
            if (providedServices.length == 0) {
                this.reportEmptyService(element);
            } else {
                this.validateProvideElement(providedServices);
            }
        }
    }

    private void reportEmptyService(Element element) {
        this.report(Messages.DSErrorReporter_illegalEmptyService, this.getLine(element), 0, "");
    }

    private void validateServiceFactory(Element element, IDSService service) {
        IDSComponent component = service.getComponent();
        boolean isFactory = component.getFactory() != null;
        boolean isImmediate = component.getImmediate();
        if (isFactory && service.getServiceFactory()) {
            this.reportIllegalServiceFactory(element);
        }
        if (isImmediate && service.getServiceFactory()) {
            this.reportIllegalServiceFactory_Immediate(element);
        }
    }

    private void reportIllegalServiceFactory_Immediate(Element element) {
        this.report(Messages.DSErrorReporter_illegalServiceFactory_Immediate, this.getLine(element), 0, "");
    }

    private void reportIllegalServiceFactory(Element element) {
        this.report(Messages.DSErrorReporter_illegalServiceFactory, this.getLine(element), 0, "");
    }

    private void validateProvideElement(IDSProvide[] providedServices) {
        Hashtable providedInterfaces = new Hashtable();
        int i = 0;
        while (i < providedServices.length) {
            IDSProvide provide = providedServices[i];
            Element element = (Element)this.getElements((IDocumentElementNode)provide).item(i);
            if (provide.getInterface() == null) {
                this.reportMissingRequiredAttribute(element, "interface", 0);
            } else {
                this.validateJavaElement(provide.getInterface(), "provide", "interface", i);
                this.validateDuplicateInterface(providedInterfaces, provide, element);
            }
            ++i;
        }
    }

    private void validateDuplicateInterface(Hashtable providedInterfaces, IDSProvide provide, Element element) {
        String interface1 = provide.getInterface();
        if (providedInterfaces.get(interface1) != null) {
            String message = NLS.bind((String)Messages.DSErrorReporter_duplicatedInterface, (Object)interface1);
            this.report(message, this.getLine(element), 1, "");
        } else {
            providedInterfaces.put(interface1, interface1);
        }
    }

    private NodeList getElements(IDocumentElementNode node) {
        String name = node.getXMLTagName();
        String prefix = node.getNamespacePrefix();
        if (prefix != null && prefix.length() > 0) {
            name = String.valueOf(prefix) + ":" + name;
        }
        return this.getDocumentRoot().getElementsByTagName(name);
    }
}

