/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class ContextServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PARAMETER_ID = "id";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BaseHelpSystem.checkMode();
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        String id = req.getParameter(PARAMETER_ID);
        if (id != null) {
            IContext context = this.getContext(locale, id);
            if (context != null) {
                this.serialize(context, resp.getWriter());
            } else {
                resp.sendError(404);
            }
        } else {
            resp.sendError(400);
        }
    }

    protected IContext getContext(String locale, String id) {
        IContext context = HelpPlugin.getContextManager().getContext(id, locale);
        return context;
    }

    private void serialize(IContext context, Writer out) throws IOException {
        String title;
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<context");
        if (context instanceof IContext2 && (title = ((IContext2)context).getTitle()) != null && title.length() > 0) {
            out.write(" title=\"" + title + "\"");
        }
        out.write(">\n");
        out.write("   <description>" + context.getText() + "</description>\n");
        IHelpResource[] topics = context.getRelatedTopics();
        int i = 0;
        while (i < topics.length) {
            out.write("   <topic");
            if (topics[i].getLabel() != null) {
                out.write("\n         label=\"" + topics[i].getLabel() + '\"');
            }
            if (topics[i].getHref() != null) {
                out.write("\n         href=\"" + topics[i].getHref() + '\"');
            }
            out.write(">\n   </topic>");
            ++i;
        }
        out.write("</context>\n");
    }
}

