/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.ILaunchConfigurationTab;

public final class LaunchConfigurationTabExtension {
    IConfigurationElement fElement = null;
    private Set fDelegates = null;

    public LaunchConfigurationTabExtension(IConfigurationElement element) {
        this.fElement = element;
    }

    public String getIdentifier() {
        return this.fElement.getAttribute("id");
    }

    public String getName() {
        return this.fElement.getAttribute("name");
    }

    public ILaunchConfigurationTab getTab() {
        try {
            Object object = this.fElement.createExecutableExtension("class");
            if (object instanceof ILaunchConfigurationTab) {
                return (ILaunchConfigurationTab)object;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return null;
    }

    public String getTabGroupId() {
        return this.fElement.getAttribute("group");
    }

    public String getRelativeTabId() {
        IConfigurationElement[] elems = this.fElement.getChildren("placement");
        if (elems.length == 1) {
            return elems[0].getAttribute("after");
        }
        return null;
    }

    public String getPluginIdentifier() {
        return this.fElement.getContributor().getName();
    }

    public Set getDelegateSet() {
        if (this.fDelegates == null) {
            this.fDelegates = new HashSet();
            IConfigurationElement[] children = this.fElement.getChildren("associatedDelegate");
            String id = null;
            int i = 0;
            while (i < children.length) {
                id = children[i].getAttribute("delegate");
                if (id != null) {
                    this.fDelegates.add(id);
                }
                ++i;
            }
        }
        return this.fDelegates;
    }
}

