/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdvancedPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class InstallSection
extends PDESection {
    private Button fExclusiveButton;
    private FormEntry fColocationText;
    private boolean fBlockNotification;

    public InstallSection(FeatureAdvancedPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEUIMessages.FeatureEditor_InstallSection_title);
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_InstallSection_desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void commit(boolean onSave) {
        this.fColocationText.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        final IFeature feature = model.getFeature();
        this.fExclusiveButton = toolkit.createButton(container, PDEUIMessages.FeatureEditor_InstallSection_exclusive, 32);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fExclusiveButton.setLayoutData((Object)gd);
        this.fExclusiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!InstallSection.this.fBlockNotification) {
                        feature.setExclusive(InstallSection.this.fExclusiveButton.getSelection());
                    }
                }
                catch (CoreException ex) {
                    PDEPlugin.logException(ex);
                }
            }
        });
        Label colocationDescLabel = toolkit.createLabel(container, PDEUIMessages.FeatureEditor_InstallSection_colocation_desc, 64);
        gd = new GridData(4);
        gd.horizontalSpan = 2;
        gd.widthHint = 250;
        colocationDescLabel.setLayoutData((Object)gd);
        this.fColocationText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_InstallSection_colocation, null, false);
        this.fColocationText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                IFeatureModel model = (IFeatureModel)InstallSection.this.getPage().getModel();
                IFeature feature = model.getFeature();
                try {
                    feature.setColocationAffinity(InstallSection.this.fColocationText.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.fColocationText.getText().setEditable(false);
            this.fExclusiveButton.setEnabled(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    public void setFocus() {
        if (this.fExclusiveButton != null) {
            this.fExclusiveButton.setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.fColocationText.setValue(feature.getColocationAffinity() != null ? feature.getColocationAffinity() : "", true);
        this.fBlockNotification = true;
        this.fExclusiveButton.setSelection(feature.isExclusive());
        this.fBlockNotification = false;
        super.refresh();
    }

    public void cancelEdit() {
        this.fColocationText.cancelEdit();
        super.cancelEdit();
    }
}

