/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.MultiPartInitException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ActionSetManager;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.CompatibleWorkbenchPage;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PerspectiveExtensionReader;
import org.eclipse.ui.internal.PerspectiveTagger;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityView;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayout;
import org.eclipse.ui.internal.misc.ExternalEditor;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.IViewDescriptor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbenchPage
extends CompatibleWorkbenchPage
implements IWorkbenchPage {
    static final String SECONDARY_ID_HEADER = "3x-secondary:";
    ArrayList<MPart> activationList = new ArrayList();
    private List<ViewReference> viewReferences = new ArrayList<ViewReference>();
    private List<EditorReference> editorReferences = new ArrayList<EditorReference>();
    private List<IPerspectiveDescriptor> sortedPerspectives = new ArrayList<IPerspectiveDescriptor>();
    private ListenerList partListenerList = new ListenerList();
    private ListenerList partListener2List = new ListenerList();
    private IPerspectiveDescriptor perspective;
    private E4PartListener e4PartListener = new E4PartListener();
    protected WorkbenchWindow legacyWindow;
    private IAdaptable input;
    private IWorkingSet workingSet;
    private AggregateWorkingSet aggregateWorkingSet;
    private Composite composite;
    private ListenerList propertyChangeListeners = new ListenerList();
    private IActionBars actionBars;
    private ActionSetManager actionSets;
    private NavigationHistory navigationHistory = new NavigationHistory(this);
    private IWorkbenchPartReference partBeingActivated = null;
    private IPropertyChangeListener workingSetPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("workingSetRemove".equals(property)) {
                ArrayList<IWorkingSet> newList;
                if (event.getOldValue().equals(WorkbenchPage.this.workingSet)) {
                    WorkbenchPage.this.setWorkingSet(null);
                }
                if ((newList = new ArrayList<IWorkingSet>(Arrays.asList(WorkbenchPage.this.workingSets))).remove(event.getOldValue())) {
                    WorkbenchPage.this.setWorkingSets(newList.toArray(new IWorkingSet[newList.size()]));
                }
            }
        }
    };
    private IExtensionTracker tracker;
    private int deferCount = 0;
    private IWorkingSet[] workingSets = new IWorkingSet[0];
    private String aggregateWorkingSetId;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;
    @Inject
    private MWindow window;
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker broker;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MStackElement element;
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement != WorkbenchPage.this.getPerspectiveStack()) {
                return;
            }
            EContextService contextService = (EContextService)WorkbenchPage.this.window.getContext().get(EContextService.class);
            MPerspective oldPersp = (MPerspective)event.getProperty("OldValue");
            List<String> oldIds = ModeledPageLayout.getIds(oldPersp, "persp.actionSet:");
            MPerspective newPersp = (MPerspective)event.getProperty("NewValue");
            List<String> newIds = ModeledPageLayout.getIds(newPersp, "persp.actionSet:");
            oldIds.removeAll(newIds);
            for (String id : oldIds) {
                contextService.deactivateContext(id);
            }
            for (String id : newIds) {
                contextService.activateContext(id);
            }
            ArrayList<MPart> hiddenParts = new ArrayList<MPart>();
            ArrayList<MPart> visibleParts = new ArrayList<MPart>();
            List oldStacks = WorkbenchPage.this.modelService.findElements((MUIElement)oldPersp, null, MPartStack.class, null);
            List newStacks = WorkbenchPage.this.modelService.findElements((MUIElement)newPersp, null, MPartStack.class, null);
            for (MPartStack oldStack : oldStacks) {
                element = (MStackElement)oldStack.getSelectedElement();
                if (element instanceof MPlaceholder) {
                    hiddenParts.add((MPart)((MPlaceholder)element).getRef());
                    continue;
                }
                if (!(element instanceof MPart)) continue;
                hiddenParts.add((MPart)element);
            }
            for (MPartStack newStack : newStacks) {
                element = (MStackElement)newStack.getSelectedElement();
                if (element instanceof MPlaceholder) {
                    visibleParts.add((MPart)((MPlaceholder)element).getRef());
                    continue;
                }
                if (!(element instanceof MPart)) continue;
                visibleParts.add((MPart)element);
            }
            ArrayList<MPart> ignoredParts = new ArrayList<MPart>();
            for (MPart hiddenPart : hiddenParts) {
                if (!visibleParts.contains(hiddenPart)) continue;
                ignoredParts.add(hiddenPart);
            }
            hiddenParts.removeAll(ignoredParts);
            visibleParts.removeAll(ignoredParts);
            for (MPart hiddenPart : hiddenParts) {
                WorkbenchPage.this.firePartHidden(hiddenPart);
            }
            for (MPart visiblePart : visibleParts) {
                WorkbenchPage.this.firePartVisible(visiblePart);
            }
            WorkbenchPage.this.legacyWindow.firePerspectiveActivated(WorkbenchPage.this, WorkbenchPage.this.perspective);
        }
    };
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private void updateActivations(MPart part) {
        IWorkbenchPart workbenchPart;
        this.activationList.remove(part);
        this.activationList.add(0, part);
        this.updateActivePartSources(part);
        this.updateActiveEditorSources(part);
        this.updateShowInSources(part);
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            workbenchPart = ((CompatibilityPart)client).getPart();
            PartSite site = (PartSite)workbenchPart.getSite();
            site.activateActionBars(true);
            IActionBars actionBars = site.getActionBars();
            if (actionBars instanceof EditorActionBars) {
                ((EditorActionBars)actionBars).partChanged(workbenchPart);
            }
        }
        ((WorkbenchWindow)this.getWorkbenchWindow()).getStatusLineManager().update(false);
        workbenchPart = this.getWorkbenchPart(part);
        if (workbenchPart instanceof IEditorPart) {
            this.navigationHistory.markEditor((IEditorPart)workbenchPart);
        }
    }

    private void updateActivePartSources(MPart part) {
        IWorkbenchPart workbenchPart = this.getWorkbenchPart(part);
        if (workbenchPart == null) {
            this.window.getContext().set("activePart", null);
            this.window.getContext().set("activePartId", null);
            this.window.getContext().set("activeSite", null);
            if (this.application.getContext().get("activeChildContext") == this.window.getContext()) {
                this.application.getContext().set("activePart", null);
                this.application.getContext().set("activePartId", null);
                this.application.getContext().set("activeSite", null);
            }
        } else {
            this.window.getContext().set("activePart", (Object)workbenchPart);
            this.window.getContext().set("activePartId", (Object)workbenchPart.getSite().getId());
            this.window.getContext().set("activeSite", (Object)workbenchPart.getSite());
            if (this.application.getContext().get("activeChildContext") == this.window.getContext()) {
                this.application.getContext().set("activePart", (Object)workbenchPart);
                this.application.getContext().set("activePartId", (Object)workbenchPart.getSite().getId());
                this.application.getContext().set("activeSite", (Object)workbenchPart.getSite());
            }
        }
    }

    private IWorkbenchPart getWorkbenchPart(MPart part) {
        Object clientObject;
        if (part != null && (clientObject = part.getObject()) instanceof CompatibilityPart) {
            return ((CompatibilityPart)clientObject).getPart();
        }
        return null;
    }

    private void updateActiveEditorSources(MPart part) {
        IEditorPart editor = this.getEditor(part);
        this.window.getContext().set("activeEditorId", editor == null ? null : editor.getSite().getId());
        this.window.getContext().set("activeEditor", (Object)editor);
        this.window.getContext().set("activeEditorInput", (Object)(editor == null ? null : editor.getEditorInput()));
        if (this.application.getContext().get("activeChildContext") == this.window.getContext()) {
            this.application.getContext().set("activeEditorId", editor == null ? null : editor.getSite().getId());
            this.application.getContext().set("activeEditor", (Object)editor);
            this.application.getContext().set("activeEditorInput", (Object)(editor == null ? null : editor.getEditorInput()));
        }
    }

    private void updateShowInSources(MPart part) {
        IWorkbenchPart workbenchPart = this.getWorkbenchPart(part);
        ShowInContext context = this.getContext(workbenchPart);
        if (context != null) {
            this.window.getContext().set("showInInput", context.getInput());
            this.window.getContext().set("showInSelection", (Object)context.getSelection());
            if (this.application.getContext().get("activeChildContext") == this.window.getContext()) {
                this.application.getContext().set("showInInput", context.getInput());
                this.application.getContext().set("showInSelection", (Object)context.getSelection());
            }
        }
    }

    private IShowInSource getShowInSource(IWorkbenchPart sourcePart) {
        return (IShowInSource)Util.getAdapter(sourcePart, IShowInSource.class);
    }

    private ShowInContext getContext(IWorkbenchPart sourcePart) {
        IShowInSource source = this.getShowInSource(sourcePart);
        if (source != null) {
            ShowInContext context = source.getShowInContext();
            if (context != null) {
                return context;
            }
        } else if (sourcePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
            ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
            ISelection sel = sp == null ? null : sp.getSelection();
            return new ShowInContext(input, sel);
        }
        return null;
    }

    private IEditorPart getEditor(MPart part) {
        Object clientObject;
        if (part != null && (clientObject = part.getObject()) instanceof CompatibilityEditor) {
            return ((CompatibilityEditor)clientObject).getEditor();
        }
        return this.getActiveEditor();
    }

    private void updateBroughtToTop(MPart part) {
        MElementContainer parent = part.getParent();
        if (parent instanceof MPartStack) {
            int newIndex = this.lastIndexOfContainer(parent);
            if (newIndex >= 0 && part == this.activationList.get(newIndex)) {
                return;
            }
            this.activationList.remove(part);
            if (newIndex >= 0 && newIndex < this.activationList.size() - 1) {
                this.activationList.add(newIndex, part);
            } else {
                this.activationList.add(part);
            }
        }
    }

    private int lastIndexOfContainer(MElementContainer<?> parent) {
        int i = 0;
        while (i < this.activationList.size()) {
            MPart mPart = this.activationList.get(i);
            if (mPart.getParent() == parent) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public WorkbenchPage(WorkbenchWindow w, String layoutID, IAdaptable input) throws WorkbenchException {
        if (layoutID == null) {
            throw new WorkbenchException(WorkbenchMessages.WorkbenchPage_UndefinedPerspective);
        }
        this.init(w, layoutID, input, true);
    }

    public WorkbenchPage(WorkbenchWindow w, IAdaptable input) throws WorkbenchException {
        this.init(w, null, input, false);
    }

    public MWindow getWindowModel() {
        return this.window;
    }

    @Override
    public void activate(IWorkbenchPart part) {
        if (part == null || !this.certifyPart(part) || this.legacyWindow.isClosing()) {
            return;
        }
        MPart mpart = this.findPart(part);
        if (mpart != null) {
            if ("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor".equals(mpart.getContributionURI())) {
                for (MPart localPart : this.partService.getParts()) {
                    if (localPart != mpart) continue;
                    this.partService.activate(mpart);
                    return;
                }
                try {
                    IEditorPart editor = (IEditorPart)part;
                    this.openEditor(editor.getEditorInput(), editor.getSite().getId(), true, 0);
                }
                catch (PartInitException e) {
                    WorkbenchPlugin.log((Throwable)((Object)e));
                }
            } else {
                String secondaryId = null;
                for (String tag : mpart.getTags()) {
                    if (tag == null || !tag.startsWith(SECONDARY_ID_HEADER)) continue;
                    secondaryId = tag.substring(SECONDARY_ID_HEADER.length());
                }
                try {
                    this.showView(mpart.getElementId(), secondaryId, 1);
                }
                catch (PartInitException e) {
                    WorkbenchPlugin.log((Throwable)((Object)e));
                }
            }
        }
    }

    @Override
    public void addPartListener(IPartListener l) {
        this.partListenerList.add((Object)l);
    }

    @Override
    public void addPartListener(IPartListener2 l) {
        this.partListener2List.add((Object)l);
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        this.getWorkbenchWindow().getSelectionService().addSelectionListener(listener);
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        this.getWorkbenchWindow().getSelectionService().addSelectionListener(partId, listener);
    }

    @Override
    public void addPostSelectionListener(ISelectionListener listener) {
        this.getWorkbenchWindow().getSelectionService().addPostSelectionListener(listener);
    }

    @Override
    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        this.getWorkbenchWindow().getSelectionService().addPostSelectionListener(partId, listener);
    }

    @Override
    public void bringToTop(IWorkbenchPart part) {
        MPart mpart = this.findPart(part);
        if (mpart != null) {
            this.partService.bringToTop(mpart);
        }
    }

    public MPart findPart(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        for (IViewReference iViewReference : this.viewReferences) {
            if (part != iViewReference.getPart(false)) continue;
            return ((WorkbenchPartReference)((Object)iViewReference)).getModel();
        }
        for (IEditorReference iEditorReference : this.editorReferences) {
            if (part != iEditorReference.getPart(false)) continue;
            return ((WorkbenchPartReference)((Object)iEditorReference)).getModel();
        }
        return null;
    }

    public void createEditorReferenceForPart(final MPart part, IEditorInput input, String editorId) {
        IEditorRegistry registry = this.legacyWindow.getWorkbench().getEditorRegistry();
        EditorDescriptor descriptor = (EditorDescriptor)registry.findEditor(editorId);
        final EditorReference ref = new EditorReference(this.window.getContext(), this, part, input, descriptor);
        this.editorReferences.add(ref);
        final IEventBroker broker = (IEventBroker)this.application.getContext().get(IEventBroker.class.getName());
        broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/Context", (String)"context"), new EventHandler(){

            public void handleEvent(Event event) {
                Object element = event.getProperty("ChangedElement");
                if (element == part && part.getContext() != null) {
                    broker.unsubscribe((EventHandler)this);
                    part.getContext().set(EditorReference.class.getName(), (Object)ref);
                }
            }
        });
    }

    public List<EditorReference> getInternalEditorReferences() {
        return this.editorReferences;
    }

    public EditorReference getEditorReference(MPart part) {
        for (EditorReference ref : this.editorReferences) {
            if (ref.getModel() != part) continue;
            return ref;
        }
        return null;
    }

    public ViewReference getViewReference(MPart part) {
        for (IViewReference iViewReference : this.viewReferences) {
            if (((ViewReference)iViewReference).getModel() != part) continue;
            return (ViewReference)iViewReference;
        }
        return null;
    }

    public void addViewReference(ViewReference viewReference) {
        this.viewReferences.add(viewReference);
    }

    public void addEditorReference(EditorReference editorReference) {
        this.editorReferences.add(editorReference);
    }

    MPartDescriptor findDescriptor(String id) {
        for (MPartDescriptor descriptor : this.application.getDescriptors()) {
            if (!descriptor.getElementId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    MPart findPart(String viewId, String secondaryId) {
        Collection parts;
        if (secondaryId == null) {
            parts = this.partService.getParts();
            block0: for (MPart part : parts) {
                if (!part.getElementId().equals(viewId)) continue;
                for (String tag : part.getTags()) {
                    if (tag.startsWith(SECONDARY_ID_HEADER)) continue block0;
                }
                return part;
            }
        }
        parts = this.partService.getParts();
        for (MPart part : parts) {
            if (!part.getElementId().equals(viewId) || !part.getTags().contains(secondaryId)) continue;
            return part;
        }
        return null;
    }

    EPartService.PartState convert(int mode) {
        switch (mode) {
            case 1: {
                return EPartService.PartState.ACTIVATE;
            }
            case 2: {
                return EPartService.PartState.VISIBLE;
            }
            case 3: {
                return EPartService.PartState.CREATE;
            }
        }
        throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
    }

    protected IViewPart busyShowView(String viewId, String secondaryId, int mode) throws PartInitException {
        MPart part;
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
            }
        }
        if (secondaryId != null) {
            if (secondaryId.length() == 0 || secondaryId.indexOf(58) != -1) {
                throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalSecondaryId);
            }
            secondaryId = SECONDARY_ID_HEADER + secondaryId;
            MPartDescriptor descriptor = this.findDescriptor(viewId);
            if (!descriptor.isAllowMultiple()) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.ViewFactory_noMultiple, (Object)viewId));
            }
        }
        if ((part = this.findPart(viewId, secondaryId)) == null) {
            MPlaceholder ph = this.partService.createSharedPart(viewId, this.window, secondaryId != null);
            part = (MPart)ph.getRef();
            part.setCurSharedRef(ph);
            if (ph == null) {
                // empty if block
            }
            if (secondaryId != null) {
                part.getTags().add(secondaryId);
            }
            this.partService.showPart(part, this.convert(mode));
            CompatibilityView compatibilityView = (CompatibilityView)part.getObject();
            if (compatibilityView != null) {
                WorkbenchPartReference ref = compatibilityView.getReference();
                this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), ref, "viewShow");
                this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "viewShow");
            }
            return compatibilityView.getView();
        }
        part = this.partService.showPart(part, this.convert(mode));
        if (secondaryId != null) {
            part.getTags().add(secondaryId);
        }
        CompatibilityView compatibilityView = (CompatibilityView)part.getObject();
        if (mode == 1) {
            compatibilityView.delegateSetFocus();
        }
        if (compatibilityView != null) {
            WorkbenchPartReference ref = compatibilityView.getReference();
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), ref, "viewShow");
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "viewShow");
        }
        return compatibilityView.getView();
    }

    private boolean certifyPart(IWorkbenchPart part) {
        return part == null || part.getSite() instanceof PartSite;
    }

    @Override
    public boolean close() {
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = true;
            }
        });
        return ret[0];
    }

    public boolean closeAllSavedEditors() {
        IEditorReference[] editors = this.getEditorReferences();
        IEditorReference[] savedEditors = new IEditorReference[editors.length];
        int j = 0;
        int i = 0;
        while (i < editors.length) {
            IEditorReference editor = editors[i];
            if (!editor.isDirty()) {
                savedEditors[j++] = editor;
            }
            ++i;
        }
        if (j == 0) {
            return true;
        }
        IEditorReference[] newSaved = new IEditorReference[j];
        System.arraycopy(savedEditors, 0, newSaved, 0, j);
        return this.closeEditors(newSaved, false);
    }

    @Override
    public boolean closeAllEditors(boolean save) {
        return this.closeEditors(this.getEditorReferences(), save);
    }

    @Override
    public boolean closeEditors(IEditorReference[] refArray, boolean save) {
        IWorkbenchPartReference ref;
        if (refArray.length == 0) {
            return true;
        }
        ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
        int i = 0;
        while (i < refArray.length) {
            IEditorReference reference = refArray[i];
            if (reference == this.partBeingActivated) {
                WorkbenchPlugin.log(new RuntimeException("WARNING: Blocked recursive attempt to close part " + this.partBeingActivated.getId() + " while still in the middle of activating it"));
                return false;
            }
            if (!(reference instanceof WorkbenchPartReference) || !((WorkbenchPartReference)(ref = (WorkbenchPartReference)((Object)reference))).isDisposed()) {
                toClose.add(reference);
            }
            ++i;
        }
        IEditorReference[] editorRefs = toClose.toArray(new IEditorReference[toClose.size()]);
        int i2 = 0;
        while (i2 < editorRefs.length) {
            IEditorPart oldPart;
            ref = editorRefs[i2];
            if (ref != null && (oldPart = ref.getEditor(false)) != null && this.navigationHistory.updateActive(oldPart)) break;
            ++i2;
        }
        ArrayList<IEditorPart> partsToClose = new ArrayList<IEditorPart>();
        int i3 = 0;
        while (i3 < editorRefs.length) {
            IEditorPart refPart = editorRefs[i3].getEditor(false);
            if (refPart != null) {
                partsToClose.add(refPart);
            }
            ++i3;
        }
        boolean confirm = true;
        SaveablesList modelManager = null;
        Object postCloseInfo = null;
        if (partsToClose.size() > 0) {
            modelManager = (SaveablesList)this.getWorkbenchWindow().getService(ISaveablesLifecycleListener.class);
            postCloseInfo = modelManager.preCloseParts(partsToClose, save, this.getWorkbenchWindow());
            if (postCloseInfo == null) {
                return false;
            }
            confirm = false;
        }
        int i4 = 0;
        while (i4 < editorRefs.length) {
            IEditorReference ref2 = editorRefs[i4];
            this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), ref2, "editorClose");
            ++i4;
        }
        this.deferUpdates(true);
        try {
            if (modelManager != null) {
                modelManager.postClose(postCloseInfo);
            }
            IEditorReference[] iEditorReferenceArray = editorRefs;
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                MPart model = ((EditorReference)editorRef).getModel();
                if (!this.hidePart(model, false, confirm, false)) {
                    return false;
                }
                ++n2;
            }
        }
        finally {
            this.deferUpdates(false);
        }
        this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "editorClose");
        return true;
    }

    private void hidePart(MPart part, boolean force) {
        WorkbenchPartReference reference;
        this.partService.hidePart(part, force);
        Iterator<WorkbenchPartReference> it = this.viewReferences.iterator();
        while (it.hasNext()) {
            reference = it.next();
            if (reference.getModel() != part) continue;
            it.remove();
            return;
        }
        it = this.editorReferences.iterator();
        while (it.hasNext()) {
            reference = (EditorReference)it.next();
            if (reference.getModel() != part) continue;
            it.remove();
            return;
        }
    }

    private boolean hidePart(MPart part, boolean save, boolean confirm, boolean force) {
        ISaveablePart saveablePart;
        if (!this.partService.getParts().contains(part)) {
            return false;
        }
        Object clientObject = part.getObject();
        if (!(clientObject instanceof CompatibilityPart)) {
            if (save) {
                if (this.partService.savePart(part, confirm)) {
                    this.hidePart(part, force);
                    return true;
                }
                return false;
            }
            this.hidePart(part, force);
            return true;
        }
        CompatibilityPart compatibilityPart = (CompatibilityPart)clientObject;
        IWorkbenchPart workbenchPart = compatibilityPart.getPart();
        if (save && workbenchPart instanceof ISaveablePart && !this.saveSaveable(saveablePart = (ISaveablePart)((Object)workbenchPart), confirm, true)) {
            return false;
        }
        IWorkbenchPartReference reference = null;
        for (IViewReference iViewReference : this.viewReferences) {
            if (workbenchPart != iViewReference.getPart(false)) continue;
            reference = iViewReference;
            break;
        }
        if (reference != null) {
            this.partService.hidePart(part, force);
            return true;
        }
        for (IEditorReference iEditorReference : this.editorReferences) {
            if (workbenchPart != iEditorReference.getPart(false)) continue;
            reference = iEditorReference;
            break;
        }
        if (reference != null) {
            this.partService.hidePart(part, force);
            this.editorReferences.remove(reference);
            return true;
        }
        return false;
    }

    private void hidePart(String id) {
        MPart part = this.partService.findPart(id);
        if (part != null) {
            this.hidePart(part, true, true, false);
        }
    }

    private void deferUpdates(boolean shouldDefer) {
        if (shouldDefer) {
            if (this.deferCount == 0) {
                this.startDeferring();
            }
            ++this.deferCount;
        } else {
            --this.deferCount;
            if (this.deferCount == 0) {
                this.handleDeferredEvents();
            }
        }
    }

    private void startDeferring() {
    }

    private void handleDeferredEvents() {
    }

    public boolean closeEditor(IEditorReference editorRef, boolean save) {
        return this.closeEditors(new IEditorReference[]{editorRef}, save);
    }

    @Override
    public boolean closeEditor(IEditorPart editor, boolean save) {
        IWorkbenchPartReference ref = this.getReference(editor);
        if (ref instanceof IEditorReference) {
            return this.closeEditors(new IEditorReference[]{(IEditorReference)ref}, save);
        }
        return false;
    }

    @Override
    public void closePerspective(IPerspectiveDescriptor desc, boolean saveParts, boolean closePage) {
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null).get(0);
        if (perspectiveStack.getChildren().size() == 1) {
            this.closeAllPerspectives(saveParts, closePage);
        } else {
            this.sortedPerspectives.remove(desc);
            MPerspective persp = (MPerspective)this.modelService.find(desc.getId(), (MUIElement)this.window);
            this.modelService.removePerspectiveModel(persp, this.window);
        }
    }

    @Override
    public void closeAllPerspectives(boolean saveEditors, boolean closePage) {
        if (saveEditors && !this.saveAllEditors(true, true)) {
            return;
        }
        this.sortedPerspectives.clear();
        for (MPart part : this.partService.getParts()) {
            this.hidePart(part, false, true, true);
        }
        if (closePage) {
            this.legacyWindow.setActivePage(null);
            this.partService.removePartListener((org.eclipse.e4.ui.workbench.modeling.IPartListener)this.e4PartListener);
            this.broker.unsubscribe(this.selectionHandler);
        }
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null).get(0);
        MPerspective perspective = (MPerspective)perspectiveStack.getSelectedElement();
        while (perspective != null && !perspectiveStack.getChildren().isEmpty()) {
            this.modelService.removePerspectiveModel(perspective, this.window);
            perspective = (MPerspective)perspectiveStack.getSelectedElement();
        }
        this.viewReferences.clear();
        this.editorReferences.clear();
    }

    public void unzoomAllPerspectives() {
    }

    public void dispose() {
    }

    @Override
    public INavigationHistory getNavigationHistory() {
        return this.navigationHistory;
    }

    public boolean editActionSets() {
        return false;
    }

    @Override
    public IViewPart findView(String id) {
        IViewReference ref = this.findViewReference(id);
        if (ref == null) {
            return null;
        }
        return ref.getView(true);
    }

    @Override
    public IViewReference findViewReference(String viewId) {
        return this.findViewReference(viewId, null);
    }

    @Override
    public IViewReference findViewReference(String viewId, String secondaryId) {
        for (IViewReference iViewReference : this.viewReferences) {
            String refSecondaryId;
            if (!viewId.equals(iViewReference.getId()) || !((refSecondaryId = iViewReference.getSecondaryId()) == null ? secondaryId == null : refSecondaryId.equals(secondaryId))) continue;
            return iViewReference;
        }
        return null;
    }

    public void createViewReferenceForPart(final MPart part, String viewId) {
        IViewDescriptor desc = this.getWorkbenchWindow().getWorkbench().getViewRegistry().find(viewId);
        final ViewReference ref = new ViewReference(this.window.getContext(), this, part, (ViewDescriptor)desc);
        IEclipseContext partContext = part.getContext();
        if (partContext == null) {
            final IEventBroker broker = (IEventBroker)this.application.getContext().get(IEventBroker.class.getName());
            broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/Context", (String)"context"), new EventHandler(){

                public void handleEvent(Event event) {
                    Object element = event.getProperty("ChangedElement");
                    if (element == part && part.getContext() != null) {
                        broker.unsubscribe((EventHandler)this);
                        part.getContext().set(ViewReference.class.getName(), (Object)ref);
                    }
                }
            });
        } else {
            partContext.set(ViewReference.class.getName(), (Object)ref);
        }
        this.viewReferences.add(ref);
    }

    private void firePropertyChange(String changeId, Object oldValue, Object newValue) {
        UIListenerLogging.logPagePropertyChanged(this, changeId, oldValue, newValue);
        Object[] listeners = this.propertyChangeListeners.getListeners();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public IActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this.legacyWindow);
        }
        return this.actionBars;
    }

    public IActionSetDescriptor[] getActionSets() {
        Collection collection = this.actionSets.getVisibleItems();
        return collection.toArray(new IActionSetDescriptor[collection.size()]);
    }

    @Override
    public IEditorPart getActiveEditor() {
        for (MPart model : this.activationList) {
            CompatibilityEditor editor;
            Object object = model.getObject();
            if (!(object instanceof CompatibilityEditor) || (editor = (CompatibilityEditor)object).isBeingDisposed()) continue;
            return ((CompatibilityEditor)object).getEditor();
        }
        return null;
    }

    @Override
    public IWorkbenchPart getActivePart() {
        Object object;
        MPart part = this.partService.getActivePart();
        if (part != null && (object = part.getObject()) instanceof CompatibilityPart) {
            return ((CompatibilityPart)object).getPart();
        }
        return null;
    }

    @Override
    public IWorkbenchPartReference getActivePartReference() {
        IWorkbenchPart part = this.getActivePart();
        if (part != null) {
            for (IWorkbenchPartReference iWorkbenchPartReference : this.viewReferences) {
                if (iWorkbenchPartReference.getPart(false) != part) continue;
                return iWorkbenchPartReference;
            }
            for (IWorkbenchPartReference iWorkbenchPartReference : this.editorReferences) {
                if (iWorkbenchPartReference.getPart(false) != part) continue;
                return iWorkbenchPartReference;
            }
        }
        return null;
    }

    public Composite getClientComposite() {
        return this.composite;
    }

    @Override
    public IEditorPart[] getDirtyEditors() {
        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
        for (IEditorReference iEditorReference : this.editorReferences) {
            IEditorPart editor = iEditorReference.getEditor(false);
            if (editor == null || !editor.isDirty()) continue;
            dirtyEditors.add(editor);
        }
        return dirtyEditors.toArray(new IEditorPart[dirtyEditors.size()]);
    }

    @Override
    public IEditorPart findEditor(IEditorInput input) {
        IEditorReference[] references = this.findEditors(input, null, 1);
        return references.length == 0 ? null : references[0].getEditor(true);
    }

    @Override
    public IEditorReference[] findEditors(IEditorInput input, String editorId, int matchFlags) {
        switch (matchFlags) {
            case 1: {
                ArrayList<IEditorReference> editorRefs = new ArrayList<IEditorReference>();
                for (EditorReference editorReference : this.editorReferences) {
                    this.checkEditor(input, editorRefs, editorReference);
                }
                return editorRefs.toArray(new IEditorReference[editorRefs.size()]);
            }
            case 2: {
                ArrayList<IEditorReference> editorRefs = new ArrayList<IEditorReference>();
                for (IEditorReference iEditorReference : this.editorReferences) {
                    if (!editorId.equals(iEditorReference.getId())) continue;
                    editorRefs.add(iEditorReference);
                }
                return editorRefs.toArray(new IEditorReference[editorRefs.size()]);
            }
        }
        if ((matchFlags & 2) != 0 && (matchFlags & 1) != 0) {
            ArrayList<IEditorReference> editorRefs = new ArrayList<IEditorReference>();
            for (EditorReference editorReference : this.editorReferences) {
                if (!editorReference.getId().equals(editorId)) continue;
                this.checkEditor(input, editorRefs, editorReference);
            }
            return editorRefs.toArray(new IEditorReference[editorRefs.size()]);
        }
        return new IEditorReference[0];
    }

    private void checkEditor(IEditorInput input, List<IEditorReference> editorRefs, EditorReference editorRef) {
        IEditorMatchingStrategy strategy = editorRef.getDescriptor().getEditorMatchingStrategy();
        if (strategy != null && strategy.matches(editorRef, input)) {
            editorRefs.add(editorRef);
            return;
        }
        IEditorPart editor = editorRef.getEditor(false);
        if (editor == null) {
            try {
                if (input.equals(editorRef.getEditorInput())) {
                    editorRefs.add(editorRef);
                }
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log((Throwable)((Object)e));
            }
        } else if (editor.getEditorInput().equals(input)) {
            editorRefs.add(editorRef);
        }
    }

    @Override
    public IEditorPart[] getEditors() {
        int length = this.editorReferences.size();
        IEditorPart[] editors = new IEditorPart[length];
        int i = 0;
        while (i < length) {
            editors[i] = this.editorReferences.get(i).getEditor(true);
            ++i;
        }
        return editors;
    }

    @Override
    public IEditorReference[] getEditorReferences() {
        ArrayList<EditorReference> sortedReferences = new ArrayList<EditorReference>();
        block0: for (MPart part : this.activationList) {
            for (EditorReference ref : this.editorReferences) {
                if (ref.getModel() != part) continue;
                sortedReferences.add(ref);
                continue block0;
            }
        }
        for (EditorReference ref : this.editorReferences) {
            if (sortedReferences.contains(ref)) continue;
            sortedReferences.add(ref);
        }
        return sortedReferences.toArray(new IEditorReference[sortedReferences.size()]);
    }

    public IWorkbenchPartReference[] getSortedParts() {
        ArrayList<WorkbenchPartReference> sortedReferences = new ArrayList<WorkbenchPartReference>();
        block0: for (MPart mPart : this.activationList) {
            for (ViewReference viewReference : this.viewReferences) {
                if (viewReference.getModel() != mPart) continue;
                sortedReferences.add(viewReference);
                continue block0;
            }
            for (EditorReference editorReference : this.editorReferences) {
                if (editorReference.getModel() != mPart) continue;
                sortedReferences.add(editorReference);
                continue block0;
            }
        }
        for (ViewReference viewReference : this.viewReferences) {
            if (sortedReferences.contains(viewReference)) continue;
            sortedReferences.add(viewReference);
        }
        for (EditorReference editorReference : this.editorReferences) {
            if (sortedReferences.contains(editorReference)) continue;
            sortedReferences.add(editorReference);
        }
        return sortedReferences.toArray(new IWorkbenchPartReference[sortedReferences.size()]);
    }

    @Override
    public IAdaptable getInput() {
        return this.input;
    }

    @Override
    public String getLabel() {
        String label = WorkbenchMessages.WorkbenchPage_UnknownLabel;
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Util.getAdapter(this.input, IWorkbenchAdapter.class);
        if (adapter != null) {
            label = adapter.getLabel(this.input);
        }
        return label;
    }

    @Override
    public IPerspectiveDescriptor getPerspective() {
        MPerspectiveStack ps = this.getPerspectiveStack();
        MPerspective curPersp = (MPerspective)ps.getSelectedElement();
        if (curPersp == null) {
            return null;
        }
        IPerspectiveDescriptor desc = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(curPersp.getElementId());
        return desc;
    }

    @Override
    public ISelection getSelection() {
        return this.getWorkbenchWindow().getSelectionService().getSelection();
    }

    @Override
    public ISelection getSelection(String partId) {
        return this.getWorkbenchWindow().getSelectionService().getSelection(partId);
    }

    public ArrayList getShowInPartIds() {
        MPerspective perspective = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        return new ArrayList<String>(ModeledPageLayout.getIds(perspective, "persp.showIn:"));
    }

    public void performedShowIn(String partId) {
    }

    public void sortShowInPartIds(ArrayList partIds) {
    }

    @Override
    public IViewReference[] getViewReferences() {
        return this.viewReferences.toArray(new IViewReference[this.viewReferences.size()]);
    }

    @Override
    public IViewPart[] getViews() {
        int length = this.viewReferences.size();
        IViewPart[] views = new IViewPart[length];
        int i = 0;
        while (i < length) {
            views[i] = this.viewReferences.get(i).getView(true);
            ++i;
        }
        return views;
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        return this.legacyWindow;
    }

    @Override
    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    @Override
    public void hideActionSet(String actionSetID) {
        MPerspective persp = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        if (persp == null) {
            return;
        }
        EContextService contextService = (EContextService)this.window.getContext().get(EContextService.class);
        String tag = "persp.actionSet:" + actionSetID;
        if (persp.getTags().contains(tag)) {
            persp.getTags().remove(tag);
            contextService.deactivateContext(actionSetID);
        }
    }

    @Override
    public void hideView(IViewReference view) {
        if (view != null) {
            this.hidePart(view.getId());
        }
        this.legacyWindow.firePerspectiveChanged(this, this.getPerspective(), "viewHide");
    }

    @Override
    public void hideView(IViewPart view) {
        if (view != null) {
            this.hidePart(view.getSite().getId());
        }
    }

    private void init(WorkbenchWindow w, String layoutID, IAdaptable input, boolean openExtras) throws WorkbenchException {
        this.legacyWindow = w;
        this.input = input;
        this.actionSets = new ActionSetManager(w);
    }

    @PostConstruct
    public void setup() {
        this.partService.addPartListener((org.eclipse.e4.ui.workbench.modeling.IPartListener)this.e4PartListener);
        Collection parts = this.partService.getParts();
        for (MPart part : parts) {
            if (!part.isToBeRendered()) continue;
            String uri = part.getContributionURI();
            if (uri.equals("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView")) {
                this.createViewReferenceForPart(part, part.getElementId());
                continue;
            }
            if (!uri.equals("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor")) continue;
            this.createEditorReferenceForPart(part, null, part.getElementId());
        }
        this.broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.selectionHandler);
        if (this.getPerspectiveStack() != null) {
            MPerspective persp = (MPerspective)this.getPerspectiveStack().getSelectedElement();
            List<String> newIds = ModeledPageLayout.getIds(persp, "persp.actionSet:");
            EContextService contextService = (EContextService)this.window.getContext().get(EContextService.class);
            for (String id : newIds) {
                contextService.activateContext(id);
            }
        }
    }

    @Override
    public boolean isPartVisible(IWorkbenchPart part) {
        MPart mpart = this.findPart(part);
        return mpart == null ? false : this.partService.isPartVisible(mpart);
    }

    @Override
    public boolean isEditorAreaVisible() {
        E4Util.unsupported("isEditorAreaVisible");
        return true;
    }

    @Override
    public boolean isPageZoomed() {
        return false;
    }

    @Override
    public void reuseEditor(IReusableEditor editor, IEditorInput input) {
        editor.setInput(input);
        this.navigationHistory.markEditor(editor);
    }

    @Override
    public IEditorPart openEditor(IEditorInput input, String editorID) throws PartInitException {
        return this.openEditor(input, editorID, true, 1);
    }

    @Override
    public IEditorPart openEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        return this.openEditor(input, editorID, activate, 1);
    }

    @Override
    public IEditorPart openEditor(IEditorInput input, String editorID, boolean activate, int matchFlags) throws PartInitException {
        return this.openEditor(input, editorID, activate, matchFlags, null);
    }

    public IEditorPart openEditor(final IEditorInput input, final String editorID, final boolean activate, final int matchFlags, final IMemento editorState) throws PartInitException {
        if (input == null || editorID == null) {
            throw new IllegalArgumentException();
        }
        final IEditorPart[] result = new IEditorPart[1];
        final PartInitException[] ex = new PartInitException[1];
        BusyIndicator.showWhile((Display)this.legacyWindow.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    result[0] = WorkbenchPage.this.busyOpenEditor(input, editorID, activate, matchFlags, editorState);
                }
                catch (PartInitException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return result[0];
    }

    private IEditorPart busyOpenEditor(IEditorInput input, String editorId, boolean activate, int matchFlags, IMemento editorState) throws PartInitException {
        if (input == null || editorId == null) {
            throw new IllegalArgumentException();
        }
        if (("org.eclipse.ui.systemExternalEditor".equals(editorId) || "org.eclipse.ui.browser.editorSupport".equals(editorId)) && input instanceof IPathEditorInput) {
            IPathEditorInput fileInput = (IPathEditorInput)input;
            String fullPath = fileInput.getPath().toOSString();
            Program.launch((String)fullPath);
            return null;
        }
        IEditorReference[] editorReferences = this.findEditors(input, editorId, matchFlags);
        if (editorReferences.length != 0) {
            IEditorPart editor = editorReferences[0].getEditor(true);
            if (editor instanceof IShowEditorInput) {
                ((IShowEditorInput)((Object)editor)).showEditorInput(input);
            }
            if (activate) {
                this.activate(editor);
            }
            return editor;
        }
        MPart editor = this.partService.createPart("org.eclipse.e4.ui.compatibility.editor");
        this.createEditorReferenceForPart(editor, input, editorId);
        this.partService.showPart(editor, EPartService.PartState.VISIBLE);
        CompatibilityEditor compatibilityEditor = (CompatibilityEditor)editor.getObject();
        if (activate) {
            this.partService.activate(editor);
            compatibilityEditor.delegateSetFocus();
        }
        return compatibilityEditor.getEditor();
    }

    @Override
    public boolean isEditorPinned(IEditorPart editor) {
        WorkbenchPartReference ref = (WorkbenchPartReference)this.getReference(editor);
        return ref != null && ref.isPinned();
    }

    @Override
    public void removePartListener(IPartListener l) {
        this.partListenerList.remove((Object)l);
    }

    @Override
    public void removePartListener(IPartListener2 l) {
        this.partListener2List.remove((Object)l);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        this.getWorkbenchWindow().getSelectionService().removeSelectionListener(listener);
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        this.getWorkbenchWindow().getSelectionService().removeSelectionListener(partId, listener);
    }

    @Override
    public void removePostSelectionListener(ISelectionListener listener) {
        this.getWorkbenchWindow().getSelectionService().removePostSelectionListener(listener);
    }

    @Override
    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        this.getWorkbenchWindow().getSelectionService().removePostSelectionListener(partId, listener);
    }

    @Override
    public void resetPerspective() {
        MPerspectiveStack perspStack = this.getPerspectiveStack();
        MPerspective persp = (MPerspective)perspStack.getSelectedElement();
        if (persp == null) {
            return;
        }
        IPerspectiveDescriptor desc = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(persp.getElementId());
        if (desc == null) {
            return;
        }
        this.closePerspective(desc, true, false);
        if (persp.getParent() == null) {
            this.setPerspective(desc);
        }
    }

    @Override
    public boolean saveAllEditors(boolean confirm) {
        return this.saveAllEditors(confirm, false);
    }

    private boolean saveAllEditors(boolean confirm, boolean closing) {
        if (closing) {
            IEditorReference[] iEditorReferenceArray = this.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference iEditorReference = iEditorReferenceArray[n2];
                IEditorPart editor = iEditorReference.getEditor(false);
                if (editor != null && !this.saveSaveable(editor, confirm, closing)) {
                    return false;
                }
                ++n2;
            }
            for (IViewReference iViewReference : this.viewReferences) {
                IWorkbenchPart part = iViewReference.getPart(false);
                if (!(part instanceof ISaveablePart) || this.saveSaveable((ISaveablePart)((Object)part), confirm, closing)) continue;
                return false;
            }
        }
        return this.partService.saveAll(confirm);
    }

    public boolean saveSaveable(ISaveablePart saveable, boolean confirm, boolean closing) {
        MPart part = this.findPart((IWorkbenchPart)((Object)saveable));
        if (part != null) {
            if (saveable.isDirty()) {
                if (closing) {
                    if (saveable.isSaveOnCloseNeeded()) {
                        return this.partService.savePart(part, confirm);
                    }
                } else {
                    return this.partService.savePart(part, confirm);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean saveEditor(IEditorPart editor, boolean confirm) {
        return this.saveSaveable(editor, confirm, false);
    }

    @Override
    public void savePerspective() {
        E4Util.unsupported("savePerspective");
    }

    @Override
    public void savePerspectiveAs(IPerspectiveDescriptor perspective) {
        E4Util.unsupported("savePerspectiveAs");
    }

    @Override
    public void setEditorAreaVisible(boolean showEditorArea) {
        E4Util.unsupported("setEditorAreaVisible");
    }

    @Override
    public void setPerspective(IPerspectiveDescriptor perspective) {
        if (perspective == null) {
            return;
        }
        IPerspectiveDescriptor lastPerspective = this.perspective;
        this.perspective = perspective;
        if (this.sortedPerspectives.contains(perspective)) {
            this.sortedPerspectives.remove(perspective);
        }
        this.sortedPerspectives.add(perspective);
        MPerspectiveStack perspectives = this.getPerspectiveStack();
        for (MPerspective mperspective : perspectives.getChildren()) {
            if (!mperspective.getElementId().equals(perspective.getId())) continue;
            if (lastPerspective != null) {
                this.legacyWindow.firePerspectiveDeactivated(this, lastPerspective);
            }
            perspectives.setSelectedElement((MUIElement)mperspective);
            this.window.getContext().set("activeChildContext", (Object)mperspective.getContext());
            this.legacyWindow.firePerspectiveDeactivated(this, perspective);
            return;
        }
        MPerspective modelPerspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        modelPerspective.setElementId(perspective.getId());
        modelPerspective.setLabel(perspective.getLabel());
        IPerspectiveFactory factory = ((PerspectiveDescriptor)perspective).createFactory();
        ModeledPageLayout modelLayout = new ModeledPageLayout(this.window, this.modelService, this.partService, modelPerspective, perspective, this, true);
        factory.createInitialLayout(modelLayout);
        PerspectiveTagger.tagPerspective(modelPerspective, this.modelService);
        PerspectiveExtensionReader reader = new PerspectiveExtensionReader();
        reader.extendLayout(this.getExtensionTracker(), perspective.getId(), modelLayout);
        if (lastPerspective != null) {
            this.legacyWindow.firePerspectiveDeactivated(this, lastPerspective);
        }
        perspectives.getChildren().add(modelPerspective);
        perspectives.setSelectedElement((MUIElement)modelPerspective);
        this.window.getContext().set("activeChildContext", (Object)modelPerspective.getContext());
        this.legacyWindow.firePerspectiveDeactivated(this, perspective);
    }

    private MPerspectiveStack getPerspectiveStack() {
        for (MWindowElement child : this.window.getChildren()) {
            if (!(child instanceof MPerspectiveStack)) continue;
            return (MPerspectiveStack)child;
        }
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        this.window.getChildren().add(perspectiveStack);
        this.window.setSelectedElement((MUIElement)perspectiveStack);
        return perspectiveStack;
    }

    public void setWorkingSet(IWorkingSet newWorkingSet) {
        IWorkingSet oldWorkingSet = this.workingSet;
        this.workingSet = newWorkingSet;
        if (oldWorkingSet != newWorkingSet) {
            this.firePropertyChange("workingSetReplace", oldWorkingSet, newWorkingSet);
        }
        if (newWorkingSet != null) {
            WorkbenchPlugin.getDefault().getWorkingSetManager().addPropertyChangeListener(this.workingSetPropertyChangeListener);
        } else {
            WorkbenchPlugin.getDefault().getWorkingSetManager().removePropertyChangeListener(this.workingSetPropertyChangeListener);
        }
    }

    @Override
    public void showActionSet(String actionSetID) {
        MPerspective persp = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        if (persp == null) {
            return;
        }
        EContextService contextService = (EContextService)this.window.getContext().get(EContextService.class);
        String tag = "persp.actionSet:" + actionSetID;
        if (!persp.getTags().contains(tag)) {
            persp.getTags().add(tag);
            contextService.activateContext(actionSetID);
        }
    }

    @Override
    public IViewPart showView(String viewID) throws PartInitException {
        return this.showView(viewID, null, 1);
    }

    @Override
    public IViewPart showView(final String viewID, final String secondaryID, final int mode) throws PartInitException {
        if (secondaryID != null && (secondaryID.length() == 0 || secondaryID.indexOf(":") != -1)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalSecondaryId);
        }
        if (!this.certifyMode(mode)) {
            throw new IllegalArgumentException(WorkbenchMessages.WorkbenchPage_IllegalViewMode);
        }
        final Object[] result = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    result[0] = WorkbenchPage.this.busyShowView(viewID, secondaryID, mode);
                }
                catch (PartInitException e) {
                    result[0] = e;
                }
            }
        });
        if (result[0] instanceof IViewPart) {
            return (IViewPart)result[0];
        }
        if (result[0] instanceof PartInitException) {
            throw (PartInitException)((Object)result[0]);
        }
        throw new PartInitException(WorkbenchMessages.WorkbenchPage_AbnormalWorkbenchCondition);
    }

    private boolean certifyMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setPartState(IWorkbenchPartReference ref, int state) {
        E4Util.unsupported("setPartState");
    }

    @Override
    public int getPartState(IWorkbenchPartReference ref) {
        return 2;
    }

    public void updateActionBars() {
        this.legacyWindow.updateActionBars();
    }

    @Override
    public void zoomOut() {
    }

    @Override
    public void toggleZoom(IWorkbenchPartReference ref) {
        MPerspective curPersp = this.modelService.getActivePerspective(this.window);
        String EAMaximizedHack = "EAMaximized";
        if (curPersp.getTags().contains(EAMaximizedHack)) {
            curPersp.getTags().remove(EAMaximizedHack);
        } else {
            curPersp.getTags().add(EAMaximizedHack);
        }
    }

    @Override
    public IPerspectiveDescriptor[] getOpenPerspectives() {
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null).get(0);
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] descs = new IPerspectiveDescriptor[perspectiveStack.getChildren().size()];
        int count = 0;
        for (MPerspective persp : perspectiveStack.getChildren()) {
            IPerspectiveDescriptor desc = registry.findPerspectiveWithId(persp.getElementId());
            descs[count++] = desc;
        }
        return descs;
    }

    @Override
    public IPerspectiveDescriptor[] getSortedPerspectives() {
        return this.sortedPerspectives.toArray(new IPerspectiveDescriptor[this.sortedPerspectives.size()]);
    }

    @Override
    public IWorkbenchPartReference getReference(IWorkbenchPart part) {
        for (IEditorReference iEditorReference : this.editorReferences) {
            if (iEditorReference.getPart(false) != part) continue;
            return iEditorReference;
        }
        for (IViewReference iViewReference : this.viewReferences) {
            if (iViewReference.getPart(false) != part) continue;
            return iViewReference;
        }
        return null;
    }

    @Override
    public IViewPart[] getViewStack(IViewPart part) {
        MPart mpart = this.partService.findPart(part.getSite().getId());
        if (mpart != null) {
            MElementContainer parent = mpart.getParent();
            if (parent instanceof MPartStack) {
                ArrayList<CompatibilityView> stack = new ArrayList<CompatibilityView>();
                for (Object child : parent.getChildren()) {
                    MPart siblingPart = child instanceof MPart ? (MPart)child : (MPart)((MPlaceholder)child).getRef();
                    Object siblingObject = siblingPart.getObject();
                    if (!(siblingObject instanceof CompatibilityView)) continue;
                    stack.add((CompatibilityView)siblingObject);
                }
                Collections.sort(stack, new Comparator<CompatibilityView>(){

                    @Override
                    public int compare(CompatibilityView o1, CompatibilityView o2) {
                        int pos1 = -1 * WorkbenchPage.this.activationList.indexOf(o1.getModel());
                        int pos2 = -1 * WorkbenchPage.this.activationList.indexOf(o2.getModel());
                        return pos1 - pos2;
                    }
                });
                IViewPart[] result = new IViewPart[stack.size()];
                int i = 0;
                while (i < result.length) {
                    result[i] = ((CompatibilityView)stack.get(i)).getView();
                    ++i;
                }
                return result;
            }
            return new IViewPart[]{part};
        }
        return null;
    }

    @Override
    public IExtensionTracker getExtensionTracker() {
        if (this.tracker == null) {
            this.tracker = new UIExtensionTracker(this.getWorkbenchWindow().getWorkbench().getDisplay());
        }
        return this.tracker;
    }

    private String[] getArrayForTag(String tagPrefix) {
        MPerspective perspective = (MPerspective)this.getPerspectiveStack().getSelectedElement();
        if (perspective == null) {
            return EMPTY_STRING_ARRAY;
        }
        List<String> id = ModeledPageLayout.getIds(perspective, tagPrefix);
        if (id.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return id.toArray(new String[id.size()]);
    }

    @Override
    public String[] getNewWizardShortcuts() {
        return this.getArrayForTag("persp.newWizSC:");
    }

    @Override
    public String[] getPerspectiveShortcuts() {
        return this.getArrayForTag("persp.perspSC:");
    }

    @Override
    public String[] getShowViewShortcuts() {
        return this.getArrayForTag("persp.viewSC:");
    }

    public boolean isPartVisible(IWorkbenchPartReference reference) {
        IWorkbenchPart part = reference.getPart(false);
        if (part == null) {
            return false;
        }
        return this.isPartVisible(part);
    }

    @Override
    public IWorkingSet[] getWorkingSets() {
        return this.workingSets;
    }

    @Override
    public void setWorkingSets(IWorkingSet[] newWorkingSets) {
        if (newWorkingSets != null) {
            WorkbenchPlugin.getDefault().getWorkingSetManager().addPropertyChangeListener(this.workingSetPropertyChangeListener);
        } else {
            WorkbenchPlugin.getDefault().getWorkingSetManager().removePropertyChangeListener(this.workingSetPropertyChangeListener);
        }
        if (newWorkingSets == null) {
            newWorkingSets = new IWorkingSet[]{};
        }
        Object[] oldWorkingSets = this.workingSets;
        if (newWorkingSets.length > 1) {
            HashSet<IWorkingSet> setOfSets = new HashSet<IWorkingSet>();
            int i = 0;
            while (i < newWorkingSets.length) {
                if (newWorkingSets[i] == null) {
                    throw new IllegalArgumentException();
                }
                setOfSets.add(newWorkingSets[i]);
                ++i;
            }
            newWorkingSets = setOfSets.toArray(new IWorkingSet[setOfSets.size()]);
        }
        this.workingSets = newWorkingSets;
        if (!Arrays.equals(oldWorkingSets, newWorkingSets)) {
            this.firePropertyChange("workingSetsReplace", oldWorkingSets, newWorkingSets);
            if (this.aggregateWorkingSet != null) {
                this.aggregateWorkingSet.setComponents(this.workingSets);
            }
        }
    }

    @Override
    public IWorkingSet getAggregateWorkingSet() {
        if (this.aggregateWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.aggregateWorkingSet = (AggregateWorkingSet)workingSetManager.getWorkingSet(this.getAggregateWorkingSetId());
            if (this.aggregateWorkingSet == null) {
                this.aggregateWorkingSet = (AggregateWorkingSet)workingSetManager.createAggregateWorkingSet(this.getAggregateWorkingSetId(), WorkbenchMessages.WorkbenchPage_workingSet_default_label, this.getWorkingSets());
                workingSetManager.addWorkingSet(this.aggregateWorkingSet);
            }
        }
        return this.aggregateWorkingSet;
    }

    private String getAggregateWorkingSetId() {
        if (this.aggregateWorkingSetId == null) {
            this.aggregateWorkingSetId = "Aggregate for window " + System.currentTimeMillis();
        }
        return this.aggregateWorkingSetId;
    }

    @Override
    public void showEditor(IEditorReference ref) {
        E4Util.unsupported("showEditor");
    }

    @Override
    public void hideEditor(IEditorReference ref) {
        E4Util.unsupported("hideEditor");
    }

    @Override
    public IEditorReference[] openEditors(IEditorInput[] inputs, String[] editorIDs, int matchFlags) throws MultiPartInitException {
        Assert.isTrue((inputs.length == editorIDs.length ? 1 : 0) != 0);
        PartInitException[] exceptions = new PartInitException[inputs.length];
        IWorkbenchPartReference[] references = new IEditorReference[inputs.length];
        boolean hasFailures = false;
        int i = 0;
        while (i < inputs.length) {
            block4: {
                try {
                    IEditorPart editor = this.openEditor(inputs[i], editorIDs[i], i == 0, matchFlags);
                    references[i] = (IEditorReference)this.getReference(editor);
                }
                catch (PartInitException e) {
                    if (hasFailures) break block4;
                    hasFailures = true;
                    exceptions[i] = e;
                }
            }
            ++i;
        }
        if (hasFailures) {
            throw new MultiPartInitException(references, exceptions);
        }
        return references;
    }

    private void firePartActivated(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            Object listener;
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            if (partReference == null) {
                WorkbenchPlugin.log("Reference is null in firePartActivated");
                return;
            }
            Object[] objectArray = this.partListenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                ((IPartListener)listener).partActivated(workbenchPart);
                ++n2;
            }
            objectArray = this.partListener2List.getListeners();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                ((IPartListener2)listener).partActivated(partReference);
                ++n2;
            }
        }
    }

    private void firePartDeactivated(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            Object listener;
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            Object[] objectArray = this.partListenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                ((IPartListener)listener).partDeactivated(workbenchPart);
                ++n2;
            }
            objectArray = this.partListener2List.getListeners();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                ((IPartListener2)listener).partDeactivated(partReference);
                ++n2;
            }
        }
    }

    public void firePartOpened(CompatibilityPart compatibilityPart) {
        Object listener;
        IWorkbenchPart part = compatibilityPart.getPart();
        WorkbenchPartReference partReference = compatibilityPart.getReference();
        SaveablesList saveablesList = (SaveablesList)this.getWorkbenchWindow().getService(ISaveablesLifecycleListener.class);
        saveablesList.postOpen(part);
        Object[] objectArray = this.partListenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            ((IPartListener)listener).partOpened(part);
            ++n2;
        }
        objectArray = this.partListener2List.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            ((IPartListener2)listener).partOpened(partReference);
            ++n2;
        }
    }

    public void firePartClosed(CompatibilityPart compatibilityPart) {
        Object listener;
        IWorkbenchPart part = compatibilityPart.getPart();
        WorkbenchPartReference partReference = compatibilityPart.getReference();
        Object[] objectArray = this.partListenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            ((IPartListener)listener).partClosed(part);
            ++n2;
        }
        objectArray = this.partListener2List.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            ((IPartListener2)listener).partClosed(partReference);
            ++n2;
        }
        if (!(part instanceof IViewPart)) {
            this.editorReferences.remove(partReference);
        }
        int i = 0;
        while (i < this.activationList.size()) {
            if (partReference.getModel() == this.activationList.get(i)) {
                this.activationList.remove(i);
                break;
            }
            ++i;
        }
        this.updateActivePartSources(null);
        this.updateActiveEditorSources(null);
    }

    private void firePartBroughtToTop(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            Object listener;
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            Object[] objectArray = this.partListenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                ((IPartListener)listener).partBroughtToTop(workbenchPart);
                ++n2;
            }
            objectArray = this.partListener2List.getListeners();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                listener = objectArray[n2];
                ((IPartListener2)listener).partBroughtToTop(partReference);
                ++n2;
            }
        }
    }

    private void firePartVisible(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            Object[] objectArray = this.partListener2List.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPartListener2)listener).partVisible(partReference);
                ++n2;
            }
        }
    }

    private void firePartHidden(MPart part) {
        Object client = part.getObject();
        if (client instanceof CompatibilityPart) {
            IWorkbenchPart workbenchPart = ((CompatibilityPart)client).getPart();
            IWorkbenchPartReference partReference = this.getReference(workbenchPart);
            Object[] objectArray = this.partListener2List.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPartListener2)listener).partHidden(partReference);
                ++n2;
            }
        }
    }

    @Override
    public int getEditorReuseThreshold() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        return store.getInt("REUSE_OPEN_EDITORS");
    }

    @Override
    public void setEditorReuseThreshold(int openEditors) {
    }

    public IEditorPart openEditorFromDescriptor(IEditorInput fileEditorInput, IEditorDescriptor editorDescriptor, boolean activate, IMemento editorState) throws PartInitException {
        if (editorDescriptor.isOpenExternal()) {
            this.openExternalEditor((EditorDescriptor)editorDescriptor, fileEditorInput);
            return null;
        }
        return this.openEditor(fileEditorInput, editorDescriptor.getId(), activate, 1, editorState);
    }

    private IEditorReference openExternalEditor(final EditorDescriptor desc, IEditorInput input) throws PartInitException {
        final CoreException[] ex = new CoreException[1];
        final IPathEditorInput pathInput = this.getPathEditorInput(input);
        if (pathInput == null || pathInput.getPath() == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_errorOpeningExternalEditor, (Object)desc.getFileName(), (Object)desc.getId()));
        }
        BusyIndicator.showWhile((Display)this.legacyWindow.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    if (desc.getLauncher() != null) {
                        Object launcher = WorkbenchPlugin.createExtension(desc.getConfigurationElement(), "launcher");
                        ((IEditorLauncher)launcher).open(pathInput.getPath());
                    } else {
                        ExternalEditor oEditor = new ExternalEditor(pathInput.getPath(), desc);
                        oEditor.open();
                    }
                }
                catch (CoreException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_errorOpeningExternalEditor, (Object)desc.getFileName(), (Object)desc.getId()), ex[0]);
        }
        return null;
    }

    private IPathEditorInput getPathEditorInput(IEditorInput input) {
        if (input instanceof IPathEditorInput) {
            return (IPathEditorInput)input;
        }
        return (IPathEditorInput)Util.getAdapter(input, IPathEditorInput.class);
    }

    class E4PartListener
    implements org.eclipse.e4.ui.workbench.modeling.IPartListener {
        E4PartListener() {
        }

        public void partActivated(MPart part) {
            WorkbenchPage.this.updateActivations(part);
            WorkbenchPage.this.firePartActivated(part);
        }

        public void partBroughtToTop(MPart part) {
            WorkbenchPage.this.updateBroughtToTop(part);
            WorkbenchPage.this.firePartBroughtToTop(part);
        }

        public void partDeactivated(MPart part) {
            WorkbenchPage.this.firePartDeactivated(part);
            Object client = part.getObject();
            if (client instanceof CompatibilityPart) {
                PartSite site = (PartSite)((CompatibilityPart)client).getPart().getSite();
                site.deactivateActionBars(site instanceof ViewSite);
            }
            ((WorkbenchWindow)WorkbenchPage.this.getWorkbenchWindow()).getStatusLineManager().update(false);
        }

        public void partHidden(MPart part) {
            WorkbenchPage.this.firePartHidden(part);
        }

        public void partVisible(MPart part) {
            WorkbenchPage.this.firePartVisible(part);
        }
    }
}

