/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.FullConstraintCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;

public final class ConstraintCollector
extends ASTVisitor {
    private final ConstraintCreator fCreator;
    private final Set fConstraints;

    public ConstraintCollector() {
        this(new FullConstraintCreator());
    }

    public ConstraintCollector(ConstraintCreator creator) {
        Assert.isNotNull((Object)creator);
        this.fCreator = creator;
        this.fConstraints = new LinkedHashSet();
    }

    private void add(ITypeConstraint[] constraints) {
        this.fConstraints.addAll(Arrays.asList(constraints));
    }

    public void clear() {
        this.fConstraints.clear();
    }

    public ITypeConstraint[] getConstraints() {
        return this.fConstraints.toArray(new ITypeConstraint[this.fConstraints.size()]);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ArrayAccess node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ArrayCreation node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ArrayInitializer node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ArrayType node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(AssertStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(Assignment node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(Block node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(BooleanLiteral node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(BreakStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(CastExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(CatchClause node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(CharacterLiteral node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(CompilationUnit node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ConditionalExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ContinueStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(DoStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(EmptyStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ExpressionStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(FieldAccess node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ForStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(IfStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(InfixExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(Initializer node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(InstanceofExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(Javadoc node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(LabeledStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(MethodInvocation node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(NormalAnnotation node) {
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(NumberLiteral node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(PackageDeclaration node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(PostfixExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(PrefixExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(PrimitiveType node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(QualifiedName node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ReturnStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SimpleName node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SimpleType node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SingleMemberAnnotation node) {
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(StringLiteral node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SuperFieldAccess node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SwitchCase node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SwitchStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(SynchronizedStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ThisExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(ThrowStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(TryStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(TypeDeclarationStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(TypeLiteral node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }

    public boolean visit(WhileStatement node) {
        this.add(this.fCreator.create(node));
        return true;
    }
}

