/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ILogEntryListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class LogListener
extends CommandOutputListener {
    private static final String LOG_TIMESTAMP_FORMAT_OLD = "yyyy/MM/dd HH:mm:ss zzz";
    private static final String LOG_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss zzz";
    private static final Locale LOG_TIMESTAMP_LOCALE = Locale.US;
    private final DateFormat LOG_DATE_FORMATTER_OLD = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss zzz", LOG_TIMESTAMP_LOCALE);
    private final DateFormat LOG_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz", LOG_TIMESTAMP_LOCALE);
    private static final String NOTHING_KNOWN_ABOUT = "nothing known about ";
    private final int DONE = 4;
    private final int COMMENT = 3;
    private final int REVISION = 2;
    private final int SYMBOLIC_NAMES = 1;
    private final int BEGIN = 0;
    public static final String BRANCH_REVISION = "branchRevision";
    private static final CVSTag[] NO_TAGS = new CVSTag[0];
    private static final String[] NO_VERSIONS = new String[0];
    private RemoteFile currentFile;
    private int state = 0;
    private StringBuffer comment;
    private String fileState;
    private String revision;
    private String author;
    private Date creationDate;
    private List versions = new ArrayList();
    private Map internedStrings = new HashMap();
    private final ILogEntryListener listener;

    public LogListener(ILogEntryListener listener) {
        this.listener = listener;
    }

    public LogListener(RemoteFile file, ILogEntryListener listener) {
        this(listener);
        this.currentFile = file;
    }

    private String getRelativeFilePath(ICVSRepositoryLocation location, String fileName) {
        String rootDirectory;
        if (fileName.endsWith(",v")) {
            fileName = fileName.substring(0, fileName.length() - 2);
        }
        if ((fileName = Util.removeAtticSegment(fileName)).startsWith(rootDirectory = location.getRootDirectory())) {
            try {
                fileName = Util.getRelativePath(rootDirectory, fileName);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
                return null;
            }
        }
        return fileName;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        String serverMessage = this.getServerMessage(line, location);
        if (serverMessage != null && serverMessage.startsWith(NOTHING_KNOWN_ABOUT)) {
            return new CVSStatus(4, -17, line, commandRoot);
        }
        return OK;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        switch (this.state) {
            case 0: {
                int indexOfSelectedRevisions;
                String selectedRevisions;
                if (line.startsWith("RCS file: ")) {
                    String fileName = this.getRelativeFilePath(location, line.substring(10).trim());
                    if (fileName == null) {
                        this.currentFile = null;
                        this.handleInvalidFileName(location, fileName);
                        break;
                    }
                    if (this.currentFile != null && this.currentFile.getRepositoryRelativePath().equals(fileName)) break;
                    this.beginFile(location, fileName);
                    break;
                }
                if (line.startsWith("symbolic names:")) {
                    this.state = 1;
                    break;
                }
                if (line.startsWith("revision ")) {
                    this.revision = this.internAndCopyString(line.substring(9));
                    this.state = 2;
                    break;
                }
                if (!line.startsWith("total revisions:") || !(selectedRevisions = line.substring((indexOfSelectedRevisions = line.lastIndexOf("selected revisions: ")) + 20).trim()).equals("0")) break;
                this.state = 3;
                this.revision = BRANCH_REVISION;
                this.comment = new StringBuffer();
                break;
            }
            case 1: {
                if (line.startsWith("keyword substitution:")) {
                    this.state = 0;
                    break;
                }
                int firstColon = line.indexOf(58);
                String tagName = this.internAndCopyString(line.substring(1, firstColon));
                String tagRevision = this.internAndCopyString(line.substring(firstColon + 2));
                this.versions.add(new VersionInfo(tagRevision, tagName));
                break;
            }
            case 2: {
                int endOfDateIndex = line.indexOf(59, 6);
                this.creationDate = this.convertFromLogTime(String.valueOf(line.substring(6, endOfDateIndex)) + " GMT");
                int endOfAuthorIndex = line.indexOf(59, endOfDateIndex + 1);
                this.author = this.internAndCopyString(line.substring(endOfDateIndex + 11, endOfAuthorIndex));
                int endOfStateIndex = line.indexOf(59, endOfAuthorIndex + 1) < 0 ? line.length() : line.indexOf(59, endOfAuthorIndex + 1);
                this.fileState = this.internAndCopyString(line.substring(endOfAuthorIndex + 10, endOfStateIndex));
                this.comment = new StringBuffer();
                this.state = 3;
                break;
            }
            case 3: {
                if (line.startsWith("branches:")) break;
                if (line.equals("=============================================================================") || line.equals("----------------------------")) {
                    this.state = 4;
                    break;
                }
                if (this.comment == null) break;
                if (this.comment.length() != 0) {
                    this.comment.append('\n');
                }
                this.comment.append(line);
            }
        }
        if (this.state == 4) {
            List thisRevisionTags = this.versions.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(3);
            List revisionVersions = this.versions.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(3);
            Iterator i = this.versions.iterator();
            while (i.hasNext()) {
                VersionInfo version = (VersionInfo)i.next();
                String tagName = version.getTagName();
                String tagRevision = version.getTagRevision();
                if (!tagRevision.equals(this.revision) && !this.revision.equals(BRANCH_REVISION)) continue;
                String branchNumber = version.getBranchNumber();
                int type = version.isBranch() ? 1 : 2;
                thisRevisionTags.add(new CVSTag(tagName, branchNumber, type));
                if (!this.revision.equals(BRANCH_REVISION)) continue;
                revisionVersions.add(tagRevision);
            }
            if (this.currentFile != null) {
                LogEntry entry = new LogEntry(this.currentFile, this.revision, this.author, this.creationDate, this.internString(this.comment.toString()), this.fileState, !thisRevisionTags.isEmpty() ? thisRevisionTags.toArray(new CVSTag[thisRevisionTags.size()]) : NO_TAGS, !revisionVersions.isEmpty() ? revisionVersions.toArray(new String[revisionVersions.size()]) : NO_VERSIONS);
                this.addEntry(entry);
            }
            this.state = 0;
        }
        return OK;
    }

    protected void beginFile(ICVSRepositoryLocation location, String fileName) {
        this.currentFile = RemoteFile.create(fileName, location);
        this.versions.clear();
    }

    protected void addEntry(LogEntry entry) {
        this.listener.handleLogEntryReceived(entry);
    }

    protected void handleInvalidFileName(ICVSRepositoryLocation location, String badFilePath) {
        CVSProviderPlugin.log(2, "Invalid file path '" + badFilePath + "' received from " + location.toString(), null);
    }

    private Date convertFromLogTime(String modTime) {
        DateFormat format = this.LOG_DATE_FORMATTER;
        if (modTime.length() > 4 && modTime.charAt(4) == '/') {
            format = this.LOG_DATE_FORMATTER_OLD;
        }
        try {
            return format.parse(modTime);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private String internAndCopyString(String string) {
        String internedString = (String)this.internedStrings.get(string);
        if (internedString == null) {
            internedString = new String(string);
            this.internedStrings.put(internedString, internedString);
        }
        return internedString;
    }

    private String internString(String string) {
        String internedString = (String)this.internedStrings.get(string);
        if (internedString == null) {
            internedString = string;
            this.internedStrings.put(internedString, internedString);
        }
        return internedString;
    }

    private static class VersionInfo {
        private final boolean isBranch;
        private String tagRevision;
        private String branchNumber;
        private final String tagName;

        public VersionInfo(String version, String tagName) {
            this.tagName = tagName;
            this.isBranch = this.isBranchTag(version);
            this.tagRevision = version;
            if (this.isBranch) {
                int lastDot = version.lastIndexOf(46);
                if (lastDot == -1) {
                    CVSProviderPlugin.log(4, NLS.bind((String)CVSMessages.LogListener_invalidRevisionFormat, (Object[])new String[]{tagName, version}), null);
                } else {
                    if (version.charAt(lastDot - 1) == '0' && version.charAt(lastDot - 2) == '.') {
                        lastDot -= 2;
                    }
                    this.tagRevision = version.substring(0, lastDot);
                    this.branchNumber = version.substring(lastDot + 1);
                }
            }
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getTagRevision() {
            return this.tagRevision;
        }

        public boolean isBranch() {
            return this.isBranch;
        }

        private boolean isBranchTag(String tagName) {
            int numberOfDots = 0;
            int lastDot = 0;
            int i = 0;
            while (i < tagName.length()) {
                if (tagName.charAt(i) == '.') {
                    ++numberOfDots;
                    lastDot = i;
                }
                ++i;
            }
            if (numberOfDots % 2 == 0) {
                return true;
            }
            if (numberOfDots == 1) {
                return false;
            }
            return tagName.charAt(lastDot - 1) == '0' && tagName.charAt(lastDot - 2) == '.';
        }

        public String getBranchNumber() {
            return this.branchNumber;
        }
    }
}

