/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;

public abstract class Refactoring
extends PlatformObject {
    private Object fValidationContext;

    public final void setValidationContext(Object context) {
        this.fValidationContext = context;
    }

    public final Object getValidationContext() {
        return this.fValidationContext;
    }

    public abstract String getName();

    public final RefactoringTickProvider getRefactoringTickProvider() {
        RefactoringTickProvider result = this.doGetRefactoringTickProvider();
        if (result == null) {
            result = RefactoringTickProvider.DEFAULT;
        }
        return result;
    }

    protected RefactoringTickProvider doGetRefactoringTickProvider() {
        return RefactoringTickProvider.DEFAULT;
    }

    public RefactoringStatus checkAllConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringTickProvider refactoringTickProvider = this.getRefactoringTickProvider();
        pm.beginTask("", refactoringTickProvider.getCheckAllConditionsTicks());
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, refactoringTickProvider.getCheckInitialConditionsTicks())));
        if (!result.hasFatalError()) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, refactoringTickProvider.getCheckFinalConditionsTicks())));
        }
        pm.done();
        return result;
    }

    public abstract RefactoringStatus checkInitialConditions(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public abstract RefactoringStatus checkFinalConditions(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public abstract Change createChange(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance((Object)this)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.getName();
    }
}

