/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.contentmergeviewer;

import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.runtime.Assert;

public class TokenComparator
implements ITokenComparator {
    private String fText;
    private int fCount;
    private int[] fStarts;
    private int[] fLengths;

    public TokenComparator(String text) {
        Assert.isNotNull((Object)text);
        this.fText = text;
        int length = this.fText.length();
        this.fStarts = new int[length];
        this.fLengths = new int[length];
        this.fCount = 0;
        int lastCategory = 0;
        int i = 0;
        while (i < length) {
            char c = this.fText.charAt(i);
            int category = 63;
            if (Character.isWhitespace(c)) {
                category = 32;
            } else if (Character.isDigit(c)) {
                category = 48;
            } else if (Character.isLetter(c)) {
                category = 97;
            } else if (c == '\"' || c == '\'') {
                category = 34;
            }
            if (category != lastCategory) {
                this.fStarts[this.fCount++] = i;
                lastCategory = category;
            }
            int n = this.fCount - 1;
            this.fLengths[n] = this.fLengths[n] + 1;
            ++i;
        }
    }

    public int getRangeCount() {
        return this.fCount;
    }

    public int getTokenStart(int index) {
        if (index < this.fCount) {
            return this.fStarts[index];
        }
        return this.fText.length();
    }

    public int getTokenLength(int index) {
        if (index < this.fCount) {
            return this.fLengths[index];
        }
        return 0;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        if (other != null && this.getClass() == other.getClass()) {
            int otherLen;
            TokenComparator tc = (TokenComparator)other;
            int thisLen = this.getTokenLength(thisIndex);
            if (thisLen == (otherLen = tc.getTokenLength(otherIndex))) {
                return this.fText.regionMatches(false, this.getTokenStart(thisIndex), tc.fText, tc.getTokenStart(otherIndex), thisLen);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int max, IRangeComparator other) {
        if (this.getRangeCount() < 50 || other.getRangeCount() < 50) {
            return false;
        }
        if (max < 100) {
            return false;
        }
        if (length < 100) {
            return false;
        }
        if (max > 800) {
            return true;
        }
        return length >= max / 4;
    }
}

