/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AbstractClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.IClasspathEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;

public class ClasspathEntry
extends AbstractClasspathEntry {
    private URL fUrl = null;
    private String fVariableString = null;
    private IAntClasspathEntry fEntry = null;

    public ClasspathEntry(Object o, IClasspathEntry parent) {
        this.fParent = parent;
        if (o instanceof URL) {
            this.fUrl = (URL)o;
        } else if (o instanceof String) {
            this.fVariableString = (String)o;
        } else if (o instanceof IAntClasspathEntry) {
            this.fEntry = (IAntClasspathEntry)o;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof IAntClasspathEntry) {
            IAntClasspathEntry other = (IAntClasspathEntry)obj;
            return other.getLabel().equals(this.getLabel());
        }
        return false;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toString() {
        if (this.fEntry != null) {
            return this.fEntry.getLabel();
        }
        if (this.getURL() != null) {
            return this.getURL().getFile();
        }
        return this.getVariableString();
    }

    protected URL getURL() {
        return this.fUrl;
    }

    protected String getVariableString() {
        return this.fVariableString;
    }

    public String getLabel() {
        if (this.fEntry == null) {
            return this.toString();
        }
        return this.fEntry.getLabel();
    }

    public URL getEntryURL() {
        if (this.fEntry != null) {
            return this.fEntry.getEntryURL();
        }
        if (this.fUrl != null) {
            return this.fUrl;
        }
        try {
            String expanded = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fVariableString);
            return new URL("file:" + expanded);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
        }
        return null;
    }

    public boolean isEclipseRuntimeRequired() {
        if (this.fEntry == null) {
            return super.isEclipseRuntimeRequired();
        }
        return this.fEntry.isEclipseRuntimeRequired();
    }
}

