/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.internal.ui.ProjectSetImporter;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public class ImportProjectSetOperation
extends TeamOperation {
    private String psfFile;
    private IWorkingSet[] workingSets;

    public ImportProjectSetOperation(IRunnableContext context, String psfFile, IWorkingSet[] workingSets) {
        super(context);
        this.psfFile = psfFile;
        this.workingSets = workingSets;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        PsfFilenameStore.remember(this.psfFile);
        IProject[] newProjects = ProjectSetImporter.importProjectSet(this.psfFile, this.getShell(), monitor);
        this.createWorkingSet(this.workingSets, newProjects);
    }

    protected boolean canRunAsJob() {
        return true;
    }

    protected String getJobName() {
        return TeamUIMessages.ImportProjectSetMainPage_jobName;
    }

    private void createWorkingSet(IWorkingSet[] workingSets, IProject[] projects) {
        IWorkingSetManager manager = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
        int i = 0;
        while (i < workingSets.length) {
            String workingSetName = workingSets[i].getName();
            IWorkingSet oldSet = manager.getWorkingSet(workingSetName);
            if (oldSet == null) {
                IWorkingSet newSet = manager.createWorkingSet(workingSetName, (IAdaptable[])projects);
                manager.addWorkingSet(newSet);
            } else {
                IAdaptable[] tempElements = oldSet.getElements();
                IAdaptable[] adaptedProjects = oldSet.adaptElements((IAdaptable[])projects);
                IAdaptable[] finalElementList = new IAdaptable[tempElements.length + adaptedProjects.length];
                System.arraycopy(tempElements, 0, finalElementList, 0, tempElements.length);
                System.arraycopy(adaptedProjects, 0, finalElementList, tempElements.length, adaptedProjects.length);
                oldSet.setElements(finalElementList);
            }
            ++i;
        }
    }
}

