/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.mirroring;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.RawMirrorRequest;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.tools.comparator.ArtifactComparatorFactory;
import org.eclipse.equinox.p2.repository.tools.comparator.IArtifactComparator;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mirroring {
    private IArtifactRepository source;
    private IArtifactRepository destination;
    private IArtifactRepository baseline;
    private boolean raw;
    private boolean compare = false;
    private boolean validate = false;
    private IArtifactComparator comparator;
    private IQuery<IArtifactDescriptor> compareExclusionQuery = null;
    private Set<IArtifactDescriptor> compareExclusions = CollectionUtils.emptySet();
    private String comparatorID;
    private List<IArtifactKey> keysToMirror;
    private IArtifactMirrorLog comparatorLog;

    private IArtifactComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = ArtifactComparatorFactory.getArtifactComparator(this.comparatorID);
        }
        return this.comparator;
    }

    public Mirroring(IArtifactRepository source, IArtifactRepository destination, boolean raw) {
        this.source = source;
        this.destination = destination;
        this.raw = raw;
    }

    public void setCompare(boolean compare) {
        this.compare = compare;
    }

    public void setComparatorId(String id) {
        this.comparatorID = id;
    }

    public void setComparatorLog(IArtifactMirrorLog comparatorLog) {
        this.comparatorLog = comparatorLog;
    }

    public void setBaseline(IArtifactRepository baseline) {
        this.baseline = baseline;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public MultiStatus run(boolean failOnError, boolean verbose) {
        IStatus validation;
        if (!this.destination.isModifiable()) {
            throw new IllegalStateException(NLS.bind((String)Messages.exception_destinationNotModifiable, (Object)this.destination.getLocation()));
        }
        if (this.compare) {
            this.getComparator();
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.p2.transformer", 0, Messages.message_mirroringStatus, null);
        Iterator keys = null;
        if (this.keysToMirror != null) {
            keys = this.keysToMirror.iterator();
        } else {
            IQueryResult result = this.source.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
            keys = result.iterator();
        }
        if (this.compareExclusionQuery != null) {
            IQueryResult exclusions = this.source.descriptorQueryable().query(this.compareExclusionQuery, null);
            this.compareExclusions = exclusions.toUnmodifiableSet();
        }
        while (keys.hasNext()) {
            IArtifactKey key = (IArtifactKey)keys.next();
            IArtifactDescriptor[] descriptors = this.source.getArtifactDescriptors(key);
            int j = 0;
            while (j < descriptors.length) {
                IStatus result = this.mirror(descriptors[j], verbose);
                if (!result.isOK() && (verbose || result.getSeverity() == 4)) {
                    multiStatus.add(result);
                }
                if (failOnError && multiStatus.getSeverity() == 4) {
                    return multiStatus;
                }
                ++j;
            }
        }
        if (this.validate && !(validation = this.validateMirror(verbose)).isOK() && (verbose || validation.getSeverity() == 4)) {
            multiStatus.add(validation);
        }
        return multiStatus;
    }

    private IStatus mirror(IArtifactDescriptor sourceDescriptor, boolean verbose) {
        boolean comparing;
        IArtifactDescriptor targetDescriptor = this.raw ? sourceDescriptor : new ArtifactDescriptor(sourceDescriptor);
        IArtifactDescriptor baselineDescriptor = this.getBaselineDescriptor(sourceDescriptor);
        if (verbose) {
            System.out.println(new StringBuffer("Mirroring: ").append(sourceDescriptor.getArtifactKey()).append(" (Descriptor: ").append(sourceDescriptor).append(")").toString());
        }
        MultiStatus compareStatus = new MultiStatus("org.eclipse.equinox.p2.transformer", 0, null, null);
        boolean bl = comparing = this.compare && !this.compareExclusions.contains(sourceDescriptor);
        if (comparing) {
            if (baselineDescriptor != null) {
                compareStatus.add(this.compare(this.baseline, baselineDescriptor, this.source, sourceDescriptor));
                if (this.destination.contains(baselineDescriptor)) {
                    compareStatus.add(this.compareToDestination(baselineDescriptor));
                    return compareStatus;
                }
            } else if (this.destination.contains(targetDescriptor)) {
                compareStatus.add(this.compareToDestination(sourceDescriptor));
                return compareStatus;
            }
        }
        IArtifactRepository sourceRepository = baselineDescriptor != null ? this.baseline : this.source;
        sourceDescriptor = baselineDescriptor != null ? baselineDescriptor : sourceDescriptor;
        targetDescriptor = baselineDescriptor != null ? baselineDescriptor : targetDescriptor;
        IStatus status = null;
        if (!this.destination.contains(targetDescriptor)) {
            status = this.downloadArtifact(sourceRepository, targetDescriptor, sourceDescriptor);
        } else {
            String message = NLS.bind((String)Messages.mirror_alreadyExists, (Object)sourceDescriptor, (Object)this.destination);
            status = new Status(1, "org.eclipse.equinox.p2.transformer", 1201, message, null);
        }
        if (comparing) {
            compareStatus.add(status);
            return compareStatus;
        }
        return status;
    }

    private IStatus compareToDestination(IArtifactDescriptor descriptor) {
        IArtifactDescriptor[] destDescriptors = this.destination.getArtifactDescriptors(descriptor.getArtifactKey());
        IArtifactDescriptor destDescriptor = null;
        int i = 0;
        while (destDescriptor == null && i < destDescriptors.length) {
            if (destDescriptors[i].equals(descriptor)) {
                destDescriptor = destDescriptors[i];
            }
            ++i;
        }
        if (destDescriptor == null) {
            return new Status(1, "org.eclipse.equinox.p2.transformer", 1201, Messages.Mirroring_noMatchingDescriptor, null);
        }
        return this.compare(this.source, descriptor, this.destination, destDescriptor);
    }

    private IStatus compare(IArtifactRepository sourceRepository, IArtifactDescriptor sourceDescriptor, IArtifactRepository destRepository, IArtifactDescriptor destDescriptor) {
        IStatus comparison = this.getComparator().compare(sourceRepository, sourceDescriptor, destRepository, destDescriptor);
        if (this.comparatorLog != null && !comparison.isOK()) {
            this.comparatorLog.log(sourceDescriptor, comparison);
        }
        return comparison;
    }

    private IStatus downloadArtifact(IArtifactRepository sourceRepo, IArtifactDescriptor destDescriptor, IArtifactDescriptor srcDescriptor) {
        RawMirrorRequest request = new RawMirrorRequest(srcDescriptor, destDescriptor, this.destination);
        request.perform(sourceRepo, (IProgressMonitor)new NullProgressMonitor());
        return request.getResult();
    }

    public void setArtifactKeys(IArtifactKey[] keys) {
        this.keysToMirror = Arrays.asList(keys);
    }

    private IArtifactDescriptor getBaselineDescriptor(IArtifactDescriptor descriptor) {
        if (this.baseline == null || !this.baseline.contains(descriptor)) {
            return null;
        }
        IArtifactDescriptor[] baselineDescriptors = this.baseline.getArtifactDescriptors(descriptor.getArtifactKey());
        int i = 0;
        while (i < baselineDescriptors.length) {
            if (baselineDescriptors[i].equals(descriptor)) {
                return baselineDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    private IStatus validateMirror(boolean verbose) {
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.transformer", 0, Messages.Mirroring_ValidationError, null);
        Iterator keys = null;
        if (this.keysToMirror != null) {
            keys = this.keysToMirror.iterator();
        } else {
            IQueryResult result = this.source.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
            keys = result.iterator();
        }
        while (keys.hasNext()) {
            IArtifactKey artifactKey = (IArtifactKey)keys.next();
            IArtifactDescriptor[] srcDescriptors = this.source.getArtifactDescriptors(artifactKey);
            IArtifactDescriptor[] destDescriptors = this.destination.getArtifactDescriptors(artifactKey);
            Arrays.sort(srcDescriptors, new ArtifactDescriptorComparator());
            Arrays.sort(destDescriptors, new ArtifactDescriptorComparator());
            int src = 0;
            int dest = 0;
            while (src < srcDescriptors.length && dest < destDescriptors.length) {
                IArtifactDescriptor baselineDescriptor;
                if (!destDescriptors[dest].equals(srcDescriptors[src])) {
                    if (destDescriptors[dest].toString().compareTo(srcDescriptors[src].toString()) > 0) {
                        if (verbose) {
                            System.out.println(NLS.bind((String)Messages.Mirroring_missingDescriptor, (Object)srcDescriptors[src]));
                        }
                        status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.transformer", NLS.bind((String)Messages.Mirroring_missingDescriptor, (Object)srcDescriptors[src++])));
                        continue;
                    }
                    ++dest;
                    continue;
                }
                Map destMap = destDescriptors[dest].getProperties();
                Map srcProperties = null;
                if (this.baseline != null && (baselineDescriptor = this.getBaselineDescriptor(destDescriptors[dest])) != null) {
                    srcProperties = baselineDescriptor.getProperties();
                }
                if (srcProperties == null) {
                    srcProperties = srcDescriptors[src].getProperties();
                }
                for (String key : srcProperties.keySet()) {
                    if (((String)srcProperties.get(key)).equals(destMap.get(key))) continue;
                    if (verbose) {
                        System.out.println(NLS.bind((String)Messages.Mirroring_differentDescriptorProperty, (Object[])new Object[]{destDescriptors[dest], key, srcProperties.get(key), destMap.get(key)}));
                    }
                    status.add((IStatus)new Status(2, "org.eclipse.equinox.p2.transformer", NLS.bind((String)Messages.Mirroring_differentDescriptorProperty, (Object[])new Object[]{destDescriptors[dest], key, srcProperties.get(key), destMap.get(key)})));
                }
                ++src;
                ++dest;
            }
            while (src < srcDescriptors.length) {
                if (verbose) {
                    System.out.println(NLS.bind((String)Messages.Mirroring_missingDescriptor, (Object)srcDescriptors[src]));
                }
                status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.transformer", NLS.bind((String)Messages.Mirroring_missingDescriptor, (Object)srcDescriptors[src++])));
            }
        }
        return status;
    }

    public void setCompareExclusions(IQuery<IArtifactDescriptor> excludedKeys) {
        this.compareExclusionQuery = excludedKeys;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArtifactDescriptorComparator
    implements Comparator<IArtifactDescriptor> {
        protected ArtifactDescriptorComparator() {
        }

        @Override
        public int compare(IArtifactDescriptor arg0, IArtifactDescriptor arg1) {
            if (arg0 != null && arg1 != null) {
                return arg0.toString().compareTo(arg1.toString());
            }
            if (arg1 == null && arg0 == null) {
                return 0;
            }
            if (arg1 == null) {
                return 1;
            }
            return -1;
        }
    }
}

