/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IPluginContribution;
import org.osgi.framework.Bundle;

class SearchPageDescriptor
implements IPluginContribution,
Comparable {
    public static final String PAGE_TAG = "page";
    private static final String ID_ATTRIBUTE = "id";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String SIZE_ATTRIBUTE = "sizeHint";
    private static final String TAB_POSITION_ATTRIBUTE = "tabPosition";
    private static final String EXTENSIONS_ATTRIBUTE = "extensions";
    private static final String SHOW_SCOPE_SECTION_ATTRIBUTE = "showScopeSection";
    private static final String CAN_SEARCH_ENCLOSING_PROJECTS = "canSearchEnclosingProjects";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String SEARCH_VIEW_HELP_CONTEXT_ID_ATTRIBUTE = "searchViewHelpContextId";
    public static final Point UNKNOWN_SIZE = new Point(-1, -1);
    private static final String SECTION_ID = "Search";
    private static final String STORE_ENABLED_PAGE_IDS = "Search.enabledPageIds";
    private static final String STORE_PROCESSED_PAGE_IDS = "Search.processedPageIds";
    private static List fgEnabledPageIds;
    private IConfigurationElement fElement;
    private List fExtensionScorePairs;
    private int fWildcardScore = -1;
    private ISearchPage fCreatedPage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SearchPageDescriptor(IConfigurationElement element) {
        this.fElement = element;
    }

    public ISearchPage createObject(ISearchPageContainer container) throws CoreException {
        if (this.fCreatedPage == null) {
            this.fCreatedPage = (ISearchPage)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
            this.fCreatedPage.setTitle(this.getLabel());
            this.fCreatedPage.setContainer(container);
        }
        return this.fCreatedPage;
    }

    public ISearchPage getPage() {
        return this.fCreatedPage;
    }

    public void dispose() {
        if (this.fCreatedPage != null) {
            this.fCreatedPage.dispose();
            this.fCreatedPage = null;
        }
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public ImageDescriptor getImage() {
        String imageName = this.fElement.getAttribute(ICON_ATTRIBUTE);
        if (imageName == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)this.getPluginId());
        return SearchPluginImages.createImageDescriptor(bundle, (IPath)new Path(imageName), true);
    }

    public String getLabel() {
        return this.fElement.getAttribute(LABEL_ATTRIBUTE);
    }

    public boolean showScopeSection() {
        return Boolean.valueOf(this.fElement.getAttribute(SHOW_SCOPE_SECTION_ATTRIBUTE));
    }

    public boolean isInitiallyEnabled() {
        String strVal = this.fElement.getAttribute(ENABLED_ATTRIBUTE);
        return strVal == null || Boolean.valueOf(strVal) != false;
    }

    public boolean canSearchInProjects() {
        return Boolean.valueOf(this.fElement.getAttribute(CAN_SEARCH_ENCLOSING_PROJECTS));
    }

    public Point getPreferredSize() {
        int commaSep;
        String sizeHint = this.fElement.getAttribute(SIZE_ATTRIBUTE);
        if (sizeHint != null && (commaSep = sizeHint.indexOf(44)) != -1) {
            try {
                int xval = Integer.parseInt(sizeHint.substring(0, commaSep).trim());
                int yval = Integer.parseInt(sizeHint.substring(commaSep + 1).trim());
                return new Point(xval, yval);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return UNKNOWN_SIZE;
    }

    public int getTabPosition() {
        int position = 0x3FFFFFFF;
        String str = this.fElement.getAttribute(TAB_POSITION_ATTRIBUTE);
        if (str != null) {
            try {
                position = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                ExceptionHandler.log(ex, SearchMessages.Search_Error_createSearchPage_message);
            }
        }
        return position;
    }

    boolean isEnabled() {
        return SearchPageDescriptor.getEnabledPageIds().contains(this.getId());
    }

    public String getSearchViewHelpContextId() {
        return this.fElement.getAttribute(SEARCH_VIEW_HELP_CONTEXT_ID_ATTRIBUTE);
    }

    static void setEnabled(Object[] enabledDescriptors) {
        fgEnabledPageIds = new ArrayList(5);
        int i = 0;
        while (i < enabledDescriptors.length) {
            if (enabledDescriptors[i] instanceof SearchPageDescriptor) {
                fgEnabledPageIds.add(((SearchPageDescriptor)enabledDescriptors[i]).getId());
            }
            ++i;
        }
        SearchPageDescriptor.storeEnabledPageIds();
    }

    private static List getEnabledPageIds() {
        if (fgEnabledPageIds == null) {
            List descriptors = SearchPlugin.getDefault().getSearchPageDescriptors();
            String[] enabledPageIds = SearchPageDescriptor.getDialogSettings().getArray(STORE_ENABLED_PAGE_IDS);
            fgEnabledPageIds = enabledPageIds == null ? new ArrayList(descriptors.size()) : new ArrayList<String>(Arrays.asList(enabledPageIds));
            String[] processedPageIdsArr = SearchPageDescriptor.getDialogSettings().getArray(STORE_PROCESSED_PAGE_IDS);
            ArrayList<Object> processedPageIds = processedPageIdsArr == null ? new ArrayList(descriptors.size()) : new ArrayList<String>(Arrays.asList(processedPageIdsArr));
            Iterator iter = descriptors.iterator();
            while (iter.hasNext()) {
                SearchPageDescriptor desc = (SearchPageDescriptor)iter.next();
                if (processedPageIds.contains(desc.getId())) continue;
                processedPageIds.add(desc.getId());
                if (!desc.isInitiallyEnabled()) continue;
                fgEnabledPageIds.add(desc.getId());
            }
            SearchPageDescriptor.getDialogSettings().put(STORE_PROCESSED_PAGE_IDS, processedPageIds.toArray(new String[processedPageIds.size()]));
            SearchPageDescriptor.storeEnabledPageIds();
        }
        return fgEnabledPageIds;
    }

    private static void storeEnabledPageIds() {
        SearchPageDescriptor.getDialogSettings().put(STORE_ENABLED_PAGE_IDS, fgEnabledPageIds.toArray(new String[fgEnabledPageIds.size()]));
        SearchPlugin.getDefault().savePluginPreferences();
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = SearchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SECTION_ID);
        if (section == null) {
            section = settings.addNewSection(SECTION_ID);
        }
        return section;
    }

    public int compareTo(Object o) {
        int myPos = this.getTabPosition();
        int objsPos = ((SearchPageDescriptor)o).getTabPosition();
        if (myPos == Integer.MAX_VALUE && objsPos == Integer.MAX_VALUE || myPos == objsPos) {
            return this.getLabel().compareTo(((SearchPageDescriptor)o).getLabel());
        }
        return myPos - objsPos;
    }

    public int computeScore(Object element) {
        if (element instanceof IAdaptable) {
            String extension;
            IResource resource;
            ISearchPageScoreComputer tester;
            int score = -1;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.search.ui.ISearchPageScoreComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((tester = (ISearchPageScoreComputer)iAdaptable.getAdapter((Class)clazz)) != null) {
                score = tester.computeScore(this.getId(), element);
            }
            IAdaptable iAdaptable2 = (IAdaptable)element;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable2.getAdapter((Class)clazz2)) != null && resource.getType() == 1 && (extension = ((IFile)resource).getFileExtension()) != null) {
                score = Math.max(score, this.getScoreForFileExtension(extension));
            }
            if (score != -1) {
                return score;
            }
        }
        if (this.fWildcardScore != -1) {
            return this.fWildcardScore;
        }
        return 0;
    }

    private int getScoreForFileExtension(String extension) {
        if (this.fExtensionScorePairs == null) {
            this.readExtensionScorePairs();
        }
        int size = this.fExtensionScorePairs.size();
        int i = 0;
        while (i < size) {
            ExtensionScorePair p = (ExtensionScorePair)this.fExtensionScorePairs.get(i);
            if (extension.equals(p.extension)) {
                return p.score;
            }
            ++i;
        }
        return -1;
    }

    private void readExtensionScorePairs() {
        this.fExtensionScorePairs = new ArrayList(3);
        String content = this.fElement.getAttribute(EXTENSIONS_ATTRIBUTE);
        if (content == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(content, ",");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            int pos = token.indexOf(58);
            if (pos == -1) continue;
            String extension = token.substring(0, pos);
            int score = StringConverter.asInt((String)token.substring(pos + 1).trim(), (int)-1);
            if (extension.equals("*")) {
                this.fWildcardScore = score;
                continue;
            }
            this.fExtensionScorePairs.add(new ExtensionScorePair(extension, score));
        }
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.fElement.getContributor().getName();
    }

    private static class ExtensionScorePair {
        public String extension;
        public int score;

        public ExtensionScorePair(String extension, int score) {
            this.extension = extension;
            this.score = score;
        }
    }
}

