/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.IModifyDialogTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class FormatterTabPage
extends ModifyDialogTabPage {
    private static final String SHOW_INVISIBLE_PREFERENCE_KEY = "org.eclipse.jdt.ui.formatter_page.show_invisible_characters";
    protected static String[] FALSE_TRUE = new String[]{"false", "true"};
    protected static String[] TRUE_FALSE = new String[]{"true", "false"};
    protected static String[] DO_NOT_INSERT_INSERT = new String[]{"do not insert", "insert"};
    private JavaPreview fPreview;
    private final IDialogSettings fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    private Button fShowInvisibleButton;

    public FormatterTabPage(IModifyDialogTabPage.IModificationListener modifyListener, Map workingValues) {
        super(modifyListener, workingValues);
    }

    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        FormatterTabPage.createLabel(numColumns - 1, composite, FormatterMessages.ModifyDialogTabPage_preview_label_text);
        this.fShowInvisibleButton = new Button(composite, 32);
        this.fShowInvisibleButton.setText(FormatterMessages.FormatterTabPage_ShowInvisibleCharacters_label);
        this.fShowInvisibleButton.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.fShowInvisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatterTabPage.this.fPreview.showInvisibleCharacters(FormatterTabPage.this.fShowInvisibleButton.getSelection());
                FormatterTabPage.this.fDialogSettings.put(FormatterTabPage.SHOW_INVISIBLE_PREFERENCE_KEY, FormatterTabPage.this.fShowInvisibleButton.getSelection());
                FormatterTabPage.this.doUpdatePreview();
            }
        });
        this.fShowInvisibleButton.setSelection(this.isShowInvisible());
        this.fPreview = this.doCreateJavaPreview(composite);
        this.fDefaultFocusManager.add(this.fPreview.getControl());
        this.fPreview.showInvisibleCharacters(this.fShowInvisibleButton.getSelection());
        GridData gd = FormatterTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fPreview.getControl().setLayoutData((Object)gd);
        return composite;
    }

    private boolean isShowInvisible() {
        return this.fDialogSettings.getBoolean(SHOW_INVISIBLE_PREFERENCE_KEY);
    }

    protected void doUpdatePreview() {
        boolean showInvisible = this.isShowInvisible();
        this.fPreview.showInvisibleCharacters(showInvisible);
        this.fShowInvisibleButton.setSelection(showInvisible);
    }
}

