/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.undo.DeleteResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.LTKLauncher;
import org.eclipse.ui.progress.WorkbenchJob;

public class DeleteResourceAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.DeleteResourceAction";
    private IShellProvider shellProvider = null;
    private boolean deleteContent = false;
    protected boolean fTestingMode = false;
    private String[] modelProviderIds;

    public DeleteResourceAction(final Shell shell) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        Assert.isNotNull((Object)shell);
        this.initAction();
        this.setShellProvider(new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        });
    }

    public DeleteResourceAction(IShellProvider provider) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        Assert.isNotNull((Object)provider);
        this.initAction();
        this.setShellProvider(provider);
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.DeleteResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.delete_resource_action_context");
        this.setId(ID);
    }

    private void setShellProvider(IShellProvider provider) {
        this.shellProvider = provider;
    }

    private boolean canDelete(IResource[] resources) {
        if (!this.containsOnlyProjects(resources) && !this.containsOnlyNonProjects(resources)) {
            return false;
        }
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.isPhantom()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean containsLinkedResource(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsOnlyNonProjects(IResource[] resources) {
        int types = this.getSelectedResourceTypes(resources);
        if (types == 0) {
            return false;
        }
        return (types & 4) == 0;
    }

    private boolean containsOnlyProjects(IResource[] resources) {
        int types = this.getSelectedResourceTypes(resources);
        return types == 4;
    }

    private boolean confirmDelete(IResource[] resources) {
        if (this.containsOnlyProjects(resources)) {
            return this.confirmDeleteProjects(resources);
        }
        return this.confirmDeleteNonProjects(resources);
    }

    private boolean confirmDeleteNonProjects(IResource[] resources) {
        String msg;
        String title;
        if (resources.length == 1) {
            title = IDEWorkbenchMessages.DeleteResourceAction_title1;
            IResource resource = resources[0];
            msg = resource.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResource1, (Object)resource.getName()) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirm1, (Object)resource.getName());
        } else {
            title = IDEWorkbenchMessages.DeleteResourceAction_titleN;
            msg = this.containsLinkedResource(resources) ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResourceN, (Object)new Integer(resources.length)) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmN, (Object)new Integer(resources.length));
        }
        return MessageDialog.openQuestion((Shell)this.shellProvider.getShell(), (String)title, (String)msg);
    }

    private boolean confirmDeleteProjects(IResource[] resources) {
        DeleteProjectDialog dialog = new DeleteProjectDialog(this.shellProvider.getShell(), resources);
        dialog.setTestingMode(this.fTestingMode);
        int code = dialog.open();
        this.deleteContent = dialog.getDeleteContent();
        return code == 0;
    }

    private IResource[] getSelectedResourcesArray() {
        List selection = this.getSelectedResources();
        IResource[] resources = new IResource[selection.size()];
        selection.toArray(resources);
        return resources;
    }

    private int getSelectedResourceTypes(IResource[] resources) {
        int types = 0;
        int i = 0;
        while (i < resources.length) {
            types |= resources[i].getType();
            ++i;
        }
        return types;
    }

    public void run() {
        final IResource[] resources = this.getSelectedResourcesArray();
        if (!this.fTestingMode && LTKLauncher.openDeleteWizard(this.getStructuredSelection())) {
            return;
        }
        if (!this.confirmDelete(resources)) {
            return;
        }
        Job deletionCheckJob = new Job(IDEWorkbenchMessages.DeleteResourceAction_checkJobName){

            protected IStatus run(IProgressMonitor monitor) {
                if (resources.length == 0) {
                    return Status.CANCEL_STATUS;
                }
                DeleteResourceAction.this.scheduleDeleteJob(resources);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (IDEWorkbenchMessages.DeleteResourceAction_jobName.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        deletionCheckJob.schedule();
    }

    private void scheduleDeleteJob(final IResource[] resourcesToDelete) {
        Job deleteJob = new Job(IDEWorkbenchMessages.DeleteResourceAction_jobName){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    DeleteResourcesOperation op = new DeleteResourcesOperation(resourcesToDelete, IDEWorkbenchMessages.DeleteResourceAction_operationLabel, DeleteResourceAction.this.deleteContent);
                    op.setModelProviderIds(DeleteResourceAction.this.getModelProviderIds());
                    if (DeleteResourceAction.this.deleteContent && DeleteResourceAction.this.containsOnlyProjects(resourcesToDelete)) {
                        WorkbenchJob statusJob = new WorkbenchJob(this, "Status checking", op){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ DeleteResourcesOperation val$op;
                            {
                                this.this$1 = var1_1;
                                this.val$op = deleteResourcesOperation;
                            }

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                return this.val$op.computeExecutionStatus(monitor);
                            }
                        };
                        statusJob.setSystem(true);
                        statusJob.schedule();
                        try {
                            statusJob.join();
                        }
                        catch (InterruptedException interruptedException) {}
                        if (statusJob.getResult().isOK()) {
                            return op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter(DeleteResourceAction.this.shellProvider.getShell()));
                        }
                        return statusJob.getResult();
                    }
                    return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter(DeleteResourceAction.this.shellProvider.getShell()));
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        return ((CoreException)e.getCause()).getStatus();
                    }
                    return new Status(4, "org.eclipse.ui.ide", e.getMessage(), (Throwable)e);
                }
            }

            public boolean belongsTo(Object family) {
                if (IDEWorkbenchMessages.DeleteResourceAction_jobName.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        deleteJob.setUser(true);
        deleteJob.schedule();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canDelete(this.getSelectedResourcesArray());
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private IResource[] projects;
        private boolean deleteContent = false;
        private boolean fIsTesting = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            final /* synthetic */ DeleteProjectDialog this$1;
            {
                this.this$1 = deleteProjectDialog;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteProjectDialog.access$1(this.this$1, button == DeleteProjectDialog.access$0(this.this$1));
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, IResource[] projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.projects = projects;
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }

        static String getTitle(IResource[] projects) {
            if (projects.length == 1) {
                return IDEWorkbenchMessages.DeleteResourceAction_titleProject1;
            }
            return IDEWorkbenchMessages.DeleteResourceAction_titleProjectN;
        }

        static String getMessage(IResource[] projects) {
            if (projects.length == 1) {
                IProject project = (IProject)projects[0];
                return NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProject1, (Object)project.getName());
            }
            return NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProjectN, (Object)new Integer(projects.length));
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.ide.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite parent) {
            IProject project;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = this.projects.length == 1 ? ((project = (IProject)this.projects[0]) == null || project.getLocation() == null ? IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_deleteContents1, (Object)project.getLocation().toOSString())) : IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN;
            this.radio1.setText(text1);
            this.radio1.setFont(parent.getFont());
            Label detailsLabel = new Label(composite, 16384);
            detailsLabel.setText(IDEWorkbenchMessages.DeleteResourceAction_deleteContentsDetails);
            detailsLabel.setFont(parent.getFont());
            GC gc = new GC((Drawable)detailsLabel);
            gc.setFont(detailsLabel.getParent().getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            GridData data = new GridData();
            data.horizontalIndent = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)21);
            detailsLabel.setLayoutData((Object)data);
            detailsLabel.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ DeleteProjectDialog this$1;
                {
                    this.this$1 = deleteProjectDialog;
                }

                public void mouseUp(MouseEvent e) {
                    DeleteProjectDialog.access$1(this.this$1, true);
                    DeleteProjectDialog.access$0(this.this$1).setSelection(DeleteProjectDialog.access$2(this.this$1));
                    DeleteProjectDialog.access$3(this.this$1).setSelection(!DeleteProjectDialog.access$2(this.this$1));
                }
            });
            new Label(composite, 16384);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = IDEWorkbenchMessages.DeleteResourceAction_doNotDeleteContents;
            this.radio2.setText(text2);
            this.radio2.setFont(parent.getFont());
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        boolean getDeleteContent() {
            return this.deleteContent;
        }

        public int open() {
            if (this.fIsTesting) {
                this.deleteContent = true;
                return 0;
            }
            return super.open();
        }

        void setTestingMode(boolean t) {
            this.fIsTesting = t;
        }

        static /* synthetic */ Button access$0(DeleteProjectDialog deleteProjectDialog) {
            return deleteProjectDialog.radio1;
        }

        static /* synthetic */ void access$1(DeleteProjectDialog deleteProjectDialog, boolean bl) {
            deleteProjectDialog.deleteContent = bl;
        }

        static /* synthetic */ boolean access$2(DeleteProjectDialog deleteProjectDialog) {
            return deleteProjectDialog.deleteContent;
        }

        static /* synthetic */ Button access$3(DeleteProjectDialog deleteProjectDialog) {
            return deleteProjectDialog.radio2;
        }
    }
}

