/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    int formHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int trimX = x - border;
        int trimY = y - border;
        int trimWidth = width + border * 2;
        int trimHeight = height + border * 2;
        if (this.horizontalBar != null) {
            trimY -= this.display.scrolledInsetY;
            trimHeight += this.display.scrolledInsetY + this.display.scrolledMarginY;
            if (this.verticalBar == null) {
                trimX -= this.display.scrolledInsetX;
                trimWidth += this.display.scrolledInsetX * 2;
                trimHeight -= this.display.scrolledInsetY * 2;
            }
        }
        if (this.verticalBar != null) {
            trimX -= this.display.scrolledInsetX;
            trimWidth += this.display.scrolledInsetX + this.display.scrolledMarginX;
            if (this.horizontalBar == null) {
                trimY -= this.display.scrolledInsetY;
                trimHeight += this.display.scrolledInsetY * 2;
                trimWidth -= this.display.scrolledInsetX * 2;
            }
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    ScrollBar createScrollBar(int type) {
        return new ScrollBar(this, type);
    }

    ScrollBar createStandardBar(int style) {
        if (this.scrolledHandle == 0) {
            return null;
        }
        ScrollBar bar = new ScrollBar();
        bar.parent = this;
        bar.style = style;
        bar.display = this.display;
        int[] nArray = new int[4];
        nArray[0] = OS.XmNhorizontalScrollBar;
        nArray[2] = OS.XmNverticalScrollBar;
        int[] argList = nArray;
        OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
        if (style == 256) {
            bar.handle = argList[1];
        }
        if (style == 512) {
            bar.handle = argList[3];
        }
        bar.hookEvents();
        bar.register();
        return bar;
    }

    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void destroyScrollBar(ScrollBar bar) {
        this.setScrollBarVisible(bar, false);
        if ((this.state & 2) != 0) {
            bar.destroyHandle();
        }
    }

    void deregister() {
        super.deregister();
        if (this.formHandle != 0) {
            this.display.removeWidget(this.formHandle);
        }
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        if (this.formHandle != 0) {
            this.enableHandle(enabled, this.formHandle);
        }
        if (this.scrolledHandle != 0) {
            this.enableHandle(enabled, this.scrolledHandle);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return new Rectangle(0, 0, argList[1], argList[3]);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void manageChildren() {
        int[] argList;
        if (this.scrolledHandle != 0) {
            OS.XtSetMappedWhenManaged(this.scrolledHandle, false);
            OS.XtManageChild(this.scrolledHandle);
        }
        if (this.formHandle != 0) {
            OS.XtSetMappedWhenManaged(this.formHandle, false);
            OS.XtManageChild(this.formHandle);
        }
        super.manageChildren();
        if (this.formHandle != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNborderWidth;
            argList = nArray;
            OS.XtGetValues(this.formHandle, argList, argList.length / 2);
            OS.XtResizeWidget(this.formHandle, 1, 1, argList[1]);
            OS.XtSetMappedWhenManaged(this.formHandle, true);
        }
        if (this.scrolledHandle != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNborderWidth;
            argList = nArray;
            OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
            OS.XtResizeWidget(this.scrolledHandle, 1, 1, argList[1]);
            OS.XtSetMappedWhenManaged(this.scrolledHandle, true);
        }
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        if (this.formHandle != 0) {
            this.propagateHandle(enabled, this.formHandle, 0);
        }
        if (this.scrolledHandle != 0) {
            this.propagateHandle(enabled, this.scrolledHandle, 0);
            if (this.horizontalBar != null) {
                this.horizontalBar.propagateWidget(enabled);
            }
            if (this.verticalBar != null) {
                this.verticalBar.propagateWidget(enabled);
            }
        }
    }

    void register() {
        super.register();
        if (this.formHandle != 0) {
            this.display.addWidget(this.formHandle, this);
        }
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseChildren(boolean destroy) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.formHandle = 0;
        this.scrolledHandle = 0;
    }

    void reskinChildren(int flags) {
        if (this.horizontalBar != null) {
            this.horizontalBar.reskin(flags);
        }
        if (this.verticalBar != null) {
            this.verticalBar.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean allChildren, boolean trim) {
        super.redrawWidget(x, y, width, height, redrawAll, allChildren, trim);
        if (!trim) {
            return;
        }
        if (this.formHandle == 0 && this.scrolledHandle == 0) {
            return;
        }
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)x, (short)y, root_x, root_y);
        if (this.formHandle != 0) {
            short[] form_x = new short[1];
            short[] form_y = new short[1];
            OS.XtTranslateCoords(this.formHandle, (short)0, (short)0, form_x, form_y);
            this.redrawHandle(root_x[0] - form_x[0], root_y[0] - form_y[0], width, height, redrawAll, this.formHandle);
        }
        if (this.scrolledHandle != 0) {
            short[] scrolled_x = new short[1];
            short[] scrolled_y = new short[1];
            OS.XtTranslateCoords(this.scrolledHandle, (short)0, (short)0, scrolled_x, scrolled_y);
            this.redrawHandle(root_x[0] - scrolled_x[0], root_y[0] - scrolled_y[0], width, height, redrawAll, this.scrolledHandle);
            if (this.horizontalBar != null && this.horizontalBar.getVisible()) {
                int horizontalHandle = this.horizontalBar.handle;
                short[] hscroll_x = new short[1];
                short[] hscroll_y = new short[1];
                OS.XtTranslateCoords(horizontalHandle, (short)0, (short)0, hscroll_x, hscroll_y);
                this.redrawHandle(root_x[0] - hscroll_x[0], root_y[0] - hscroll_y[0], width, height, redrawAll, horizontalHandle);
            }
            if (this.verticalBar != null && this.verticalBar.getVisible()) {
                int verticalHandle = this.verticalBar.handle;
                short[] vscroll_x = new short[1];
                short[] vscroll_y = new short[1];
                OS.XtTranslateCoords(verticalHandle, (short)0, (short)0, vscroll_x, vscroll_y);
                this.redrawHandle(root_x[0] - vscroll_x[0], root_y[0] - vscroll_y[0], width, height, redrawAll, verticalHandle);
            }
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        if (this.scrolledHandle == 0) {
            return false;
        }
        int barHandle = bar.handle;
        boolean managed = OS.XtIsManaged(barHandle);
        if (managed == visible) {
            return false;
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] argList = nArray;
        OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNwidth;
        nArray2[2] = OS.XmNheight;
        int[] argList1 = nArray2;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        if (visible) {
            OS.XtManageChild(barHandle);
        } else {
            OS.XtUnmanageChild(barHandle);
        }
        if ((this.state & 2) != 0 && this.formHandle != 0) {
            int[] argList2;
            int margin;
            boolean showBorder = (this.style & 0x800) != 0;
            int n = margin = showBorder || visible ? 3 : 0;
            if ((bar.style & 0x200) != 0) {
                argList2 = new int[]{OS.XmNmarginWidth, margin};
                OS.XtSetValues(this.formHandle, argList2, argList2.length / 2);
            }
            if ((bar.style & 0x100) != 0) {
                argList2 = new int[]{OS.XmNmarginHeight, margin};
                OS.XtSetValues(this.formHandle, argList2, argList2.length / 2);
            }
        }
        OS.XtResizeWidget(this.scrolledHandle, argList[1], argList[3], argList[5]);
        bar.sendEvent(visible ? 22 : 23);
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNwidth;
        nArray3[2] = OS.XmNheight;
        int[] argList3 = nArray3;
        OS.XtGetValues(this.handle, argList3, argList3.length / 2);
        return argList1[1] != argList3[1] || argList1[3] != argList3[3];
    }

    int topHandle() {
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        if (this.formHandle != 0) {
            return this.formHandle;
        }
        return this.handle;
    }
}

