/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XmAnyCallbackStruct;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    int accelerator;
    Menu parent;
    Menu menu;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(-1);
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        if (index == -1) {
            this.error(6);
        }
        this.createWidget(index);
    }

    void addAccelerator() {
        byte[] buffer;
        int ptr;
        int keysym;
        int newKey;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return;
        }
        if (OS.IsSunOS) {
            return;
        }
        String shift = "";
        String alt = "";
        String ctrl = "";
        if ((this.accelerator & 0x10000) != 0) {
            alt = "Meta ";
        }
        if ((this.accelerator & 0x20000) != 0) {
            shift = "Shift ";
        }
        if ((this.accelerator & 0x40000) != 0) {
            ctrl = "Ctrl ";
        }
        keysym = (newKey = Display.untranslateKey(keysym = this.accelerator & 0x100FFFF)) != 0 ? newKey : Display.wcsToMbcs((char)keysym);
        String key = String.valueOf(ctrl) + alt + shift + "<Key>" + this.keysymName(keysym);
        String allKeys = String.valueOf(key) + ",Lock " + key;
        String numLock = Display.numLock;
        if (numLock != null) {
            allKeys = String.valueOf(allKeys) + "," + numLock + " " + key + ",Lock " + numLock + " " + key;
        }
        if ((ptr = OS.XtMalloc((buffer = Converter.wcsToMbcs(null, allKeys, true)).length)) != 0) {
            OS.memmove(ptr, buffer, buffer.length);
        }
        int[] argList = new int[]{OS.XmNaccelerator, ptr};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (ptr != 0) {
            OS.XtFree(ptr);
        }
    }

    void addAccelerators() {
        this.addAccelerator();
        if (this.menu != null) {
            this.menu.addAccelerators();
        }
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        int[] argList;
        int parentHandle = this.parent.handle;
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList1 = nArray;
        OS.XtGetValues(parentHandle, argList1, argList1.length / 2);
        if (index != -1 && argList1[1] != 0) {
            int[] handles = new int[argList1[3]];
            OS.memmove(handles, argList1[1], argList1[3] * 4);
            int i = 0;
            int count = 0;
            while (i < argList1[3]) {
                if (OS.XtIsManaged(handles[i])) {
                    if (index == count) break;
                    ++count;
                }
                ++i;
            }
            if (index != count) {
                this.error(6);
            }
            index = i;
        }
        if ((this.style & 2) != 0) {
            argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNorientation, (this.parent.style & 2) != 0 ? 1 : 2, OS.XmNpositionIndex, index};
            this.handle = OS.XmCreateSeparatorGadget(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNpositionIndex, index};
        if ((this.style & 8) != 0) {
            this.handle = OS.XmCreatePushButtonGadget(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        if ((this.style & 0x30) != 0) {
            this.handle = OS.XmCreateToggleButtonGadget(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            int indicatorType = 2;
            if ((this.style & 0x20) != 0) {
                indicatorType = 1;
            }
            int[] argList2 = new int[]{OS.XmNindicatorType, indicatorType};
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            return;
        }
        this.handle = OS.XmCreateCascadeButtonGadget(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
    }

    void destroyWidget() {
        OS.XtUnmanageChild(this.handle);
        super.destroyWidget();
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!OS.XtIsManaged(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] nArray = new int[8];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return new Rectangle((short)argList[1], (short)argList[3], argList[5], argList[7]);
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNset;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    void hookEvents() {
        if ((this.style & 2) != 0) {
            return;
        }
        int windowProc = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNhelpCallback, windowProc, 17);
        if ((this.style & 0x40) != 0) {
            OS.XtAddCallback(this.handle, OS.XmNactivateCallback, windowProc, 9);
            OS.XtAddCallback(this.handle, OS.XmNcascadingCallback, windowProc, 12);
        } else {
            OS.XtAddCallback(this.handle, OS.XmNarmCallback, windowProc, 10);
            if ((this.style & 0x30) != 0) {
                OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, windowProc, 24);
            } else {
                OS.XtAddCallback(this.handle, OS.XmNactivateCallback, windowProc, 9);
            }
        }
    }

    boolean isAccelActive() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        if (menu == null) {
            return false;
        }
        Decorations shell = menu.parent;
        return shell.menuBar == menu;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    String keysymName(int keysym) {
        switch (keysym) {
            case 8: {
                return "BackSpace";
            }
            case 9: {
                return "Tab";
            }
            case 10: 
            case 13: 
            case 65290: {
                return "Return";
            }
            case 27: {
                return "Escape";
            }
            case 127: {
                return "Delete";
            }
        }
        if (48 <= keysym && keysym <= 57 || 97 <= keysym && keysym <= 122 || 65 <= keysym && keysym <= 90) {
            return new String(new char[]{(char)keysym});
        }
        int ptr = OS.XKeysymToString(keysym);
        if (ptr == 0) {
            return "";
        }
        int length = OS.strlen(ptr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr, buffer.length);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    void manageChildren() {
        OS.XtManageChild(this.handle);
    }

    void releaseChildren(boolean destroy) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.accelerator = 0;
        if (this == this.parent.defaultItem) {
            this.parent.defaultItem = null;
        }
        this.parent = null;
    }

    void removeAccelerator() {
        if (this.accelerator == 0) {
            return;
        }
        if (OS.IsSunOS) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNaccelerator;
        int[] argList = nArray;
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    void removeAccelerators() {
        this.removeAccelerator();
        if (this.menu != null) {
            this.menu.removeAccelerators();
        }
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void reskinChildren(int flags) {
        if (this.menu != null) {
            this.menu.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    void selectRadio() {
        int index = 0;
        MenuItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        if (this.accelerator == accelerator) {
            return;
        }
        this.accelerator = accelerator;
        if (this.isAccelActive()) {
            if (accelerator != 0) {
                this.addAccelerator();
            } else {
                this.removeAccelerator();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.getEnabled() == enabled) {
            return;
        }
        int[] argList = new int[]{OS.XmNsensitive, enabled ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (this.isAccelActive()) {
            if (enabled) {
                this.addAccelerator();
            } else {
                this.removeAccelerator();
            }
        }
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        boolean isActive = this.isAccelActive();
        if (isActive) {
            this.removeAccelerators();
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
        }
        this.menu = menu;
        int menuHandle = 0;
        if (menu != null) {
            menu.cascade = this;
            menuHandle = menu.handle;
        }
        int[] argList = new int[]{OS.XmNsubMenuId, menuHandle};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (isActive) {
            this.addAccelerators();
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNset, selected ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        if ((this.style & 6) != 0) {
            return;
        }
        if (OS.IsLinux && (this.style & 0x30) != 0 && string.length() == 0) {
            string = " ";
        }
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        boolean accel = false;
        int i = 0;
        int j = 0;
        int mnemonic = 0;
        while (i < text.length) {
            if (text[i] == '\t') {
                accel = true;
                break;
            }
            if ((text[j++] = text[i++]) != '&' || i == text.length) continue;
            if (text[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == 0) {
                mnemonic = text[i];
            }
            --j;
        }
        int xmString2 = 0;
        if (accel && ++i < text.length) {
            char[] accelText = new char[text.length - i];
            System.arraycopy(text, i, accelText, 0, accelText.length);
            byte[] buffer2 = Converter.wcsToMbcs(null, accelText, true);
            xmString2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            if (xmString2 == 0) {
                this.error(13);
            }
        } else {
            xmString2 = OS.XmStringGenerate(new byte[1], null, 0, null);
            if (xmString2 == 0) {
                this.error(13);
            }
        }
        while (j < text.length) {
            text[j++] = '\u0000';
        }
        byte[] buffer1 = Converter.wcsToMbcs(null, text, true);
        int xmString1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (xmString1 == 0) {
            this.error(13);
        }
        if (mnemonic == 0) {
            mnemonic = 0xFFFFFF;
        }
        int[] argList = new int[]{OS.XmNlabelString, xmString1, OS.XmNmnemonic, mnemonic, OS.XmNacceleratorText, xmString2};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if (xmString1 != 0) {
            OS.XmStringFree(xmString1);
        }
        if (xmString2 != 0) {
            OS.XmStringFree(xmString2);
        }
    }

    boolean translateAccelerator(int accel, boolean doit) {
        if (!this.getEnabled()) {
            return false;
        }
        if (this.menu != null) {
            return this.menu.translateAccelerator(accel, doit);
        }
        int accelerator = this.accelerator;
        if ((accelerator & 0x1000000) == 0) {
            int key = accelerator & 0x100FFFF;
            if (65 <= key && key <= 90) {
                key += 32;
            }
            int mods = accelerator & SWT.MODIFIER_MASK;
            accelerator = mods | key;
        }
        if (accelerator == accel) {
            if (doit) {
                this.postEvent(13);
            }
            return true;
        }
        return false;
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        if ((this.style & 0x40) != 0) {
            this.sendEvent(30);
        }
        if (!this.isEnabled()) {
            return 0;
        }
        XmAnyCallbackStruct struct = new XmAnyCallbackStruct();
        OS.memmove(struct, call_data, 8);
        Event event = new Event();
        if (struct.event != 0) {
            XButtonEvent xEvent = new XButtonEvent();
            OS.memmove(xEvent, struct.event, 60);
            event.time = xEvent.time;
            switch (xEvent.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.setInputState(event, xEvent.state);
                }
            }
        }
        this.postEvent(13, event);
        return 0;
    }

    int XmNarmCallback(int w, int client_data, int call_data) {
        this.sendEvent(30);
        return 0;
    }

    int XmNcascadingCallback(int w, int client_data, int call_data) {
        this.sendEvent(30);
        return 0;
    }

    int XmNhelpCallback(int w, int client_data, int call_data) {
        if (this.hooks(28)) {
            this.postEvent(28);
            return 0;
        }
        this.parent.sendHelpEvent(call_data);
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        if (!this.isEnabled()) {
            return 0;
        }
        XmAnyCallbackStruct struct = new XmAnyCallbackStruct();
        OS.memmove(struct, call_data, 8);
        Event event = new Event();
        if (struct.event != 0) {
            XButtonEvent xEvent = new XButtonEvent();
            OS.memmove(xEvent, struct.event, 60);
            event.time = xEvent.time;
            switch (xEvent.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.setInputState(event, xEvent.state);
                }
            }
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13, event);
        return 0;
    }
}

