/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XClientMessageEvent;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XConfigureEvent;
import org.eclipse.swt.internal.motif.XCreateWindowEvent;
import org.eclipse.swt.internal.motif.XDestroyWindowEvent;
import org.eclipse.swt.internal.motif.XEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XPropertyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XReparentEvent;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    public int embeddedHandle;
    int focusHandle;
    int damagedRegion;
    int clientWindow;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;
    static byte[] _XEMBED_INFO = Converter.wcsToMbcs(null, "_XEMBED_INFO", true);
    static byte[] _XEMBED = Converter.wcsToMbcs(null, "_XEMBED", true);

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    static int checkStyle(int style) {
        return style &= 0xBFFFFFFF;
    }

    Control[] _getChildren() {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return new Control[0];
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        int length = this.focusHandle != 0 ? count - 1 : count;
        Control[] children = new Control[length];
        int i = 0;
        int j = 0;
        while (i < count) {
            Widget widget;
            int handle = handles[i];
            if (handle != 0 && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
                children[j++] = (Control)widget;
            }
            ++i;
        }
        if (j == length) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        this.display.runSkin();
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x200) != 0);
                this.state &= 0xFFFFFDFF;
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x200;
                }
                child = composite;
                composite = child.parent;
            }
            ++i;
        }
    }

    void checkBuffered() {
        if ((this.state & 2) == 0) {
            super.checkBuffered();
        }
    }

    protected void checkSubclass() {
    }

    void createHandle(int index) {
        boolean scroll;
        this.state |= 2;
        boolean bl = scroll = (this.style & 0x300) != 0;
        if (!scroll) {
            this.state |= 0x80;
        }
        this.createHandle(index, this.parent.handle, scroll);
    }

    void createHandle(int index, int parentHandle, boolean scrolled) {
        int[] argList;
        if (scrolled) {
            argList = new int[]{OS.XmNancestorSensitive, 1};
            this.scrolledHandle = OS.XmCreateMainWindow(parentHandle, null, argList, argList.length / 2);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
        }
        if ((this.style & 0x300) != 0) {
            int[] nArray = new int[10];
            nArray[0] = OS.XmNmarginWidth;
            nArray[1] = 3;
            nArray[2] = OS.XmNmarginHeight;
            nArray[3] = 3;
            nArray[4] = OS.XmNresizePolicy;
            nArray[6] = OS.XmNshadowType;
            nArray[7] = 7;
            nArray[8] = OS.XmNshadowThickness;
            nArray[9] = this.hasBorder() ? this.display.buttonShadowThickness : 0;
            int[] argList1 = nArray;
            this.formHandle = OS.XmCreateForm(this.scrolledHandle, null, argList1, argList1.length / 2);
            if (this.formHandle == 0) {
                this.error(2);
            }
            int[] nArray2 = new int[18];
            nArray2[0] = OS.XmNtopAttachment;
            nArray2[1] = 1;
            nArray2[2] = OS.XmNbottomAttachment;
            nArray2[3] = 1;
            nArray2[4] = OS.XmNleftAttachment;
            nArray2[5] = 1;
            nArray2[6] = OS.XmNrightAttachment;
            nArray2[7] = 1;
            nArray2[8] = OS.XmNresizable;
            nArray2[10] = OS.XmNmarginWidth;
            nArray2[12] = OS.XmNmarginHeight;
            nArray2[14] = OS.XmNresizePolicy;
            nArray2[16] = OS.XmNtraversalOn;
            nArray2[17] = (this.style & 0x80000) != 0 ? 0 : 1;
            int[] argList2 = nArray2;
            this.handle = OS.XmCreateDrawingArea(this.formHandle, null, argList2, argList2.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            int[] nArray = new int[12];
            nArray[0] = OS.XmNancestorSensitive;
            nArray[1] = 1;
            nArray[2] = OS.XmNborderWidth;
            nArray[3] = this.hasBorder() ? 1 : 0;
            nArray[4] = OS.XmNmarginWidth;
            nArray[6] = OS.XmNmarginHeight;
            nArray[8] = OS.XmNresizePolicy;
            nArray[10] = OS.XmNtraversalOn;
            nArray[11] = (this.style & 0x80000) != 0 ? 0 : 1;
            argList = nArray;
            if (this.scrolledHandle != 0) {
                parentHandle = this.scrolledHandle;
            }
            this.handle = OS.XmCreateDrawingArea(parentHandle, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtraversalOn;
        argList = nArray;
        this.focusHandle = OS.XmCreateDrawingArea(this.handle, null, argList, argList.length / 2);
        if (this.focusHandle == 0) {
            this.error(2);
        }
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNforeground;
        nArray3[2] = OS.XmNbackground;
        int[] argList1 = nArray3;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        if (this.formHandle != 0) {
            OS.XtSetValues(this.formHandle, argList1, argList1.length / 2);
        }
    }

    int defaultBackground() {
        return this.display.compositeBackground;
    }

    int defaultForeground() {
        return this.display.compositeForeground;
    }

    void deregister() {
        super.deregister();
        if (this.focusHandle != 0) {
            this.display.removeWidget(this.focusHandle);
        }
    }

    void drawBackground(GC gc, int x, int y, int width, int height) {
        this.drawBackground(gc, x, y, width, height, 0, 0);
    }

    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        Control control;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            GCData data = gc.getGCData();
            int cairo = data.cairo;
            if (cairo != 0) {
                Cairo.cairo_save(cairo);
                if (control.backgroundImage != null) {
                    int pattern;
                    short[] root_x = new short[1];
                    short[] root_y = new short[1];
                    OS.XtTranslateCoords(this.handle, (short)0, (short)0, root_x, root_y);
                    short[] control_x = new short[1];
                    short[] control_y = new short[1];
                    OS.XtTranslateCoords(control.handle, (short)0, (short)0, control_x, control_y);
                    int tileX = root_x[0] - control_x[0];
                    int tileY = root_y[0] - control_y[0];
                    Cairo.cairo_translate(cairo, -tileX - offsetX, -tileY - offsetY);
                    x += tileX + offsetX;
                    y += tileY + offsetY;
                    int xDisplay = OS.XtDisplay(this.handle);
                    int xVisual = OS.XDefaultVisual(xDisplay, OS.XDefaultScreen(xDisplay));
                    int xDrawable = control.backgroundImage.pixmap;
                    int[] unused = new int[1];
                    int[] w = new int[1];
                    int[] h = new int[1];
                    OS.XGetGeometry(xDisplay, xDrawable, unused, unused, unused, w, h, unused, unused);
                    int surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, w[0], h[0]);
                    if (surface == 0) {
                        this.error(2);
                    }
                    if ((pattern = Cairo.cairo_pattern_create_for_surface(surface)) == 0) {
                        this.error(2);
                    }
                    Cairo.cairo_pattern_set_extend(pattern, 1);
                    Cairo.cairo_set_source(cairo, pattern);
                    Cairo.cairo_surface_destroy(surface);
                    Cairo.cairo_pattern_destroy(pattern);
                } else {
                    XColor color = this.getXColor(control.getBackgroundPixel());
                    Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)data.alpha / 255.0f);
                }
                Cairo.cairo_rectangle(cairo, x, y, width, height);
                Cairo.cairo_fill(cairo);
                Cairo.cairo_restore(cairo);
            } else {
                int xDisplay = OS.XtDisplay(this.handle);
                if (xDisplay == 0) {
                    return;
                }
                int xGC = gc.handle;
                XGCValues values = new XGCValues();
                if (control.backgroundImage != null) {
                    OS.XGetGCValues(xDisplay, xGC, 13568, values);
                    short[] root_x = new short[1];
                    short[] root_y = new short[1];
                    OS.XtTranslateCoords(this.handle, (short)0, (short)0, root_x, root_y);
                    short[] control_x = new short[1];
                    short[] control_y = new short[1];
                    OS.XtTranslateCoords(control.handle, (short)0, (short)0, control_x, control_y);
                    int tileX = root_x[0] - control_x[0];
                    int tileY = root_y[0] - control_y[0];
                    OS.XSetFillStyle(xDisplay, xGC, 1);
                    OS.XSetTSOrigin(xDisplay, xGC, -tileX - offsetX, -tileY - offsetY);
                    OS.XSetTile(xDisplay, xGC, control.backgroundImage.pixmap);
                    OS.XFillRectangle(data.display, data.drawable, xGC, x, y, width, height);
                    OS.XSetFillStyle(xDisplay, xGC, values.fill_style);
                    OS.XSetTSOrigin(xDisplay, xGC, values.ts_x_origin, values.ts_y_origin);
                } else {
                    OS.XGetGCValues(xDisplay, xGC, 4, values);
                    OS.XSetForeground(xDisplay, xGC, control.getBackgroundPixel());
                    OS.XFillRectangle(data.display, data.drawable, xGC, x, y, width, height);
                    OS.XSetForeground(xDisplay, xGC, values.foreground);
                }
            }
        } else {
            gc.fillRectangle(x, y, width, height);
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    int focusHandle() {
        if (this.focusHandle == 0) {
            return super.focusHandle();
        }
        return this.focusHandle;
    }

    int focusProc(int w, int client_data, int call_data, int continue_to_dispatch) {
        XFocusChangeEvent xEvent = new XFocusChangeEvent();
        OS.memmove(xEvent, call_data, 28);
        int handle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
        Shell shell = this.getShell();
        if (handle != shell.shellHandle) {
            return super.XFocusChange(w, client_data, call_data, continue_to_dispatch);
        }
        if (xEvent.mode != 0) {
            return 0;
        }
        block0 : switch (xEvent.detail) {
            case 3: 
            case 4: {
                switch (xEvent.type) {
                    case 9: {
                        this.sendClientEvent(0, 1, 0, 0, 0);
                        break block0;
                    }
                    case 10: {
                        this.sendClientEvent(0, 2, 0, 0, 0);
                    }
                }
            }
        }
        return 0;
    }

    boolean fowardKeyEvent(int event) {
        if (this.clientWindow == 0) {
            return false;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, event, 60);
        xEvent.window = this.clientWindow;
        int newEvent = OS.XtMalloc(96);
        OS.memmove(newEvent, xEvent, 60);
        int xDisplay = OS.XtDisplay(this.handle);
        OS.XSendEvent(xDisplay, this.clientWindow, false, 0, newEvent);
        OS.XSync(xDisplay, false);
        OS.XtFree(newEvent);
        this.display.setWarnings(warnings);
        return true;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        return this._getClientArea();
    }

    Rectangle _getClientArea() {
        if (this.formHandle != 0 && !OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        return super.getClientArea();
    }

    int getChildrenCount() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (this.focusHandle != 0) {
            return Math.max(0, argList[1] - 1);
        }
        return argList[1];
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            OS.XtInsertEventHandler(this.handle, 0, true, this.display.windowProc, 25, 1);
        }
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int focusProc = this.display.focusProc;
            int windowProc = this.display.windowProc;
            OS.XtInsertEventHandler(this.handle, 655360, false, windowProc, 27, 1);
            OS.XtInsertEventHandler(this.handle, 0x400000, false, windowProc, 33, 1);
            OS.XtInsertEventHandler(this.handle, 0, true, windowProc, 25, 1);
            Shell shell = this.getShell();
            OS.XtInsertEventHandler(shell.shellHandle, 0x200000, false, focusProc, this.handle, 1);
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        this.layout(changed, 0);
    }

    public void layout(Control[] changed, int flags) {
        this.checkWidget();
        if (changed != null) {
            int i = 0;
            while (i < changed.length) {
                Control control = changed[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                boolean ancestor = false;
                Composite composite = control.parent;
                while (composite != null) {
                    boolean bl = ancestor = composite == this;
                    if (ancestor) break;
                    composite = composite.parent;
                }
                if (!ancestor) {
                    this.error(32);
                }
                ++i;
            }
            int updateCount = 0;
            Composite[] update = new Composite[16];
            int i2 = 0;
            while (i2 < changed.length) {
                Control child = changed[i2];
                Composite composite = child.parent;
                while (child != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x100;
                        if (!composite.layout.flushCache(child)) {
                            composite.state |= 0x200;
                        }
                    }
                    if (updateCount == update.length) {
                        Composite[] newUpdate = new Composite[update.length + 16];
                        System.arraycopy(update, 0, newUpdate, 0, update.length);
                        update = newUpdate;
                    }
                    int n = updateCount++;
                    Composite composite2 = composite;
                    update[n] = composite2;
                    child = composite2;
                    composite = child.parent;
                }
                ++i2;
            }
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            i2 = updateCount - 1;
            while (i2 >= 0) {
                update[i2].updateLayout(false);
                --i2;
            }
        } else {
            if (this.layout == null && (flags & 1) == 0) {
                return;
            }
            this.markLayout((flags & 2) != 0, (flags & 1) != 0);
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((flags & 1) != 0);
        }
    }

    void manageChildren() {
        if (this.focusHandle != 0) {
            OS.XtSetMappedWhenManaged(this.focusHandle, false);
            OS.XtManageChild(this.focusHandle);
        }
        super.manageChildren();
        if (this.focusHandle != 0) {
            OS.XtConfigureWidget(this.focusHandle, 0, 0, 1, 1, 0);
            OS.XtSetMappedWhenManaged(this.focusHandle, true);
        }
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            Shell shell = this.getShell();
            shell.createFocusProxy();
            if (!OS.XtIsRealized(this.handle)) {
                shell.realizeWidget();
            }
            int xDisplay = OS.XtDisplay(this.handle);
            OS.XSync(xDisplay, false);
            this.embeddedHandle = OS.XtWindow(this.handle);
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x100;
            if (changed) {
                this.state |= 0x200;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    Point minimumSize(int wHint, int hHint, boolean changed) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void moveAbove(int handle1, int handle2) {
        if (handle1 == handle2) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return;
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        if (handle2 == 0) {
            handle2 = handles[0];
        }
        int i = 0;
        int index1 = -1;
        int index2 = -1;
        while (i < count) {
            int handle = handles[i];
            if (handle == handle1) {
                index1 = i;
            }
            if (handle == handle2) {
                index2 = i;
            }
            if (index1 != -1 && index2 != -1) break;
            ++i;
        }
        if (index1 == -1 || index2 == -1) {
            return;
        }
        if (index1 == index2) {
            return;
        }
        if (index1 < index2) {
            System.arraycopy(handles, index1 + 1, handles, index1, index2 - index1 - 1);
            handles[index2 - 1] = handle1;
        } else {
            System.arraycopy(handles, index2, handles, index2 + 1, index1 - index2);
            handles[index2] = handle1;
        }
        OS.memmove(ptr, handles, count * 4);
    }

    void moveBelow(int handle1, int handle2) {
        if (handle1 == handle2) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return;
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        if (handle2 == 0) {
            handle2 = handles[count - 1];
        }
        int i = 0;
        int index1 = -1;
        int index2 = -1;
        while (i < count) {
            int handle = handles[i];
            if (handle == handle1) {
                index1 = i;
            }
            if (handle == handle2) {
                index2 = i;
            }
            if (index1 != -1 && index2 != -1) break;
            ++i;
        }
        if (index1 == -1 || index2 == -1) {
            return;
        }
        if (index1 == index2) {
            return;
        }
        if (index1 < index2) {
            System.arraycopy(handles, index1 + 1, handles, index1, index2 - index1);
            handles[index2] = handle1;
        } else {
            System.arraycopy(handles, index2 + 1, handles, index2 + 2, index1 - index2 - 1);
            handles[index2 + 1] = handle1;
        }
        OS.memmove(ptr, handles, count * 4);
    }

    void propagateChildren(boolean enabled) {
        super.propagateChildren(enabled);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getEnabled()) {
                child.propagateChildren(enabled);
            }
            ++i;
        }
    }

    void realizeChildren() {
        super.realizeChildren();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].realizeChildren();
            ++i;
        }
        if (this.focusHandle != 0) {
            OS.XtUnmapWidget(this.focusHandle);
        }
        if ((this.state & 2) != 0 && ((this.style & 0x20040000) != 0 || (this.style & 0x100000) == 0)) {
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            int flags = 0;
            XSetWindowAttributes attributes = new XSetWindowAttributes();
            if ((this.style & 0x20040000) != 0) {
                flags |= 1;
                attributes.background_pixmap = 0;
            }
            if ((this.style & 0x100000) == 0) {
                flags |= 0x10;
                attributes.bit_gravity = 0;
            }
            if (flags != 0) {
                OS.XChangeWindowAttributes(xDisplay, xWindow, flags, attributes);
            }
        }
    }

    void redrawChildren() {
        super.redrawChildren();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if ((child.state & 0x40) != 0) {
                child.redrawWidget(0, 0, 0, 0, true, false, true);
                child.redrawChildren();
            }
            ++i;
        }
    }

    void register() {
        super.register();
        if (this.focusHandle != 0) {
            this.display.addWidget(this.focusHandle, this);
        }
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean allChildren, boolean trim) {
        super.redrawWidget(x, y, width, height, redrawAll, allChildren, trim);
        if (!allChildren) {
            return;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Point location = child.getClientLocation();
            child.redrawWidget(x - location.x, y - location.y, width, height, redrawAll, allChildren, true);
            ++i;
        }
    }

    void release(boolean destroy) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            Shell shell = this.getShell();
            int focusProc = this.display.focusProc;
            OS.XtRemoveEventHandler(shell.shellHandle, 0x200000, false, focusProc, this.handle);
            if (this.clientWindow != 0) {
                boolean warnings = this.display.getWarnings();
                this.display.setWarnings(false);
                int xDisplay = OS.XtDisplay(this.handle);
                OS.XUnmapWindow(xDisplay, this.clientWindow);
                OS.XReparentWindow(xDisplay, this.clientWindow, OS.XDefaultRootWindow(xDisplay), 0, 0);
                OS.XSync(xDisplay, false);
                this.display.setWarnings(warnings);
            }
            this.setClientWindow(0);
        }
        super.release(destroy);
    }

    void releaseChildren(boolean destroy) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null && !child.isDisposed()) {
                child.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.embeddedHandle = 0;
        this.focusHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
        if (this.damagedRegion != 0) {
            OS.XDestroyRegion(this.damagedRegion);
        }
        this.damagedRegion = 0;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void reskinChildren(int flags) {
        super.reskinChildren(flags);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null) {
                child.reskin(flags);
            }
            ++i;
        }
    }

    void resizeClientWindow() {
        if (this.clientWindow == 0) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int xDisplay = OS.XtDisplay(this.handle);
        OS.XMoveResizeWindow(xDisplay, this.clientWindow, 0, 0, Math.max(1, argList[1]), Math.max(1, argList[3]));
        this.display.setWarnings(warnings);
    }

    void sendClientEvent(int time, int message, int detail, int data1, int data2) {
        if (this.clientWindow == 0) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int xDisplay = OS.XtDisplay(this.handle);
        XClientMessageEvent xEvent = new XClientMessageEvent();
        xEvent.type = 33;
        xEvent.window = this.clientWindow;
        xEvent.message_type = OS.XInternAtom(xDisplay, _XEMBED, false);
        xEvent.format = 32;
        xEvent.data[0] = time != 0 ? time : OS.XtLastTimestampProcessed(xDisplay);
        xEvent.data[1] = message;
        xEvent.data[2] = detail;
        xEvent.data[3] = data1;
        xEvent.data[4] = data2;
        int event = OS.XtMalloc(96);
        OS.memmove(event, xEvent, 48);
        OS.XSendEvent(xDisplay, this.clientWindow, false, 0, event);
        OS.XSync(xDisplay, false);
        OS.XtFree(event);
        this.display.setWarnings(warnings);
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        if ((this.state & 2) != 0 && (this.style & 0x20040000) != 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            XSetWindowAttributes attributes = new XSetWindowAttributes();
            attributes.background_pixmap = 0;
            OS.XChangeWindowAttributes(xDisplay, xWindow, 1, attributes);
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize) {
            if (this.focusHandle != 0) {
                int[] nArray = new int[4];
                nArray[0] = OS.XmNwidth;
                nArray[2] = OS.XmNheight;
                int[] argList = nArray;
                OS.XtGetValues(this.handle, argList, argList.length / 2);
                OS.XtConfigureWidget(this.focusHandle, 0, 0, argList[1], argList[3], 0);
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
            if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
                this.resizeClientWindow();
            }
        }
        return changed;
    }

    void setClientWindow(int window) {
        if (this.focusHandle != 0 && window == OS.XtWindow(this.focusHandle)) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int xDisplay = OS.XtDisplay(this.handle);
        if (window != 0) {
            if (this.clientWindow == 0) {
                this.clientWindow = window;
                this.sendClientEvent(0, 0, 0, 0, 0);
                OS.XtRegisterDrawable(xDisplay, this.clientWindow, this.handle);
                OS.XSelectInput(xDisplay, this.clientWindow, 0x400000);
                this.updateMapped();
                this.resizeClientWindow();
                Shell shell = this.getShell();
                if (shell == this.display.getActiveShell()) {
                    shell.bringToTop(true);
                    this.sendClientEvent(0, 1, 0, 0, 0);
                    if (this == this.display.getFocusControl()) {
                        this.sendClientEvent(0, 4, 0, 0, 0);
                    }
                }
            }
        } else {
            if (this.clientWindow != 0) {
                OS.XtUnregisterDrawable(xDisplay, this.clientWindow);
            }
            this.clientWindow = 0;
        }
        this.display.setWarnings(warnings);
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.state & 2) != 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            OS.XClearArea(xDisplay, xWindow, 0, 0, 0, 0, true);
        }
    }

    void setForegroundPixel(int pixel) {
        super.setForegroundPixel(pixel);
        if ((this.state & 2) != 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            OS.XClearArea(xDisplay, xWindow, 0, 0, 0, 0, true);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x400) != 0 || (this.state & 0x100) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    void setParentBackground() {
        super.setParentBackground();
        if (this.scrolledHandle != 0) {
            this.setParentBackground(this.scrolledHandle);
        }
        if (this.formHandle != 0) {
            this.setParentBackground(this.formHandle);
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        boolean changed = super.setScrollBarVisible(bar, visible);
        if (changed && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return changed;
    }

    boolean setTabGroupFocus(boolean next) {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus(next);
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
            if ((this.style & 0x1000000) != 0) {
                takeFocus = true;
            }
        }
        if (takeFocus && this.setTabItemFocus(next)) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus(next)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean setTabItemFocus(boolean next) {
        if (!super.setTabItemFocus(next)) {
            return false;
        }
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int detail = next ? 1 : 2;
            this.sendClientEvent(0, 4, detail, 0, 0);
        }
        return true;
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, xEvent);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.translateMnemonic(event, control)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    boolean translateTraversal(int key, XKeyEvent xEvent) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            return false;
        }
        return super.translateTraversal(key, xEvent);
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    void updateLayout(boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x400;
            return;
        }
        if ((this.state & 0x100) != 0) {
            boolean changed = (this.state & 0x200) != 0;
            this.state &= 0xFFFFFCFF;
            this.display.runSkin();
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFFFFBFF;
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(all);
                ++i;
            }
        }
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XButtonPress(w, client_data, call_data, continue_to_dispatch);
        if (result != 0) {
            return result;
        }
        if ((this.state & 2) != 0) {
            XButtonEvent xEvent = new XButtonEvent();
            OS.memmove(xEvent, call_data, 60);
            if ((this.style & 0x80000) == 0 && this.hooksKeys() && xEvent.button == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
            if (xEvent.button != 3) {
                OS.memmove(continue_to_dispatch, new int[1], 4);
            }
            return 1;
        }
        return result;
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        int xDisplay;
        if ((this.state & 2) == 0) {
            return super.XExposure(w, client_data, call_data, continue_to_dispatch);
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        if (this.damagedRegion == 0) {
            this.damagedRegion = OS.XCreateRegion();
        }
        OS.XtAddExposureToRegion(call_data, this.damagedRegion);
        if ((this.style & 0x200000) == 0) {
            XExposeEvent xEvent = new XExposeEvent();
            OS.memmove(xEvent, call_data, 40);
            int exposeCount = xEvent.count;
            if (exposeCount == 0 && OS.XEventsQueued(xEvent.display, 1) != 0) {
                int xEvent1 = OS.XtMalloc(96);
                this.display.lastExpose = 0;
                this.display.exposeCount = 0;
                int checkExposeProc = this.display.checkExposeProc;
                OS.XCheckIfEvent(xEvent.display, xEvent1, checkExposeProc, xEvent.window);
                exposeCount = this.display.exposeCount;
                int lastExpose = this.display.lastExpose;
                if (exposeCount != 0 && lastExpose != 0) {
                    XExposeEvent xExposeEvent = this.display.xExposeEvent;
                    OS.memmove(xExposeEvent, lastExpose, 40);
                    xExposeEvent.count = 0;
                    OS.memmove(lastExpose, xExposeEvent, 40);
                }
                OS.XtFree(xEvent1);
            }
            if (exposeCount != 0) {
                return 0;
            }
        }
        if ((xDisplay = OS.XtDisplay(this.handle)) == 0) {
            return 0;
        }
        int damageRgn = this.damagedRegion;
        this.damagedRegion = 0;
        GCData data = new GCData();
        data.damageRgn = damageRgn;
        GC gc = GC.motif_new(this, data);
        OS.XSetRegion(xDisplay, gc.handle, damageRgn);
        XRectangle rect = new XRectangle();
        OS.XClipBox(damageRgn, rect);
        GC paintGC = null;
        Image image = null;
        if ((this.style & 0x20000000) != 0) {
            Rectangle client = this._getClientArea();
            int width = Math.max(1, Math.min(client.width, rect.x + rect.width));
            int height = Math.max(1, Math.min(client.height, rect.y + rect.height));
            image = new Image((Device)this.display, width, height);
            paintGC = gc;
            GCData imageGCData = new GCData();
            imageGCData.damageRgn = damageRgn;
            gc = GC.motif_new(image, imageGCData);
            gc.setForeground(this.getForeground());
            gc.setBackground(this.getBackground());
            gc.setFont(this.getFont());
            if ((this.style & 0x40000) == 0) {
                this.drawBackground(gc, 0, 0, width, height, 0, 0);
            }
        }
        Event event = new Event();
        event.x = rect.x;
        event.y = rect.y;
        event.width = rect.width;
        event.height = rect.height;
        event.gc = gc;
        this.sendEvent(9, event);
        event.gc = null;
        if ((this.style & 0x20000000) != 0) {
            gc.dispose();
            if (!this.isDisposed()) {
                paintGC.drawImage(image, 0, 0);
            }
            image.dispose();
            gc = paintGC;
        }
        gc.dispose();
        OS.XDestroyRegion(damageRgn);
        return 0;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        int result = super.xFocusIn(xEvent);
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            this.sendClientEvent(0, 4, 0, 0, 0);
        }
        return result;
    }

    int xFocusOut(XFocusChangeEvent xEvent) {
        int result = super.xFocusOut(xEvent);
        if (this.handle != 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            this.sendClientEvent(0, 5, 0, 0, 0);
        }
        return result;
    }

    int XKeyPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XKeyPress(w, client_data, call_data, continue_to_dispatch);
        if (result == 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0 && this.fowardKeyEvent(call_data)) {
            return 0;
        }
        return result;
    }

    int XKeyRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XKeyRelease(w, client_data, call_data, continue_to_dispatch);
        if (result == 0 && (this.state & 2) != 0 && (this.style & 0x1000000) != 0 && this.fowardKeyEvent(call_data)) {
            return 0;
        }
        return result;
    }

    int XNonMaskable(int w, int client_data, int call_data, int continue_to_dispatch) {
        XEvent xEvent;
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            xEvent = new XEvent();
            OS.memmove(xEvent, call_data, 96);
            if (xEvent.type == 33) {
                XClientMessageEvent xClientEvent = new XClientMessageEvent();
                OS.memmove(xClientEvent, call_data, 48);
                int xDisplay = OS.XtDisplay(this.handle);
                if (xClientEvent.message_type == OS.XInternAtom(xDisplay, _XEMBED, false)) {
                    int type = xClientEvent.data[1];
                    switch (type) {
                        case 3: {
                            this.setFocus();
                            break;
                        }
                        case 7: {
                            this.traverse(8);
                            break;
                        }
                        case 6: {
                            this.traverse(16);
                        }
                    }
                }
                return 0;
            }
        }
        if ((this.state & 2) != 0) {
            xEvent = new XEvent();
            OS.memmove(xEvent, call_data, 96);
            if (xEvent.type == 13) {
                return this.XExposure(w, client_data, call_data, continue_to_dispatch);
            }
        }
        return 0;
    }

    int XPropertyChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XPropertyChange(w, client_data, call_data, continue_to_dispatch);
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            int xDisplay;
            int atom;
            XPropertyEvent xPropertyEvent = new XPropertyEvent();
            OS.memmove(xPropertyEvent, call_data, 32);
            if (xPropertyEvent.window == this.clientWindow && (atom = xPropertyEvent.atom) == OS.XInternAtom(xDisplay = xPropertyEvent.display, _XEMBED_INFO, false)) {
                this.updateMapped();
            }
        }
        return result;
    }

    int XStructureNotify(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XStructureNotify(w, client_data, call_data, continue_to_dispatch);
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            XEvent xEvent = new XEvent();
            OS.memmove(xEvent, call_data, 96);
            switch (xEvent.type) {
                case 21: {
                    XReparentEvent xReparentEvent = new XReparentEvent();
                    OS.memmove(xReparentEvent, call_data, 40);
                    if (this.clientWindow != 0) break;
                    this.setClientWindow(xReparentEvent.window);
                    break;
                }
                case 16: {
                    XCreateWindowEvent xCreateEvent = new XCreateWindowEvent();
                    OS.memmove(xCreateEvent, call_data, 48);
                    if (this.clientWindow != 0) break;
                    this.setClientWindow(xCreateEvent.window);
                    break;
                }
                case 17: {
                    XDestroyWindowEvent xDestroyEvent = new XDestroyWindowEvent();
                    OS.memmove(xDestroyEvent, call_data, 24);
                    if (xDestroyEvent.window != this.clientWindow) break;
                    this.setClientWindow(0);
                    break;
                }
                case 22: {
                    XConfigureEvent xConfigureEvent = new XConfigureEvent();
                    OS.memmove(xConfigureEvent, call_data, 52);
                    if (xConfigureEvent.window != this.clientWindow) break;
                    this.resizeClientWindow();
                }
            }
        }
        return result;
    }

    void updateMapped() {
        if (this.clientWindow == 0) {
            return;
        }
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int xDisplay = OS.XtDisplay(this.handle);
        int prop = OS.XInternAtom(xDisplay, _XEMBED_INFO, false);
        int[] type = new int[1];
        int[] format = new int[1];
        int[] nitems = new int[1];
        int[] bytes_after = new int[1];
        int[] data = new int[1];
        if (OS.XGetWindowProperty(xDisplay, this.clientWindow, prop, 0, 2, false, prop, type, format, nitems, bytes_after, data) == 0 && type[0] == prop && nitems[0] >= 2) {
            int[] buffer = new int[2];
            OS.memmove(buffer, data[0], buffer.length * 4);
            int flags = buffer[1];
            if ((flags & 1) != 0) {
                OS.XMapWindow(xDisplay, this.clientWindow);
            } else {
                OS.XUnmapWindow(xDisplay, this.clientWindow);
            }
        }
        if (data[0] != 0) {
            OS.XFree(data[0]);
        }
        this.display.setWarnings(warnings);
    }
}

