/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.QuickFixPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class QuickFixWizard
extends Wizard {
    private Map resolutionMap;
    private String description;
    private IWorkbenchPartSite partSite;

    public QuickFixWizard(String description, Map resolutions, IWorkbenchPartSite site) {
        this.resolutionMap = resolutions;
        this.description = description;
        this.partSite = site;
        this.setDefaultPageImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLGBAN_QUICKFIX_DLG"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new QuickFixPage(this.description, this.resolutionMap, this.partSite));
    }

    public boolean performFinish() {
        IRunnableWithProgress finishRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IWizardPage[] pages = QuickFixWizard.this.getPages();
                monitor.beginTask(MarkerMessages.MarkerResolutionDialog_Fixing, 10 * pages.length + 1);
                monitor.worked(1);
                int i = 0;
                while (i < pages.length) {
                    QuickFixWizard.this.getShell().getDisplay().readAndDispatch();
                    if (monitor.isCanceled()) {
                        return;
                    }
                    QuickFixPage wizardPage = (QuickFixPage)pages[i];
                    wizardPage.performFinish((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, finishRunnable);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e));
            return false;
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e));
            return false;
        }
        return true;
    }
}

