/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.ProjectLocationSelectionDialog;
import org.eclipse.ui.ide.undo.CopyProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CopyProjectAction
extends SelectionListenerAction {
    private static String COPY_TOOL_TIP = IDEWorkbenchMessages.CopyProjectAction_toolTip;
    private static String COPY_TITLE = IDEWorkbenchMessages.CopyProjectAction_title;
    private static String PROBLEMS_TITLE = IDEWorkbenchMessages.CopyProjectAction_copyFailedTitle;
    public static final String ID = "org.eclipse.ui.CopyProjectAction";
    protected Shell shell;
    protected IShellProvider shellProvider;
    protected IStatus errorStatus;
    private String[] modelProviderIds;

    public CopyProjectAction(Shell shell) {
        this(shell, COPY_TITLE);
    }

    public CopyProjectAction(IShellProvider provider) {
        this(provider, COPY_TITLE);
    }

    CopyProjectAction(final Shell shell, String name) {
        super(name);
        Assert.isNotNull((Object)shell);
        this.shellProvider = new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
        this.initAction();
    }

    CopyProjectAction(IShellProvider provider, String name) {
        super(name);
        Assert.isNotNull((Object)provider);
        this.shellProvider = provider;
        this.initAction();
    }

    private void initAction() {
        this.shell = this.shellProvider.getShell();
        this.setToolTipText(COPY_TOOL_TIP);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.copy_project_action_context");
    }

    protected IProjectDescription createDescription(IProject project, String projectName, IPath rootLocation) throws CoreException {
        IProjectDescription newDescription = project.getDescription();
        newDescription.setName(projectName);
        if (rootLocation.equals((Object)Platform.getLocation())) {
            newDescription.setLocation(null);
        } else {
            newDescription.setLocation(rootLocation);
        }
        return newDescription;
    }

    void displayError(String message) {
        MessageDialog.openError((Shell)this.shellProvider.getShell(), (String)this.getErrorsTitle(), (String)message);
    }

    protected String getErrorsTitle() {
        return PROBLEMS_TITLE;
    }

    protected AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
    }

    boolean performCopy(final IProject project, final String projectName, final URI newLocation) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CopyProjectOperation op = new CopyProjectOperation(project, projectName, newLocation, CopyProjectAction.this.getText());
                op.setModelProviderIds(CopyProjectAction.this.getModelProviderIds());
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter(CopyProjectAction.this.shellProvider.getShell()));
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        CopyProjectAction.this.recordError((CoreException)e.getCause());
                    }
                    IDEWorkbenchPlugin.log(e.getMessage(), e);
                    CopyProjectAction.this.displayError(e.getMessage());
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.shellProvider.getShell()).run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayError(NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_internalError, (Object)e.getTargetException().getMessage()));
            return false;
        }
        return true;
    }

    protected Object[] queryDestinationParameters(IProject project) {
        ProjectLocationSelectionDialog dialog = new ProjectLocationSelectionDialog(this.shellProvider.getShell(), project);
        dialog.setTitle(IDEWorkbenchMessages.CopyProjectAction_copyTitle);
        dialog.open();
        return dialog.getResult();
    }

    final void recordError(CoreException error) {
        this.errorStatus = error.getStatus();
    }

    public void run() {
        this.errorStatus = null;
        IProject project = (IProject)this.getSelectedResources().get(0);
        Object[] destinationPaths = this.queryDestinationParameters(project);
        if (destinationPaths == null) {
            return;
        }
        String newName = (String)destinationPaths[0];
        URI newLocation = URIUtil.toURI((String)((String)destinationPaths[1]));
        boolean completed = this.performCopy(project, newName, newLocation);
        if (!completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.shellProvider.getShell(), (String)this.getErrorsTitle(), null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() != 1) {
            return false;
        }
        IResource source = (IResource)selectedResources.get(0);
        return source instanceof IProject && ((IProject)source).isOpen();
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }
}

