/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.workbench.addons.dndaddon.CursorInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SplitDropAgent
extends DropAgent {
    EModelService modelService;

    public SplitDropAgent(EModelService modelService) {
        this.modelService = modelService;
    }

    public boolean canDrop(MUIElement dragElement, CursorInfo info) {
        MPart stackElement;
        if (!(dragElement instanceof MPart)) {
            return false;
        }
        MPart part = (MPart)dragElement;
        Object object = stackElement = part.getCurSharedRef() != null ? part.getCurSharedRef() : part;
        if (info.curElement == part && stackElement.getParent().getWidget() instanceof CTabFolder) {
            CTabFolder ctf = (CTabFolder)stackElement.getParent().getWidget();
            return ctf.getItemCount() > 1;
        }
        if (info.curElement instanceof MStackElement) {
            return true;
        }
        return info.curElement instanceof MPartStack && info.curElement.getTags().contains("EditorStack");
    }

    private int whereToDrop(Control ctrl, Point cursorPos) {
        int dyr;
        int dyl;
        int dy;
        Rectangle bb = ctrl.getBounds();
        Rectangle displayBB = ctrl.getDisplay().map((Control)ctrl.getParent(), null, bb);
        int dxl = cursorPos.x - displayBB.x;
        int dxr = displayBB.x + displayBB.width - cursorPos.x;
        int dx = Math.min(dxl, dxr);
        int where = dx < (dy = Math.min(dyl = cursorPos.y - displayBB.y, dyr = displayBB.y + displayBB.height - cursorPos.y)) ? (dxl < dxr ? 2 : 3) : (dyl < dyr ? 0 : 1);
        return where;
    }

    public boolean drop(MUIElement dragElement, CursorInfo info) {
        MElementContainer relParent;
        MPart part = (MPart)dragElement;
        MPart stackElement = part.getCurSharedRef() != null ? part.getCurSharedRef() : part;
        Object relTo = info.curElement;
        Control ctrl = (Control)relTo.getWidget();
        int where = this.whereToDrop(ctrl, info.cursorPos);
        if (relTo.getCurSharedRef() != null) {
            relTo = relTo.getCurSharedRef();
        }
        if ((relParent = relTo.getParent()) instanceof MPartSashContainer && !part.getTags().contains("Editor")) {
            relTo = this.getEditorArea((MUIElement)relParent);
        }
        if (relParent instanceof MPartStack) {
            relTo = !stackElement.getTags().contains("Editor") && relParent.getTags().contains("EditorStack") ? this.getEditorArea((MUIElement)relParent) : relParent;
        }
        stackElement.getParent().getChildren().remove(stackElement);
        MPart toInsert = stackElement;
        if (dragElement instanceof MStackElement) {
            MPartStack newPS = BasicFactoryImpl.eINSTANCE.createPartStack();
            if (relTo.getTags().contains("EditorStack")) {
                newPS.getTags().add("EditorStack");
                newPS.getTags().add("org.eclipse.e4.primaryDataStack");
            }
            newPS.getChildren().add(stackElement);
            newPS.setSelectedElement((MUIElement)stackElement);
            toInsert = newPS;
        }
        this.modelService.insert((MPartSashContainerElement)toInsert, (MPartSashContainerElement)relTo, where, 50);
        return true;
    }

    private MUIElement getEditorArea(MUIElement relParent) {
        while (relParent != null && relParent.getCurSharedRef() == null) {
            relParent = relParent.getParent();
        }
        return relParent != null ? relParent.getCurSharedRef() : null;
    }

    public Cursor getCursor(Display display, MUIElement dragElement, CursorInfo info) {
        Control ctrl = (Control)info.curElement.getWidget();
        int where = this.whereToDrop(ctrl, info.cursorPos);
        if (where == 0) {
            return display.getSystemCursor(10);
        }
        if (where == 1) {
            return display.getSystemCursor(11);
        }
        if (where == 2) {
            return display.getSystemCursor(13);
        }
        if (where == 3) {
            return display.getSystemCursor(12);
        }
        return display.getSystemCursor(4);
    }

    public Rectangle getRectangle(MUIElement dragElement, CursorInfo info) {
        Control ctrl = (Control)info.curElement.getWidget();
        if (ctrl.getParent() instanceof CTabFolder) {
            ctrl = ctrl.getParent();
        }
        if (ctrl.getParent() != null && ctrl.getParent().getParent() instanceof CTabFolder) {
            ctrl = ctrl.getParent().getParent();
        }
        Rectangle bounds = ctrl.getBounds();
        int where = this.whereToDrop(ctrl, info.cursorPos);
        if (where == 0) {
            bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height / 2);
        }
        if (where == 1) {
            bounds = new Rectangle(bounds.x, bounds.y + bounds.height / 2, bounds.width, bounds.height / 2);
        }
        if (where == 2) {
            bounds = new Rectangle(bounds.x, bounds.y, bounds.width / 2, bounds.height);
        }
        if (where == 3) {
            bounds = new Rectangle(bounds.x + bounds.width / 2, bounds.y, bounds.width / 2, bounds.height);
        }
        return ctrl.getDisplay().map((Control)ctrl.getParent(), null, bounds);
    }
}

