/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.xml;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;
import org.eclipse.platform.discovery.util.api.xml.IXmlRepresentable;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.xml.ICollectionTransformer;
import org.eclipse.platform.discovery.util.internal.xml.Messages;

public class CollectionTransformer
implements ICollectionTransformer {
    private String collectionTag;
    private String itemTag;
    private String namespace;

    @Override
    public String transform(final Iterator<?> i, ILongOperationRunner lor) {
        try {
            final Property progressMonitorStarted = new Property();
            return lor.run(new ILongOperation<String>(){

                @Override
                public String run(IProgressMonitor monitor) throws LongOpCanceledException, Exception {
                    try {
                        progressMonitorStarted.set(false);
                        StringBuilder b = new StringBuilder();
                        b.append('<');
                        b.append(CollectionTransformer.this.collectionTag);
                        b.append(" xmlns=\"");
                        b.append(CollectionTransformer.this.namespace);
                        b.append("\">");
                        while (i.hasNext()) {
                            b.append('<');
                            b.append(CollectionTransformer.this.itemTag);
                            b.append('>');
                            b.append(CollectionTransformer.this.adapt(i.next(), (IProgressMonitor)new TransformerSubProgressMonitor(monitor, 0, progressMonitorStarted)));
                            b.append("</");
                            b.append(CollectionTransformer.this.itemTag);
                            b.append('>');
                        }
                        b.append("</");
                        b.append(CollectionTransformer.this.collectionTag);
                        b.append('>');
                        String string = b.toString();
                        return string;
                    }
                    finally {
                        if (((Boolean)progressMonitorStarted.get()).booleanValue()) {
                            monitor.done();
                        }
                    }
                }
            });
        }
        catch (LongOpCanceledException loce) {
            throw new RuntimeException(loce);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    private String adapt(Object o, IProgressMonitor pm) {
        if (o instanceof IXmlRepresentable) {
            return ((IXmlRepresentable)o).toStringXml(pm);
        }
        IXmlRepresentable xml = (IXmlRepresentable)this.adapterFor(o, IXmlRepresentable.class);
        if (xml == null) {
            return o.toString();
        }
        return xml.toStringXml(pm);
    }

    private Object adapterFor(Object object, Class<?> targetClass) {
        Object cachedAdapter = this.getAdapterManager().getAdapter(object, targetClass);
        return cachedAdapter == null ? this.getAdapterManager().loadAdapter(object, targetClass.getName()) : cachedAdapter;
    }

    protected IAdapterManager getAdapterManager() {
        return Platform.getAdapterManager();
    }

    @Override
    public void setCollectionTag(String s) {
        this.collectionTag = s;
    }

    @Override
    public void setItemTag(String s) {
        this.itemTag = s;
    }

    @Override
    public void setNamespace(String s) {
        this.namespace = s;
    }

    private class TransformerSubProgressMonitor
    extends SubProgressMonitor {
        private final IProgressMonitor parentMonitor;
        private final Property<Boolean> progressMonitorStarted;

        public TransformerSubProgressMonitor(IProgressMonitor monitor, int ticks, Property<Boolean> progressMonitorStarted) {
            super(monitor, ticks);
            this.parentMonitor = monitor;
            this.progressMonitorStarted = progressMonitorStarted;
        }

        public void beginTask(String name, int totalWork) {
            if (!this.progressMonitorStarted.get().booleanValue()) {
                this.progressMonitorStarted.set(true);
                this.parentMonitor.beginTask(Messages.CollectionTransformer_TRANSFORMING_TO_XML, -1);
            }
            super.beginTask(name, totalWork);
        }
    }
}

