/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeKeeper
implements DisposeListener {
    private static final long serialVersionUID = 1L;
    protected HashMap<String, Object> nameMap = new HashMap();
    protected HashMap<Widget, HashMap<Object, HashMap<String, IObservable>>> bindingData = new HashMap();
    protected Widget host;
    private final ScopeKeeper parent;
    private ChangeListenerSupport changeListenerSupport = new ChangeListenerSupport();

    public ScopeKeeper(ScopeKeeper parent, Widget host) {
        this.parent = parent;
        host.addDisposeListener((DisposeListener)this);
        this.host = host;
    }

    public void widgetDisposed(DisposeEvent e) {
        HashMap<Object, HashMap<String, IObservable>> hashMap2;
        Widget source = e.widget;
        if (source == this.host) {
            for (HashMap<Object, HashMap<String, IObservable>> hashMap2 : this.bindingData.values()) {
                for (HashMap<String, IObservable> map : hashMap2.values()) {
                    for (IObservable observable : map.values()) {
                        observable.removeChangeListener((IChangeListener)this.changeListenerSupport);
                    }
                }
            }
            this.changeListenerSupport.dispose();
        }
        if ((hashMap2 = this.bindingData.get(source)) != null) {
            for (HashMap<String, IObservable> map : hashMap2.values()) {
                for (IObservable observable : map.values()) {
                    observable.removeChangeListener((IChangeListener)this.changeListenerSupport);
                }
            }
            this.bindingData.remove(source);
        }
    }

    public void addNamedObject(String name, Object object) {
        this.nameMap.put(name, object);
    }

    public Widget getHost() {
        return this.host;
    }

    public Object getNamedObject(String name) {
        Object object = this.nameMap.get(name);
        if (object != null) {
            return object;
        }
        return this.parent == null ? null : this.parent.getNamedObject(name);
    }

    public Collection<String> names() {
        return this.nameMap.keySet();
    }

    public boolean containsName(String name) {
        if (this.nameMap.containsKey(name)) {
            return true;
        }
        return this.parent == null ? false : this.parent.containsName(name);
    }

    public boolean addChangeListener(IChangeListener listener) {
        return this.changeListenerSupport.addChangeListener(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.changeListenerSupport.removeChangeListener(listener);
    }

    public void fireChangeListener(ChangeEvent event) {
        this.changeListenerSupport.handleChange(event);
    }

    void addObservableValue(Widget widget, Object data, String property, IObservable value) {
        HashMap<String, Object> objectData;
        if (widget == null) {
            widget = this.host;
        } else {
            widget.addDisposeListener((DisposeListener)this);
        }
        HashMap<Object, HashMap<String, Object>> widgetData = this.bindingData.get(widget);
        if (widgetData == null) {
            widgetData = new HashMap();
            this.bindingData.put(widget, widgetData);
        }
        if ((objectData = widgetData.get(data)) == null) {
            objectData = new HashMap();
            widgetData.put(data, objectData);
        }
        if (objectData.containsKey(property)) {
            throw new IllegalStateException();
        }
        objectData.put(property, value);
        value.addChangeListener((IChangeListener)this.changeListenerSupport);
    }

    IObservableValue getObservableValue(Widget control, Object data, String property) {
        IObservable observable = this.getObservable(control, data, property);
        if (observable instanceof IObservableValue) {
            return (IObservableValue)observable;
        }
        return null;
    }

    IObservableList getObservableList(Widget control, Object data, String property) {
        IObservable observable = this.getObservable(control, data, property);
        if (observable instanceof IObservableList) {
            return (IObservableList)observable;
        }
        return null;
    }

    IObservableSet getObservableSet(Widget control, Object data, String property) {
        IObservable observable = this.getObservable(control, data, property);
        if (observable instanceof IObservableSet) {
            return (IObservableSet)observable;
        }
        return null;
    }

    IObservable localGetObservable(Widget control, Object data, String property) {
        for (HashMap<Object, HashMap<String, IObservable>> widgetData : this.bindingData.values()) {
            IObservable observable;
            HashMap<String, IObservable> objectData;
            if (widgetData == null || (objectData = widgetData.get(data)) == null || (observable = objectData.get(property)) == null) continue;
            return observable;
        }
        return null;
    }

    IObservable getObservable(Widget control, Object data, String property) {
        IObservable observable = this.localGetObservable(control, data, property);
        if (observable != null) {
            return observable;
        }
        Widget rootWidget = UserData.findRootWidget(control);
        observable = ScopeKeeper.deepFindObservable(rootWidget, data, property);
        if (observable != null) {
            this.addObservableValue(control, data, property, observable);
        }
        return observable;
    }

    static IObservable deepFindObservable(Widget control, Object data, String property) {
        IObservable observable;
        ScopeKeeper scopeKeeper = UserData.getLocalScopeKeeper(control);
        if (scopeKeeper != null && (observable = scopeKeeper.localGetObservable(control, data, property)) != null) {
            return observable;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                IObservable observable2 = ScopeKeeper.deepFindObservable((Widget)child, data, property);
                if (observable2 != null) {
                    return observable2;
                }
                ++n2;
            }
        }
        return null;
    }

    class ChangeListenerSupport
    implements IChangeListener {
        private List<IChangeListener> changeListeners = Collections.EMPTY_LIST;

        ChangeListenerSupport() {
        }

        public void handleChange(ChangeEvent event) {
            for (IChangeListener changeListener : this.changeListeners) {
                changeListener.handleChange(event);
            }
            Widget parent = UserData.getTreeParent(ScopeKeeper.this.host);
            ScopeKeeper scopeKeeper = UserData.findScopeKeeper(parent);
            if (scopeKeeper != null) {
                scopeKeeper.fireChangeListener(event);
            }
        }

        public boolean addChangeListener(IChangeListener listener) {
            if (this.changeListeners.contains(listener)) {
                return false;
            }
            if (this.changeListeners == Collections.EMPTY_LIST) {
                this.changeListeners = new ArrayList<IChangeListener>();
            }
            this.changeListeners.add(listener);
            return true;
        }

        public void removeChangeListener(IChangeListener listener) {
            this.changeListeners.remove(listener);
        }

        public void dispose() {
            this.changeListeners = null;
        }
    }
}

