/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.emf;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableValue;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.dataproviders.AbstractDataProvider;
import org.eclipse.e4.xwt.emf.EMFBinding;
import org.eclipse.e4.xwt.emf.EMFDataModelService;
import org.eclipse.e4.xwt.emf.EMFHelper;
import org.eclipse.e4.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EMFDataProvider
extends AbstractDataProvider {
    private IDataProvider.DataModelService dataModelService;
    private URI typeURI;
    private URI objectURI;
    private ResourceSet resourceSet;
    private String featureName;
    private Object objectInstance;

    public EMFDataProvider(IDataProvider.DataModelService dataModelService) {
        this.dataModelService = dataModelService;
    }

    public EMFDataProvider() {
    }

    protected IObservableValue observeDetailValue(IObservableValue bean, Object ownerType, String propertyName, Object propertyType) {
        EStructuralFeature feature;
        EClass type = null;
        if (ownerType instanceof EClass) {
            type = (EClass)ownerType;
        }
        if (type == null) {
            type = (EClass)this.getModelService().toModelType((Object)bean);
        }
        if ((feature = type.getEStructuralFeature(propertyName)) == null) {
            throw new XWTException(String.valueOf(propertyName) + " feature is not found in " + EMFHelper.getQualifiedName((ENamedElement)type));
        }
        return EMFObservables.observeDetailValue((Realm)bean.getRealm(), (IObservableValue)bean, (EStructuralFeature)feature);
    }

    protected IObservableValue observeValue(Object bean, String propertyName) {
        EClass type = (EClass)this.getModelService().toModelType(bean);
        EStructuralFeature feature = type.getEStructuralFeature(propertyName);
        if (feature == null) {
            throw new XWTException(String.valueOf(propertyName) + " feature is not found in " + EMFHelper.getQualifiedName((ENamedElement)type));
        }
        return EMFObservables.observeValue((Realm)XWT.getRealm(), (EObject)((EObject)bean), (EStructuralFeature)feature);
    }

    public IValueProperty observeValueProperty(Object valueType, String path, UpdateSourceTrigger updateSourceTrigger) {
        EClass type = null;
        if (valueType instanceof EClass) {
            type = (EClass)valueType;
        } else if (valueType instanceof EObject) {
            EObject object = (EObject)valueType;
            type = object.eClass();
        } else {
            throw new IllegalStateException();
        }
        EStructuralFeature feature = type.getEStructuralFeature(path);
        if (feature == null) {
            throw new XWTException(String.valueOf(path) + " feature is not found in " + EMFHelper.getQualifiedName((ENamedElement)type));
        }
        return EMFProperties.value((EStructuralFeature)feature);
    }

    public URI getObjectURI() {
        return this.objectURI;
    }

    public void setObjectURI(URI objectURI) {
        this.objectURI = objectURI;
    }

    public URI getTypeURI() {
        return this.typeURI;
    }

    public void setTypeURI(URI typeURI) {
        this.typeURI = typeURI;
    }

    public Object getObjectInstance() {
        if (this.objectInstance == null) {
            if (this.objectURI != null) {
                this.objectInstance = this.getResourceSet().getEObject(this.objectURI, true);
            } else if (this.typeURI != null) {
                EClass eClass = (EClass)this.getResourceSet().getEObject(this.typeURI, true);
                this.objectInstance = eClass.getEPackage().getEFactoryInstance().create(eClass);
            }
        }
        return this.objectInstance;
    }

    protected ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    protected void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void setObjectInstance(Object eObject) {
        this.objectInstance = eObject;
    }

    public Object getTarget() {
        Object instance = this.getObjectInstance();
        if (instance instanceof EObject) {
            EObject eObj = (EObject)instance;
            if (eObj != null && this.featureName != null) {
                return EMFBinding.getEObject(eObj, this.featureName);
            }
            return eObj;
        }
        return instance;
    }

    public Object getData(String path) {
        Object instance = this.getTarget();
        if (!(instance instanceof EObject)) {
            if (path == null || path.length() == 0 || path.equals(".")) {
                return instance;
            }
            throw new IllegalStateException();
        }
        EObject eObj = (EObject)instance;
        if (path == null || ".".equals(path)) {
            return eObj;
        }
        if (eObj != null) {
            EStructuralFeature feature;
            String featureName = path;
            int index = path.lastIndexOf(".");
            if (index != -1) {
                String parent = path.substring(0, index);
                eObj = (EObject)this.getData(eObj, parent);
                featureName = path.substring(index + 1);
            }
            if ((feature = eObj.eClass().getEStructuralFeature(featureName)) != null) {
                return eObj.eGet(feature);
            }
        }
        return null;
    }

    public boolean isPropertyReadOnly(String path) {
        EStructuralFeature feature;
        EClass classifier = this.getCurrentType();
        if (classifier != null && path != null && (feature = classifier.getEStructuralFeature(path)) != null) {
            return !feature.isChangeable();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EClass getCurrentType() {
        EObject element;
        Object instance = this.getTarget();
        EClass eObj = null;
        if (instance instanceof EObjectObservableValue) {
            EObjectObservableValue observableValue = (EObjectObservableValue)instance;
            EStructuralFeature valueType = (EStructuralFeature)observableValue.getValueType();
            EClassifier classifier = valueType.getEType();
            if (!(classifier instanceof EClass)) return null;
            eObj = (EClass)classifier;
        } else if (instance instanceof EClass) {
            eObj = (EClass)instance;
        } else if (instance instanceof EObject) {
            EObject object = (EObject)instance;
            eObj = object.eClass();
        } else if (instance instanceof DetailObservableValue) {
            EObject eObject = (EObject)((DetailObservableValue)instance).getValueType();
            eObj = eObject.eClass();
        } else if (this.typeURI != null && (element = this.getResourceSet().getEObject(this.typeURI, true)) instanceof EClass) {
            eObj = (EClass)element;
        }
        if (eObj != null) return eObj;
        throw new IllegalStateException();
    }

    public EClassifier getDataType(String path) {
        String featureName;
        EStructuralFeature feature;
        EClass classifier = this.getCurrentType();
        if (path == null || path.trim().length() == 0 || path.equals(".")) {
            return classifier;
        }
        if (classifier != null && (feature = classifier.getEStructuralFeature(featureName = path)) != null) {
            return feature.getEType();
        }
        return classifier;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Object getData(Object target, String path) {
        if (target instanceof EObject) {
            if (path == null || ".".equals(path)) {
                return target;
            }
            return EMFBinding.getEObject((EObject)target, path);
        }
        return null;
    }

    public void setData(String path, Object value) {
        this.setData(this.getTarget(), path, value);
    }

    public void setData(Object target, String path, Object value) {
        if (target instanceof EObject) {
            EStructuralFeature feature;
            EObject eObj = (EObject)target;
            String featureName = path;
            int index = path.lastIndexOf(".");
            if (index != -1) {
                String parent = path.substring(0, index);
                eObj = EMFBinding.getEObject(eObj, parent);
                featureName = path.substring(index + 1);
            }
            if ((feature = eObj.eClass().getEStructuralFeature(featureName)) != null) {
                eObj.eSet(feature, value);
            }
        }
    }

    protected IDataProvider.DataModelService createDataModelService() {
        return new EMFDataModelService();
    }

    public IDataProvider.DataModelService getModelService() {
        if (this.dataModelService == null) {
            this.dataModelService = this.createDataModelService();
        }
        return this.dataModelService;
    }

    public IValueProperty createValueProperty(Object type, String fullPath) {
        if (type == null || fullPath == null) {
            return null;
        }
        EClass eClass = null;
        if (type instanceof EClass) {
            eClass = (EClass)type;
        } else if (type instanceof EObject) {
            eClass = ((EObject)type).eClass();
        }
        if (eClass == null) {
            return null;
        }
        EStructuralFeature feature = eClass.getEStructuralFeature(fullPath);
        if (feature != null) {
            return EMFProperties.value((EStructuralFeature)feature);
        }
        return null;
    }
}

