/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PInputManager;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.activities.Timer;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PNodeFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class PRoot
extends PNode {
    public static final String PROPERTY_INPUT_SOURCES = "inputSources";
    public static final int PROPERTY_CODE_INPUT_SOURCES = 16384;
    protected transient boolean processingInputs;
    protected transient boolean processInputsScheduled;
    private PInputManager defaultInputManager;
    private transient List inputSources;
    private transient long globalTime;
    private PActivityScheduler activityScheduler;
    private Display display;

    public PRoot(Display display) {
        this.display = display;
        this.inputSources = new ArrayList();
        this.globalTime = System.currentTimeMillis();
        this.activityScheduler = new PActivityScheduler(this);
    }

    public Display getDisplay() {
        return this.display;
    }

    public boolean addActivity(PActivity activity) {
        this.getActivityScheduler().addActivity(activity);
        return true;
    }

    public PActivityScheduler getActivityScheduler() {
        return this.activityScheduler;
    }

    public void waitForActivities() {
        PNodeFilter cameraWithCanvas = new PNodeFilter(){

            public boolean accept(PNode aNode) {
                return aNode instanceof PCamera && ((PCamera)aNode).getComponent() != null;
            }

            public boolean acceptChildrenOf(PNode aNode) {
                return true;
            }
        };
        while (this.activityScheduler.getActivitiesReference().size() > 0) {
            this.processInputs();
            for (PCamera each : this.getAllNodes(cameraWithCanvas, null)) {
                each.getComponent().paintImmediately();
            }
        }
    }

    public PRoot getRoot() {
        return this;
    }

    public PInputManager getDefaultInputManager() {
        if (this.defaultInputManager == null) {
            this.defaultInputManager = new PInputManager();
            this.addInputSource(this.defaultInputManager);
        }
        return this.defaultInputManager;
    }

    public void addInputSource(InputSource inputSource) {
        this.inputSources.add(inputSource);
        this.firePropertyChange(16384, PROPERTY_INPUT_SOURCES, null, this.inputSources);
    }

    public void removeInputSource(InputSource inputSource) {
        this.inputSources.remove(inputSource);
        this.firePropertyChange(16384, PROPERTY_INPUT_SOURCES, null, this.inputSources);
    }

    public Timer createTimer(int delay, Runnable runnable) {
        return new Timer(this.getDisplay(), delay, runnable);
    }

    public long getGlobalTime() {
        return this.globalTime;
    }

    public void processInputs() {
        PDebug.startProcessingInput();
        this.processingInputs = true;
        this.globalTime = System.currentTimeMillis();
        int count = this.inputSources == null ? 0 : this.inputSources.size();
        int i = 0;
        while (i < count) {
            InputSource each = (InputSource)this.inputSources.get(i);
            each.processInput();
            ++i;
        }
        this.activityScheduler.processActivities(this.globalTime);
        this.validateFullBounds();
        this.validateFullPaint();
        this.processingInputs = false;
        PDebug.endProcessingInput();
    }

    public void setFullBoundsInvalid(boolean fullLayoutInvalid) {
        super.setFullBoundsInvalid(fullLayoutInvalid);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setChildBoundsInvalid(boolean childLayoutInvalid) {
        super.setChildBoundsInvalid(childLayoutInvalid);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setPaintInvalid(boolean paintInvalid) {
        super.setPaintInvalid(paintInvalid);
        this.scheduleProcessInputsIfNeeded();
    }

    public void setChildPaintInvalid(boolean childPaintInvalid) {
        super.setChildPaintInvalid(childPaintInvalid);
        this.scheduleProcessInputsIfNeeded();
    }

    public void scheduleProcessInputsIfNeeded() {
        if (PRoot.isEventThread(this.display)) {
            return;
        }
        PDebug.scheduleProcessInputs(this.display);
        if (!this.processInputsScheduled && !this.processingInputs && (this.getFullBoundsInvalid() || this.getChildBoundsInvalid() || this.getPaintInvalid() || this.getChildPaintInvalid())) {
            this.processInputsScheduled = true;
            this.display.asyncExec(new Runnable(){

                public void run() {
                    PRoot.this.processInputs();
                    PRoot.this.processInputsScheduled = false;
                }
            });
        }
    }

    public static boolean isEventThread(Display display) {
        return Thread.currentThread().equals(display.getThread());
    }

    public static interface InputSource {
        public void processInput();
    }
}

