/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.tm.builder.AbstractBuilder;
import org.eclipse.e4.tm.builder.IClassResolver;
import org.eclipse.e4.tm.stringconverter.AbstractStringConverter;
import org.eclipse.e4.tm.stringconverter.StringConverterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassStringConverter
extends AbstractStringConverter
implements IClassResolver {
    private final String arrayTypeSuffix = "[]";
    protected Map<String, Class<?>> resolvedClasses = new HashMap();
    private List<String> imports = new ArrayList<String>();
    private StringBuilder qualifiedName = new StringBuilder();

    public AbstractClassStringConverter() {
        this.trim = true;
    }

    @Override
    public Object convert(String source, StringConverterContext stringConverterContext) {
        Object c;
        Class klass;
        boolean isArray = source.endsWith("[]");
        if (isArray) {
            source = source.substring(0, source.length() - "[]".length());
        }
        if ((klass = stringConverterContext.resolve(source)) != null && isArray) {
            klass = Array.newInstance(klass, 0).getClass();
        }
        if (klass == null && Character.isLowerCase(source.charAt(0)) && (c = this.convert(AbstractBuilder.casify(source, Boolean.TRUE), stringConverterContext)) instanceof Class) {
            klass = (Class)c;
        }
        return klass;
    }

    public void importPackage(String packageName) {
        if (packageName.charAt(packageName.length() - 1) != '.') {
            packageName = String.valueOf(packageName) + ".";
        }
        this.imports.add(packageName);
    }

    protected abstract Class<?> loadClass(String var1) throws Exception;

    @Override
    public Class<?> resolve(String className) {
        Class<?> result = this.resolvedClasses.get(className);
        if (result != null) {
            return result;
        }
        result = this.resolveLoading(className);
        if (result != null) {
            this.resolvedClasses.put(className, result);
        }
        return result;
    }

    protected Class<?> resolveLoading(String className) {
        Class<?> result = null;
        if (className.indexOf(46) > 0) {
            try {
                result = this.loadClass(className);
            }
            catch (Exception exception) {}
        }
        if (result == null) {
            for (String prefix : this.imports) {
                this.qualifiedName.setLength(0);
                this.qualifiedName.append(prefix);
                this.qualifiedName.append(className);
                try {
                    result = this.loadClass(this.qualifiedName.toString());
                    break;
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }
}

