/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.DirigibleBridge;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.eclipse.dirigible.ide.bridge.InitParametersInjector;
import org.eclipse.dirigible.ide.bridge.MailSenderProvided;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailInjector
implements IInjector {
    static final String DEFAULT_MAIL_SESSION = "MailSession";
    static final String PROVIDED_MAIL_SESSION = "MailSessionProvided";
    private static final Logger logger = LoggerFactory.getLogger((String)MailInjector.class.getCanonicalName());

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        MailSenderProvided mailSenderProvided;
        Session session = (Session)System.getProperties().get(DEFAULT_MAIL_SESSION);
        if (session == null) {
            try {
                session = this.lookupMailSession();
                if (session != null) {
                    req.setAttribute(DEFAULT_MAIL_SESSION, (Object)session);
                    System.getProperties().put(DEFAULT_MAIL_SESSION, session);
                } else {
                    logger.warn("jndiMailService not present");
                }
            }
            catch (Exception e) {
                logger.error(DirigibleBridge.class.getCanonicalName(), (Throwable)e);
            }
        }
        if ((mailSenderProvided = (MailSenderProvided)System.getProperties().get(PROVIDED_MAIL_SESSION)) == null) {
            mailSenderProvided = new MailSenderProvided(session);
            req.setAttribute(PROVIDED_MAIL_SESSION, (Object)mailSenderProvided);
            System.getProperties().put(PROVIDED_MAIL_SESSION, mailSenderProvided);
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
        MailSenderProvided mailSenderProvided;
        Session session = (Session)System.getProperties().get(DEFAULT_MAIL_SESSION);
        if (session == null) {
            try {
                session = this.lookupMailSession();
                if (session != null) {
                    System.getProperties().put(DEFAULT_MAIL_SESSION, session);
                } else {
                    logger.warn("jndiMailService not present");
                }
            }
            catch (Exception e) {
                logger.error(DirigibleBridge.class.getCanonicalName(), (Throwable)e);
            }
        }
        if ((mailSenderProvided = (MailSenderProvided)System.getProperties().get(PROVIDED_MAIL_SESSION)) == null) {
            mailSenderProvided = new MailSenderProvided(session);
            System.getProperties().put(PROVIDED_MAIL_SESSION, mailSenderProvided);
        }
    }

    private Session lookupMailSession() throws NamingException {
        InitialContext ctx = new InitialContext();
        String key = InitParametersInjector.get("jndiMailService");
        if (key != null) {
            return (Session)ctx.lookup(key);
        }
        return null;
    }
}

