/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class AnonymousUserServlet
extends HttpServlet {
    private static final String INVALID_USER_NAME_S = "Invalid user name: %s";
    private static final String USER_PARAM = "user";
    private static final String INVALID_COOKIE = "Invalid cookie.";
    private static final String USE_ANONYMOUS_USER_XXX = "Use .../anonymous?user=xxx";
    private static final String SLASH = "/";
    private static final String REDIRECT_REGISTRY = "web/registry/index.html";
    private static final String REDIRECT_IDE = "index.html?perspective=workspace&git=";
    private static final String GIT_PARAM = "git";
    private static final String REDIRECT_PARAM = "redirect";
    private static final long serialVersionUID = 3669759124907091014L;
    private static final Logger logger = Logger.getLogger(AnonymousUserServlet.class);
    private static final String REGEX_USER_NAME = "[A-Za-z0-9_]{3,64}";
    private static final Pattern PATTERN_USER_NAME = Pattern.compile("[A-Za-z0-9_]{3,64}");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cookieValue = null;
        String userName = req.getParameter(USER_PARAM);
        userName = StringEscapeUtils.escapeHtml((String)userName);
        if ((userName = StringEscapeUtils.escapeJavaScript((String)userName)) != null && !userName.isEmpty()) {
            Matcher userNameMatcher = PATTERN_USER_NAME.matcher(userName = userName.trim());
            if (!userNameMatcher.matches()) {
                logger.error(String.format("The provided username <%s> is invalid. It must match: %s", userName, REGEX_USER_NAME));
                resp.sendError(400, String.format(INVALID_USER_NAME_S, userName));
                return;
            }
            this.setCookieUser(resp, userName);
            cookieValue = userName;
        } else {
            Cookie[] cookies = req.getCookies();
            String cookieName = "dirigible_anonymous_user";
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookieName.equals(cookie.getName())) {
                    cookieValue = cookie.getValue();
                    break;
                }
                ++n2;
            }
            if (cookieValue == null) {
                logger.error("User has not been provided neither as cookie nor as parameter");
                resp.sendError(400, USE_ANONYMOUS_USER_XXX);
                return;
            }
            Matcher cookieUserNameMatcher = PATTERN_USER_NAME.matcher(cookieValue);
            if (!cookieUserNameMatcher.matches()) {
                logger.error("Invalid user name was provided as cookie: " + cookieValue);
                resp.sendError(400, INVALID_COOKIE);
                return;
            }
        }
        String redirect = req.getParameter(REDIRECT_PARAM);
        if (redirect != null && !"".equals(redirect.trim())) {
            String git = req.getParameter(GIT_PARAM);
            if (git != null && !"".equals(git.trim())) {
                git = StringEscapeUtils.escapeHtml((String)git);
                git = StringEscapeUtils.escapeJavaScript((String)git);
                resp.sendRedirect(REDIRECT_IDE + git);
            } else {
                resp.sendRedirect(REDIRECT_REGISTRY);
            }
        } else {
            cookieValue = StringEscapeUtils.escapeHtml((String)cookieValue);
            cookieValue = StringEscapeUtils.escapeJavaScript((String)cookieValue);
            resp.getWriter().println(cookieValue);
            resp.getWriter().flush();
            resp.getWriter().close();
        }
    }

    private void setCookieUser(HttpServletResponse resp, String userName) {
        Cookie cookie = new Cookie("dirigible_anonymous_user", userName);
        cookie.setMaxAge(2592000);
        cookie.setPath(SLASH);
        resp.addCookie(cookie);
    }
}

