/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.utils;

import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.runtime.chrome.debugger.DebugConfiguration;

public class URIUtils {
    public static String getResourceTypeFromContentType(String contentType) {
        String type = contentType.toLowerCase();
        if (type.startsWith("image")) {
            return "Image";
        }
        if (type.startsWith("font")) {
            return "Font";
        }
        if (type.contains("javascript")) {
            return "Script";
        }
        if (type.contains("css")) {
            return "Stylesheet";
        }
        if (type.contains("html")) {
            return "Document";
        }
        return null;
    }

    public static String getURIextension(String url) {
        int dotIndex = url.lastIndexOf(46);
        if (dotIndex < 0) {
            return "";
        }
        return url.substring(dotIndex + 1);
    }

    public static String getUrlForResource(IResource firstProjectFirstResource) {
        String scriptingServices;
        String path = firstProjectFirstResource.getPath();
        int registryServicesIndex = path.indexOf(scriptingServices = "/public/ScriptingServices/");
        if (registryServicesIndex < 0) {
            return "";
        }
        String resourcePath = path.substring(registryServicesIndex + scriptingServices.length() - 1, path.length());
        return String.valueOf(DebugConfiguration.getBaseSourceUrl()) + resourcePath;
    }
}

