/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.processing;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.chrome.debugger.DebugConfiguration;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.DebuggerPausedRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Variable;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.DebuggingService;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.URIUtils;

public class ScriptRepository {
    private static final Logger LOGGER = Logger.getLogger((String)DebuggingService.class.getCanonicalName());
    private static ScriptRepository INSTACE = new ScriptRepository();
    private static Map<String, String> mappedBps = new HashMap<String, String>();
    private static Integer scriptId = 1024;
    private static Map<String, String> scriptSources = new HashMap<String, String>();
    private static List<DebuggerPausedRequest.CallFrame> frames = new ArrayList<DebuggerPausedRequest.CallFrame>();

    private ScriptRepository() {
    }

    public static synchronized ScriptRepository getInstance() {
        return INSTACE;
    }

    public String addScript(String url) {
        try {
            scriptId = scriptId + 1;
            String nextId = String.valueOf(scriptId);
            this.addScript(url, nextId);
            return nextId;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not add script with url %s to repository!", url), (Throwable)e);
            return String.valueOf(-1);
        }
    }

    public void update(String scriptId, String source) {
        scriptSources.put(scriptId, source);
    }

    private void addScript(String url, String scriptId) throws IOException {
        mappedBps.put(url, String.valueOf(scriptId));
        String scriptSource = "";
        Map<String, List<IResource>> resources = DebugConfiguration.getResources();
        for (Map.Entry<String, List<IResource>> e : resources.entrySet()) {
            for (IResource res : e.getValue()) {
                if (!url.equals(URIUtils.getUrlForResource(res))) continue;
                scriptSource = new String(res.getContent(), StandardCharsets.UTF_8);
            }
        }
        scriptSources.put(String.valueOf(scriptId), scriptSource);
    }

    public String getScriptIdByURL(String url) {
        return mappedBps.get(url);
    }

    public String getUrl(String scriptId) {
        for (Map.Entry<String, String> e : mappedBps.entrySet()) {
            String eScriptId = e.getValue();
            if (!eScriptId.equals(scriptId)) continue;
            return e.getKey();
        }
        return null;
    }

    public String getSourceFor(String scriptId) {
        return scriptSources.get(scriptId);
    }

    public void addFrame(DebuggerPausedRequest.CallFrame frame) {
        frames.add(frame);
    }

    public DebuggerPausedRequest.CallFrame getFrameById(String callFrameId) {
        for (DebuggerPausedRequest.CallFrame frame : frames) {
            if (!frame.getCallFrameId().equalsIgnoreCase(callFrameId)) continue;
            return frame;
        }
        return null;
    }

    public Variable.Value getVariableValueByName(String variableName) {
        for (DebuggerPausedRequest.CallFrame frame : frames) {
            List<DebuggerPausedRequest.Scope> scopeChain = frame.getScopeChain();
            for (DebuggerPausedRequest.Scope scope : scopeChain) {
                scope.getObject().get("objectId");
                ArrayList variables = new ArrayList();
                for (Variable var : variables) {
                    if (!var.getName().equalsIgnoreCase(variableName)) continue;
                    return var.getValue();
                }
            }
        }
        return null;
    }
}

