/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.generic.ui;

import java.io.IOException;
import java.net.URI;
import org.eclipse.dirigible.ide.common.UriValidator;
import org.eclipse.dirigible.ide.generic.ui.GenericListManager;
import org.eclipse.dirigible.ide.generic.ui.GenericListViewContentProvider;
import org.eclipse.dirigible.ide.generic.ui.GenericListViewLabelProvider;
import org.eclipse.dirigible.ide.generic.ui.GenericLocationMetadata;
import org.eclipse.dirigible.ide.generic.ui.GenericView;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class GenericListView
extends ViewPart {
    private static final String REMOVE_LOCATION_FROM_THE_GENERIC_VIEWS_LIST = "Remove Location from the Generic Views list";
    private static final String OPEN_LOCATION_FROM_THE_GENERIC_VIEWS_LIST = "Open Location from the Generic Views list";
    private static final String ARE_YOU_SURE_YOU_WANT_TO_REMOVE_THIS_LOCATION = "Are you sure you want to remove this location?";
    private static final String REMOVE_LOCATION = "Remove Location";
    private static final String OPEN_LOCATION = "Open Location";
    private static final String ADD_LOCATION_TO_THE_GENERIC_VIEWS_LIST = "Add Location to the Generic Views list";
    public static final String GENERIC_VIEW_ERROR = "Generic View Error";
    private static final String URL = "URL";
    private static final String ADD_LOCATION = "Add Location";
    private static final String LOCATION = "Location";
    private static final String NAME = "Name";
    private static final Logger logger = Logger.getLogger(GenericListView.class);
    public static final String ID = "org.eclipse.dirigible.ide.generic.ui.GenericListView";
    private TreeViewer viewer;
    private Action actionAddLocation;
    private Action actionRemoveLocation;
    private Action actionOpenLocation;
    private GenericListManager genericListManager = GenericListManager.getInstance(RepositoryFacade.getInstance().getRepository());

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public GenericListManager getGenericListManager() {
        return this.genericListManager;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.getTree().setHeaderVisible(true);
        TreeColumn column = new TreeColumn(this.viewer.getTree(), 16384);
        column.setText(NAME);
        column.setWidth(150);
        column = new TreeColumn(this.viewer.getTree(), 16384);
        column.setText(LOCATION);
        column.setWidth(500);
        this.viewer.setContentProvider((IContentProvider)new GenericListViewContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new GenericListViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){
            private static final long serialVersionUID = -8683354310299838422L;

            public void menuAboutToShow(IMenuManager manager) {
                GenericListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        this.hookDoubleClickAction();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GenericListView.this.actionOpenLocation.run();
            }
        });
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAddLocation);
        manager.add((IAction)this.actionRemoveLocation);
        manager.add((IAction)this.actionOpenLocation);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAddLocation);
        manager.add((IAction)this.actionRemoveLocation);
        manager.add((IAction)this.actionOpenLocation);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddLocation);
        manager.add((IAction)this.actionRemoveLocation);
        manager.add((IAction)this.actionOpenLocation);
    }

    private void makeActions() {
        this.actionAddLocation = new Action(){
            private static final long serialVersionUID = -6534944336694980431L;

            public void run() {
                InputDialog dlg = new InputDialog(GenericListView.this.viewer.getControl().getShell(), GenericListView.ADD_LOCATION, GenericListView.URL, "http://", (IInputValidator)new UriValidator());
                if (dlg.open() == 0) {
                    try {
                        URI uri = new URI(dlg.getValue());
                        GenericListView.this.genericListManager.addLocation(this.getNameForLocation(uri), dlg.getValue());
                        GenericListView.this.viewer.refresh();
                    }
                    catch (Exception e) {
                        logger.error(GenericListView.GENERIC_VIEW_ERROR, (Throwable)e);
                        MessageDialog.openError((Shell)GenericListView.this.viewer.getControl().getShell(), (String)GenericListView.GENERIC_VIEW_ERROR, (String)e.getMessage());
                    }
                }
            }

            private String getNameForLocation(URI uri) throws IOException {
                String name;
                String originalName = name = CommonUtils.replaceNonAlphaNumericCharacters((String)uri.getHost());
                int i = 1;
                while (GenericListView.this.genericListManager.existsLocation(name)) {
                    name = String.valueOf(originalName) + i++;
                }
                return name;
            }
        };
        this.actionAddLocation.setText(ADD_LOCATION);
        this.actionAddLocation.setToolTipText(ADD_LOCATION_TO_THE_GENERIC_VIEWS_LIST);
        this.actionAddLocation.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.actionRemoveLocation = new Action(){
            private static final long serialVersionUID = 1336014167502247774L;

            public void run() {
                if (!GenericListView.this.viewer.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)GenericListView.this.viewer.getSelection();
                    GenericLocationMetadata location = (GenericLocationMetadata)selection.getFirstElement();
                    if (MessageDialog.openConfirm((Shell)GenericListView.this.viewer.getControl().getShell(), (String)GenericListView.REMOVE_LOCATION, (String)(GenericListView.ARE_YOU_SURE_YOU_WANT_TO_REMOVE_THIS_LOCATION + location.getLocation()))) {
                        try {
                            GenericListView.this.genericListManager.removeLocation(location.getName());
                            GenericListView.this.viewer.refresh();
                        }
                        catch (Exception e) {
                            logger.error(GenericListView.GENERIC_VIEW_ERROR, (Throwable)e);
                            MessageDialog.openError((Shell)GenericListView.this.viewer.getControl().getShell(), (String)GenericListView.GENERIC_VIEW_ERROR, (String)e.getMessage());
                        }
                    }
                }
            }
        };
        this.actionRemoveLocation.setText(REMOVE_LOCATION);
        this.actionRemoveLocation.setToolTipText(REMOVE_LOCATION_FROM_THE_GENERIC_VIEWS_LIST);
        this.actionRemoveLocation.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE"));
        this.actionOpenLocation = new Action(){
            private static final long serialVersionUID = 1336014167502247774L;

            public void run() {
                if (!GenericListView.this.viewer.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)GenericListView.this.viewer.getSelection();
                    GenericLocationMetadata location = (GenericLocationMetadata)selection.getFirstElement();
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                    IWorkbenchPage page = win.getActivePage();
                    String id = "org.eclipse.dirigible.ide.generic.ui.GenericView";
                    try {
                        IViewPart view = page.showView(id, location.getName(), 2);
                        ((GenericView)view).setSiteUrl(location.getLocation());
                        ((GenericView)view).setViewTitle(location.getName());
                    }
                    catch (PartInitException e) {
                        logger.error(GenericListView.GENERIC_VIEW_ERROR, (Throwable)e);
                    }
                }
            }
        };
        this.actionOpenLocation.setText(OPEN_LOCATION);
        this.actionOpenLocation.setToolTipText(OPEN_LOCATION_FROM_THE_GENERIC_VIEWS_LIST);
        this.actionOpenLocation.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEF_VIEW"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        private static final long serialVersionUID = -8832089975378999206L;

        NameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 != null && e2 != null && e1 instanceof GenericLocationMetadata && e2 instanceof GenericLocationMetadata) {
                return super.compare(viewer, (Object)((GenericLocationMetadata)e1).getLocation(), (Object)((GenericLocationMetadata)e2).getLocation());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

