/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.terminal.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.dirigible.ide.repository.RepositoryGlobalPreferenceStore;
import org.eclipse.dirigible.ide.terminal.ui.TerminalPreferencePage;
import org.eclipse.dirigible.repository.ext.command.Piper;
import org.eclipse.dirigible.repository.ext.command.ProcessUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class TerminalView
extends ViewPart {
    private static final String EXEEDS_TIMEOUT = "Exeeds timeout - ";
    private static final Logger logger = Logger.getLogger(TerminalView.class);
    private static Font terminalFont = new Font(null, "Courier New", 14, 0);
    private Text commandLine;
    private Text commandHistory;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        parent.setBackground(new Color(null, 0, 0, 0));
        parent.setForeground(new Color(null, 0, 255, 0));
        this.commandHistory = new Text(parent, 2826);
        this.commandHistory.setLayoutData((Object)new GridData(1808));
        this.commandHistory.setBackground(new Color(null, 0, 0, 0));
        this.commandHistory.setForeground(new Color(null, 0, 255, 0));
        this.commandHistory.setFont(terminalFont);
        this.commandLine = new Text(parent, 2048);
        this.commandLine.setLayoutData((Object)new GridData(768));
        this.commandLine.setBackground(new Color(null, 0, 0, 0));
        this.commandLine.setForeground(new Color(null, 0, 255, 0));
        this.commandLine.setFont(terminalFont);
        this.commandLine.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    try {
                        String result = TerminalView.executeCommand(ProcessUtils.translateCommandline((String)TerminalView.this.commandLine.getText()));
                        TerminalView.this.commandHistory.setText(result);
                    }
                    catch (IOException ex) {
                        TerminalView.this.commandHistory.setText(ex.getMessage());
                    }
                }
            }
        });
    }

    public void setFocus() {
        this.commandLine.setFocus();
    }

    private static String executeCommand(String[] args) throws IOException {
        if (args.length <= 0) {
            return "Need command to run";
        }
        RepositoryGlobalPreferenceStore preferenceStore = TerminalPreferencePage.getTerminalPreferenceStore();
        boolean limitEnabled = preferenceStore.getBoolean("limitEnabled");
        int limitTimeout = preferenceStore.getInt("limitTimeout");
        ProcessBuilder processBuilder = ProcessUtils.createProcess((String[])args);
        ProcessUtils.addEnvironmentVariables((ProcessBuilder)processBuilder, null);
        ProcessUtils.removeEnvironmentVariables((ProcessBuilder)processBuilder, null);
        processBuilder.redirectErrorStream(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Process process = ProcessUtils.startProcess((String[])args, (ProcessBuilder)processBuilder);
        Piper pipe = new Piper(process.getInputStream(), (OutputStream)out);
        new Thread((Runnable)pipe).start();
        try {
            int i = 0;
            boolean deadYet = false;
            do {
                Thread.sleep(ProcessUtils.DEFAULT_WAIT_TIME);
                try {
                    process.exitValue();
                    deadYet = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (!limitEnabled || ++i < limitTimeout) continue;
                    process.destroy();
                    throw new RuntimeException(EXEEDS_TIMEOUT + ProcessUtils.DEFAULT_WAIT_TIME / 1000 * limitTimeout);
                }
            } while (!deadYet);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
        return new String(out.toByteArray());
    }
}

