/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.generic.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.dirigible.ide.generic.ui.GenericLocationMetadata;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.ext.conf.ConfigurationStore;

public class GenericListManager {
    private static final String GENERIC_VIEWS = "genericViews";
    private static GenericListManager instance;
    private IRepository repository;
    private ConfigurationStore configurationStore;

    public static GenericListManager getInstance(IRepository repository) {
        if (instance == null) {
            instance = new GenericListManager(repository);
        }
        return instance;
    }

    public GenericListManager(IRepository repository) {
        this.repository = repository;
        this.configurationStore = new ConfigurationStore(repository);
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public ConfigurationStore getConfigurationStore() {
        return this.configurationStore;
    }

    public void addLocation(String name, String location) throws IOException {
        if (name == null || "".equals(name.trim()) || location == null || "".equals(location.trim())) {
            throw new IllegalArgumentException("Name and Location - both have to be provided");
        }
        List<GenericLocationMetadata> locationMetadatas = this.getLocationsList();
        for (GenericLocationMetadata genericLocationMetadata : locationMetadatas) {
            if (!name.equals(genericLocationMetadata.getName())) continue;
            throw new IllegalArgumentException(String.format("Generic View with this name is already present - %s", name));
        }
        Properties properties = new Properties();
        properties.setProperty("generic.view.name", name);
        properties.setProperty("generic.view.location", location);
        this.configurationStore.setGlobalSettings("/ide/generic/views", name, properties);
    }

    public void removeLocation(String name) throws IOException {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Name has to be provided");
        }
        this.configurationStore.removeGlobalSettings("/ide/generic/views", name);
    }

    public boolean existsLocation(String name) throws IOException {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Name has to be provided");
        }
        return this.configurationStore.existsGlobalSettings("/ide/generic/views", name);
    }

    public List<GenericLocationMetadata> getLocationsList() throws IOException {
        ArrayList<GenericLocationMetadata> result = new ArrayList<GenericLocationMetadata>();
        List names = this.configurationStore.listGlobalSettingsNames("/ide/generic/views");
        for (String name : names) {
            name = name.replaceAll(".properties", "");
            Properties properties = this.configurationStore.getGlobalSettings("/ide/generic/views", name);
            String genericViewName = properties.getProperty("generic.view.name");
            String genericViewLocation = properties.getProperty("generic.view.location");
            GenericLocationMetadata genericLocationMetadata = new GenericLocationMetadata(genericViewName, genericViewLocation);
            result.add(genericLocationMetadata);
        }
        return result;
    }
}

