/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers.categories;

import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractSideRelatedDifferenceCategory;
import org.eclipse.swt.graphics.Image;

public class ElementRemovalCategory
extends AbstractSideRelatedDifferenceCategory {
    public static final String ID_LEFT = "Technical.Removal.Left";
    public static final String ID_RIGHT = "Technical.Removal.Right";

    public ElementRemovalCategory(boolean sideIsLeft_p) {
        super(sideIsLeft_p);
    }

    public boolean covers(IDifference difference_p, EMFDiffNode node_p) {
        boolean result = false;
        if (difference_p instanceof IElementPresence) {
            IElementPresence presence = (IElementPresence)difference_p;
            Role sideRoleOpposite = node_p.getRoleForSide(!this.isLeftSide());
            Role presenceRole = presence.getPresenceRole();
            result = node_p.isThreeWay() ? presenceRole == sideRoleOpposite && presence.isAlignedWithAncestor() : presenceRole == node_p.getReferenceRole();
        }
        return result;
    }

    public String getID() {
        return this.isLeftSide() ? ID_LEFT : ID_RIGHT;
    }

    public Image getImage(EMFDiffNode node_p) {
        Image result = this.isLeftSide() ? EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.OUT_REM_STAT) : EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.INC_REM_STAT);
        return result;
    }

    public String getText(EMFDiffNode node_p) {
        boolean noReference;
        boolean bl = noReference = node_p.getReferenceRole() == null;
        String result = noReference ? (this.isLeftSide() ? Messages.ElementRemovalCategory_TextRemovedLeft : Messages.ElementRemovalCategory_TextRemovedRight) : Messages.ElementRemovalCategory_TextRemoved;
        return result;
    }

    public boolean isApplicable(EMFDiffNode node_p) {
        return node_p.isThreeWay() || node_p.getReferenceRole() == node_p.getRoleForSide(!this.isLeftSide());
    }
}

