/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morph;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;

public abstract class CharacterDefinition {
    public static final String FILENAME_SUFFIX = ".dat";
    protected final byte[] characterCategoryMap = new byte[65536];
    private final boolean[] invokeMap;
    private final boolean[] groupMap;

    protected CharacterDefinition(IOSupplier<InputStream> charDefResource, String charDefCodecHeader, int charDefCodecVersion, int classCount) throws IOException {
        try (InputStream is = (InputStream)charDefResource.get();){
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader((DataInput)in, (String)charDefCodecHeader, (int)charDefCodecVersion, (int)charDefCodecVersion);
            in.readBytes(this.characterCategoryMap, 0, this.characterCategoryMap.length);
            this.invokeMap = new boolean[classCount];
            this.groupMap = new boolean[classCount];
            for (int i = 0; i < classCount; ++i) {
                byte b = in.readByte();
                this.invokeMap[i] = (b & 1) != 0;
                this.groupMap[i] = (b & 2) != 0;
            }
        }
    }

    public byte getCharacterClass(char c) {
        return this.characterCategoryMap[c];
    }

    public boolean isInvoke(char c) {
        return this.invokeMap[this.characterCategoryMap[c]];
    }

    public boolean isGroup(char c) {
        return this.groupMap[this.characterCategoryMap[c]];
    }

    @FunctionalInterface
    public static interface LookupCharacterClass {
        public byte lookupCharacterClass(String var1);
    }
}

