/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ILinkedWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISkippable;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class LinkedWizardBase
extends BaseWizard
implements ILinkedWizard {
    ILinkedWizard mPrevious = null;
    ILinkedWizard mNext = null;
    protected boolean mFinished = false;

    @Override
    public void setPrevious(ILinkedWizard previous) {
        this.mPrevious = previous;
        if (this.mPrevious != null && (this.getWindowTitle() == null || this.getWindowTitle().length() == 0)) {
            this.setWindowTitle(this.mPrevious.getWindowTitle());
        }
    }

    @Override
    public ILinkedWizard getPrevious() {
        return this.mPrevious;
    }

    @Override
    public void setNext(ILinkedWizard next) {
        this.mNext = next;
        if (next != null) {
            this.mNext.setPrevious(this);
        }
    }

    @Override
    public ILinkedWizard getNext() {
        return this.mNext;
    }

    @Override
    public boolean canFinish() {
        boolean canFinish = super.canFinish();
        if (canFinish && this.getNext() != null) {
            canFinish = canFinish && this.getNext().canFinish();
        }
        return canFinish;
    }

    @Override
    public boolean isFinished() {
        return this.mFinished;
    }

    public void dispose() {
        super.dispose();
        this.mPrevious = null;
    }

    public boolean performFinish() {
        boolean noFailures = true;
        if (!this.mFinished) {
            LinkedWizardBase lastWiz = this;
            if (this.getNext() != null && !this.getNext().isFinished()) {
                lastWiz = (LinkedWizardBase)this.getNext();
                while (lastWiz.getNext() != null && !lastWiz.getNext().isFinished()) {
                    lastWiz = (LinkedWizardBase)lastWiz.getNext();
                }
            }
            do {
                lastWiz.mFinished = lastWiz.doFinish();
                noFailures = noFailures && lastWiz.isFinished();
                lastWiz = (LinkedWizardBase)lastWiz.getPrevious();
            } while (noFailures && lastWiz != null && !lastWiz.isFinished());
        }
        return this.mFinished && noFailures;
    }

    public abstract boolean doFinish();

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if ((nextPage == null || nextPage instanceof SummaryWizardPage) && this.getNext() != null) {
            nextPage = this.getNext().getStartingPage();
        }
        return nextPage;
    }

    @Override
    public List getSummaryData() {
        LinkedWizardBase prevWizard = (LinkedWizardBase)this.getPrevious();
        ArrayList summaryData = prevWizard == null ? new ArrayList() : prevWizard.getSummaryData();
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!(!(pages[i] instanceof ISummaryDataSource) || pages[i] instanceof ISkippable && ((ISkippable)pages[i]).getSkippable())) {
                summaryData.addAll(((ISummaryDataSource)pages[i]).getSummaryData());
            }
            ++i;
        }
        return summaryData;
    }
}

