/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.preferences;

import java.util.LinkedHashMap;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLSourceViewer;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCodeScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLPartitionScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import org.eclipse.datatools.sqltools.sqleditor.preferences.PreferenceMessages;
import org.eclipse.datatools.sqltools.sqleditor.preferences.SyntaxItem;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class SyntaxColoringPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List _syntaxList = null;
    private Button _boldFont = null;
    private Button _italicFont = null;
    private Button _strikethroughFont = null;
    private Button _underlineFont = null;
    private Button _systemDefault = null;
    private ColorSelector _colorSelector;
    private SQLSourceViewer _sourceViewer;
    private LinkedHashMap _defaultSyntaxItems = new LinkedHashMap();
    private String PreviewCode = "/*\n* Create/Insert/Select a table.\n*/\n-- create the table\nCREATE TABLE tab(col1 int, col2 varchar);\n\n-- insert data into the table\nINSERT INTO tab values(1, 'text');\n\n-- select the table\nSELECT count(*) AS \"COLUMN\" FROM tab;";

    public SyntaxColoringPage() {
        this.setDescription(PreferenceMessages.SyntaxColoringPage_description);
        this.setPreferenceStore(SQLEditorPlugin.getDefault().getPreferenceStore());
        this.initialPage();
    }

    private void initialPage() {
        this._defaultSyntaxItems.put(SQLColorProvider.SQL_COMMENT, new SyntaxItem(false, false, false, false, false, new RGB(64, 128, 128)));
        this._defaultSyntaxItems.put(SQLColorProvider.SQL_MULTILINE_COMMENT, new SyntaxItem(false, false, false, false, false, new RGB(64, 128, 128)));
        this._defaultSyntaxItems.put(SQLColorProvider.SQL_QUOTED_LITERAL, new SyntaxItem(false, false, false, false, false, new RGB(0, 0, 255)));
        this._defaultSyntaxItems.put(SQLColorProvider.SQL_DELIMITED_IDENTIFIER, new SyntaxItem(false, false, false, false, false, new RGB(0, 128, 0)));
        this._defaultSyntaxItems.put(SQLColorProvider.SQL_KEYWORD, new SyntaxItem(true, false, false, false, false, new RGB(127, 0, 85)));
        this._defaultSyntaxItems.put(SQLColorProvider.SQL_TYPE, new SyntaxItem(true, false, false, false, false, new RGB(64, 0, 200)));
        this._defaultSyntaxItems.put(SQLColorProvider.SQL_IDENTIFIER, new SyntaxItem(false, false, false, false, false, new RGB(0, 0, 128)));
        this._defaultSyntaxItems.put(SQLColorProvider.SQL_DEFAULT, new SyntaxItem(false, false, false, false, true, this.getForeGroundColor()));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HelpUtil.getContextId((String)"preferences_syntax_coloring", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }

    protected Control createContents(Composite parent) {
        Composite fontComposite = new Composite(parent, 0);
        GridLayout fontLayout = new GridLayout(2, false);
        fontLayout.marginHeight = 0;
        fontLayout.marginWidth = 0;
        fontComposite.setLayout((Layout)fontLayout);
        Label syntaxLabel = new Label(fontComposite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        syntaxLabel.setLayoutData((Object)gd);
        syntaxLabel.setText(PreferenceMessages.SyntaxColoringPage_syntax_items);
        this.createSyntax(fontComposite);
        this.createStyles(fontComposite);
        Label previewLabel = new Label(fontComposite, 0);
        previewLabel.setText(PreferenceMessages.SyntaxColoringPage_preview);
        this.createPreview(fontComposite);
        this.initialData();
        return fontComposite;
    }

    private void createSyntax(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(2));
        GridData gridData = new GridData();
        gridData.heightHint = 110;
        gridData.widthHint = 150;
        this._syntaxList = new List(comp, 2816);
        this._syntaxList.setLayoutData((Object)gridData);
        this._syntaxList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SyntaxColoringPage.this._syntaxList.getSelection()[0] != null) {
                    if (SyntaxColoringPage.this._syntaxList.getSelection()[0].equals(SQLColorProvider.SQL_DEFAULT)) {
                        SyntaxColoringPage.this._systemDefault.setVisible(true);
                    } else {
                        SyntaxColoringPage.this._systemDefault.setVisible(false);
                        SyntaxColoringPage.this._systemDefault.setSelection(false);
                        SyntaxColoringPage.this._colorSelector.setEnabled(true);
                    }
                    SyntaxColoringPage.this.refreshStyleComposite((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0]));
                }
            }
        });
    }

    private void createStyles(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(2));
        Composite compColorControl = new Composite(comp, 0);
        GridLayout colorLayout = new GridLayout(3, false);
        colorLayout.marginHeight = 0;
        colorLayout.marginWidth = 0;
        compColorControl.setLayout((Layout)colorLayout);
        Label label = new Label(compColorControl, 0);
        label.setText(PreferenceMessages.SyntaxColoringPage_color);
        this._colorSelector = new ColorSelector(compColorControl);
        this._colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0])).setColor(SyntaxColoringPage.this._colorSelector.getColorValue());
                SyntaxColoringPage.this.updatePreviewer();
            }
        });
        this._systemDefault = new Button(compColorControl, 32);
        this._systemDefault.setText(PreferenceMessages.SyntaxColoringPage_default_foreground_color);
        this._systemDefault.addSelectionListener((SelectionListener)new stylesListener());
        this._systemDefault.setVisible(false);
        this._boldFont = new Button(comp, 32);
        this._boldFont.setText(PreferenceMessages.SyntaxColoringPage_bold);
        this._boldFont.addSelectionListener((SelectionListener)new stylesListener());
        this._italicFont = new Button(comp, 32);
        this._italicFont.setText(PreferenceMessages.SyntaxColoringPage_italic);
        this._italicFont.addSelectionListener((SelectionListener)new stylesListener());
        this._strikethroughFont = new Button(comp, 32);
        this._strikethroughFont.setText(PreferenceMessages.SyntaxColoringPage_strikethrough);
        this._strikethroughFont.addSelectionListener((SelectionListener)new stylesListener());
        this._underlineFont = new Button(comp, 32);
        this._underlineFont.setText(PreferenceMessages.SyntaxColoringPage_underline);
        this._underlineFont.addSelectionListener((SelectionListener)new stylesListener());
    }

    private void createPreview(Composite parent) {
        this._sourceViewer = new SQLSourceViewer(parent, null, null, false, 2050);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        this._sourceViewer.getTextWidget().setLayoutData((Object)gridData);
        this._sourceViewer.setEditable(false);
        Document document = new Document(this.PreviewCode);
        SimpleSQLSourceViewerConfiguration config = new SimpleSQLSourceViewerConfiguration();
        this._sourceViewer.configure(config);
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)new DatabaseVendorDefinitionId("UNKOWN", "1.0"));
        SQLPartitionScanner _sqlPartitionSanner = new SQLPartitionScanner(factory.getSQLService().getSQLSyntax());
        if (document instanceof IDocumentExtension3) {
            Document extension3 = document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)_sqlPartitionSanner, SQLPartitionScanner.SQL_PARTITION_TYPES);
            partitioner.connect((IDocument)document);
            extension3.setDocumentPartitioner("___sql_partitioning", (IDocumentPartitioner)partitioner);
        }
        this._sourceViewer.setDocument((IDocument)document);
        this._sourceViewer.getTextWidget().setBackground(new Color((Device)Display.getCurrent(), this.getBackGroundColor()));
    }

    public void init(IWorkbench workbench) {
    }

    private void initialData() {
        for (String syntaxItemName : this._defaultSyntaxItems.keySet()) {
            this._syntaxList.add(syntaxItemName);
            if (this.getPreferenceStore().getString(syntaxItemName) == null || this.getPreferenceStore().getString(syntaxItemName).equals("")) {
                this._syntaxList.setData(syntaxItemName, (Object)new SyntaxItem(this._defaultSyntaxItems.get(syntaxItemName).toString()));
            } else {
                this._syntaxList.setData(syntaxItemName, (Object)new SyntaxItem(this.getPreferenceStore().getString(syntaxItemName)));
            }
            this.getPreferenceStore().setDefault(syntaxItemName, ((SyntaxItem)this._syntaxList.getData(syntaxItemName)).toString());
        }
        this._colorSelector.setColorValue(new RGB(0, 0, 0));
        this._syntaxList.select(0);
        this._syntaxList.notifyListeners(13, new Event());
    }

    private void getInitialValue() {
        if (this._syntaxList.getSelection()[0] != null) {
            this._syntaxList.setData(this._syntaxList.getSelection()[0], (Object)new SyntaxItem(this._defaultSyntaxItems.get(this._syntaxList.getSelection()[0]).toString()));
            this.refreshStyleComposite((SyntaxItem)this._defaultSyntaxItems.get(this._syntaxList.getSelection()[0]));
        }
    }

    public void performDefaults() {
        super.performDefaults();
        this.getInitialValue();
        this.updatePreviewer();
    }

    public boolean performOk() {
        int i = 0;
        while (i < this._syntaxList.getItemCount()) {
            String key = this._syntaxList.getItem(i);
            String value = ((SyntaxItem)this._syntaxList.getData(this._syntaxList.getItem(i))).toString();
            this.getPreferenceStore().putValue(key, value);
            this.getPreferenceStore().setDefault(key, value);
            ++i;
        }
        SQLEditorPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public boolean performCancel() {
        int i = 0;
        while (i < this._syntaxList.getItemCount()) {
            this.getPreferenceStore().putValue(this._syntaxList.getItem(i), this.getPreferenceStore().getDefaultString(this._syntaxList.getItem(i)));
            ++i;
        }
        return super.performCancel();
    }

    private void refreshStyleComposite(SyntaxItem syntax) {
        this._colorSelector.setColorValue(syntax.getColor());
        this._boldFont.setSelection(syntax.isBold());
        this._italicFont.setSelection(syntax.isItalic());
        this._strikethroughFont.setSelection(syntax.isStrikethrough());
        this._underlineFont.setSelection(syntax.isUnderline());
        this._systemDefault.setSelection(syntax.isSystemDefault());
        this._systemDefault.notifyListeners(13, new Event());
    }

    private void updatePreviewer() {
        this.getPreferenceStore().setValue(this._syntaxList.getSelection()[0], ((SyntaxItem)this._syntaxList.getData(this._syntaxList.getSelection()[0])).toString());
        SimpleSQLSourceViewerConfiguration config = new SimpleSQLSourceViewerConfiguration();
        this._sourceViewer.unconfigure();
        this._sourceViewer.configure(config);
    }

    private RGB getForeGroundColor() {
        String[] rgb = new String[]{"0", "0", "0"};
        try {
            String foreGroundColor;
            if (!EditorsPlugin.getDefault().getPreferenceStore().getString("AbstractTextEditor.Color.Foreground.SystemDefault").equalsIgnoreCase("true") && (foreGroundColor = EditorsPlugin.getDefault().getPreferenceStore().getString("AbstractTextEditor.Color.Foreground")) != null && !foreGroundColor.equals("")) {
                rgb = foreGroundColor.split(",");
            }
        }
        catch (Throwable throwable) {}
        return new RGB(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
    }

    private RGB getBackGroundColor() {
        String[] rgb = new String[]{"255", "255", "255"};
        try {
            String backGroundColor;
            if (!EditorsPlugin.getDefault().getPreferenceStore().getString("AbstractTextEditor.Color.Background.SystemDefault").equalsIgnoreCase("true") && (backGroundColor = EditorsPlugin.getDefault().getPreferenceStore().getString("AbstractTextEditor.Color.Background")) != null && !backGroundColor.equals("")) {
                rgb = backGroundColor.split(",");
            }
        }
        catch (Throwable throwable) {}
        return new RGB(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
    }

    class SimpleSQLSourceViewerConfiguration
    extends SourceViewerConfiguration {
        SimpleSQLSourceViewerConfiguration() {
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            SQLCodeScanner scanner = new SQLCodeScanner(SQLEditorPlugin.getDefault().getSQLColorProvider());
            SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)new DatabaseVendorDefinitionId("UNKOWN", "1.0"));
            if (factory != null) {
                scanner.setSQLSyntax(factory.getSQLService().getSQLSyntax());
            }
            PresentationReconciler reconciler = new PresentationReconciler();
            reconciler.setDocumentPartitioning("___sql_partitioning");
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, "sql_multiline_comment");
            reconciler.setRepairer((IPresentationRepairer)dr, "sql_multiline_comment");
            dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, "sql_comment");
            reconciler.setRepairer((IPresentationRepairer)dr, "sql_comment");
            dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, "sql_character");
            reconciler.setRepairer((IPresentationRepairer)dr, "sql_character");
            dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, "sql_double_quotes_identifier");
            reconciler.setRepairer((IPresentationRepairer)dr, "sql_double_quotes_identifier");
            dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, "sql_code");
            reconciler.setRepairer((IPresentationRepairer)dr, "sql_code");
            return reconciler;
        }
    }

    class stylesListener
    implements SelectionListener {
        stylesListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0])).setBoldKey(SyntaxColoringPage.this._boldFont.getSelection());
            ((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0])).setItalicKey(SyntaxColoringPage.this._italicFont.getSelection());
            ((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0])).setStrikethroughKey(SyntaxColoringPage.this._strikethroughFont.getSelection());
            ((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0])).setUnderlineKey(SyntaxColoringPage.this._underlineFont.getSelection());
            ((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0])).setSystemDefault(SyntaxColoringPage.this._systemDefault.getSelection());
            if (SyntaxColoringPage.this._systemDefault.isVisible() && SyntaxColoringPage.this._systemDefault.getSelection()) {
                ((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0])).setColor(((SyntaxItem)SyntaxColoringPage.this._defaultSyntaxItems.get(SQLColorProvider.SQL_DEFAULT)).getColor());
            } else {
                ((SyntaxItem)SyntaxColoringPage.this._syntaxList.getData(SyntaxColoringPage.this._syntaxList.getSelection()[0])).setColor(SyntaxColoringPage.this._colorSelector.getColorValue());
            }
            SyntaxColoringPage.this._colorSelector.setEnabled(!SyntaxColoringPage.this._systemDefault.getSelection());
            SyntaxColoringPage.this.updatePreviewer();
        }
    }
}

