/*
 * This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */

package org.eclipse.datatools.sqltools.parsers.sql.lexer;

public interface SQLParsersym {
    public final static int
      TK_ACCESS = 1,
      TK_ACCTNG = 2,
      TK_ACTION = 3,
      TK_ACTIVATE = 4,
      TK_ADD = 5,
      TK_ADMIN = 6,
      TK_ADMINISTRATION = 7,
      TK_AFTER = 8,
      TK_AGE = 9,
      TK_ALIAS = 10,
      TK_ALL = 11,
      TK_ALLOCATE = 12,
      TK_ALLOW = 13,
      TK_ALTER = 14,
      TK_ALTERIN = 15,
      TK_ALWAYS = 16,
      TK_AND = 17,
      TK_ANY = 18,
      TK_APPEND = 19,
      TK_APPL_ID = 20,
      TK_APPL_NAME = 21,
      TK_APPLNAME = 22,
      TK_ARRAY = 23,
      TK_AS = 24,
      TK_ASC = 25,
      TK_ASCII = 26,
      TK_ASENSITIVE = 27,
      TK_ASSIGNMENT = 28,
      TK_ASSOCIATE = 29,
      TK_AST = 30,
      TK_ASUTIME = 31,
      TK_AT = 32,
      TK_ATOMIC = 33,
      TK_ATTRIBUTE = 34,
      TK_ATTRIBUTES = 35,
      TK_AUTHORIZATION = 36,
      TK_AUTH_ID = 37,
      TK_AUTHID = 38,
      TK_AUTOMATIC = 39,
      TK_AUTOSTART = 40,
      TK_AVAILABLE = 41,
      TK_B = 42,
      TK_BEFORE = 43,
      TK_BEGIN = 44,
      TK_BERNOULLI = 45,
      TK_BETWEEN = 46,
      TK_BIGINT = 47,
      TK_BINARY = 48,
      TK_BIND = 49,
      TK_BINDADD = 50,
      TK_BIT = 51,
      TK_BLOB = 52,
      TK_BLOCKED = 53,
      TK_BLOCKSIZE = 54,
      TK_BOTH = 55,
      TK_BUFFER = 56,
      TK_BUFFERPOOL = 57,
      TK_BUFFERPOOLS = 58,
      TK_BUFFERSIZE = 59,
      TK_BUILD = 60,
      TK_BY = 61,
      TK_BYPASS = 62,
      TK_C = 63,
      TK_CACHE = 64,
      TK_CACHING = 65,
      TK_CALL = 66,
      TK_CALLED = 67,
      TK_CALLER = 68,
      TK_CAPTURE = 69,
      TK_CARDINALITIES = 70,
      TK_CARDINALITY = 71,
      TK_CASCADE = 72,
      TK_CASCADED = 73,
      TK_CASE = 74,
      TK_CAST = 75,
      TK_CCSID = 76,
      TK_CHANGE = 77,
      TK_CHANGED = 78,
      TK_CHANGES = 79,
      TK_CHAR = 80,
      TK_CHARACTER = 81,
      TK_CHECK = 82,
      TK_CHECKED = 83,
      TK_CLIENT = 84,
      TK_CLOB = 85,
      TK_CLOSE = 86,
      TK_CLR = 87,
      TK_CLUSTER = 88,
      TK_COBOL = 89,
      TK_COLLECT = 90,
      TK_COLLID = 91,
      TK_COLUMN = 92,
      TK_COLUMNS = 93,
      TK_COMM = 94,
      TK_COMMENT = 95,
      TK_COMMIT = 96,
      TK_COMMITTED = 97,
      TK_COMPACT = 98,
      TK_COMPARE = 99,
      TK_COMPARISONS = 100,
      TK_COMPRESS = 101,
      TK_COMPRESSION = 102,
      TK_CONCAT = 103,
      TK_CONDITION = 104,
      TK_CONN = 105,
      TK_CONNECT = 106,
      TK_CONNECTIONS = 107,
      TK_CONNECTOPT = 108,
      TK_CONNHEADER = 109,
      TK_CONNMEMUSE = 110,
      TK_CONSERVATIVE = 111,
      TK_CONSTRAINT = 112,
      TK_CONSTRAINTS = 113,
      TK_CONSTRUCTOR = 114,
      TK_CONTAINERS = 115,
      TK_CONTAINS = 116,
      TK_CONTENT = 117,
      TK_CONTINUE = 118,
      TK_CONTINUOUSLY = 119,
      TK_CONTROL = 120,
      TK_COPY = 121,
      TK_COUNT = 122,
      TK_COUNT_BIG = 123,
      TK_CPU = 124,
      TK_CREATE = 125,
      TK_CREATE_EXTERNAL_ROUTINE = 126,
      TK_CREATEIN = 127,
      TK_CREATE_NOT_FENCED = 128,
      TK_CREATE_NOT_FENCED_ROUTINE = 129,
      TK_CREATETAB = 130,
      TK_CS = 131,
      TK_CUBE = 132,
      TK_CURRENT = 133,
      TK_CURRENT_DATE = 134,
      TK_CURRENT_DEFAULT_TRANSFORM_GROUP = 135,
      TK_CURRENT_PATH = 136,
      TK_CURRENT_ROLE = 137,
      TK_CURRENT_TIME = 138,
      TK_CURRENT_TIMESTAMP = 139,
      TK_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 140,
      TK_CURRENT_USER = 141,
      TK_CURRVAL = 142,
      TK_CURSOR = 143,
      TK_CURSORS = 144,
      TK_CYCLE = 145,
      TK_DATA = 146,
      TK_DATABASE = 147,
      TK_DATALINK = 148,
      TK_DATE = 149,
      TK_DAY = 150,
      TK_DAYS = 151,
      TK_DB = 152,
      TK_DBADM = 153,
      TK_DBCLOB = 154,
      TK_DBINFO = 155,
      TK_DBMEMUSE = 156,
      TK_DBPARTITIONNUM = 157,
      TK_DBPARTITIONNUMS = 158,
      TK_DB2DARI = 159,
      TK_DB2GENRL = 160,
      TK_DB2GENERAL = 161,
      TK_DB2OPTIONS = 162,
      TK_DB2SPL = 163,
      TK_DB2SQL = 164,
      TK_DB2_RETURN_STATUS = 165,
      TK_DB2_TOKEN_STRING = 166,
      TK_DEACTIVATE = 167,
      TK_DEADLOCK = 168,
      TK_DEADLOCKS = 169,
      TK_DEC = 170,
      TK_DECIMAL = 171,
      TK_DECLARE = 172,
      TK_DEFAULT = 173,
      TK_DEFAULTS = 174,
      TK_DEFINE = 175,
      TK_DEFINITION = 176,
      TK_DEGREE = 177,
      TK_DEFER = 178,
      TK_DEFERRED = 179,
      TK_DELETE = 180,
      TK_DESC = 181,
      TK_DESCRIPTOR = 182,
      TK_DETAILED = 183,
      TK_DETAILS = 184,
      TK_DETERMINED = 185,
      TK_DETERMINISTIC = 186,
      TK_DEVICE = 187,
      TK_DIAGNOSTICS = 188,
      TK_DIMENSIONS = 189,
      TK_DIRTY = 190,
      TK_DISABLE = 191,
      TK_DISALLOW = 192,
      TK_DISPATCH = 193,
      TK_DISTINCT = 194,
      TK_DISTRIBUTION = 195,
      TK_DLCONN = 196,
      TK_DLLOCK = 197,
      TK_DO = 198,
      TK_DOUBLE = 199,
      TK_DROP = 200,
      TK_DROPIN = 201,
      TK_DROPPED = 202,
      TK_DYNAMIC = 203,
      TK_EACH = 204,
      TK_ELEMENT = 205,
      TK_ELSE = 206,
      TK_ELSEIF = 207,
      TK_EMPTY = 208,
      TK_ENABLE = 209,
      TK_ENCRYPTION = 210,
      TK_END = 211,
      TK_ENDING = 212,
      TK_ENFORCED = 213,
      TK_ERASE = 214,
      TK_ESCAPE = 215,
      TK_ESTIMATE = 216,
      TK_EUR = 217,
      TK_EVALUATE = 218,
      TK_EVENT = 219,
      TK_EXACT = 220,
      TK_EXCEPT = 221,
      TK_EXCEPTION = 222,
      TK_EXCLUDE = 223,
      TK_EXCLUDES = 224,
      TK_EXCLUDING = 225,
      TK_EXCLUSIVE = 226,
      TK_EXECNODE = 227,
      TK_EXECUTE = 228,
      TK_EXISTS = 229,
      TK_EXIT = 230,
      TK_EXPAND = 231,
      TK_EXPLAIN = 232,
      TK_EXPRESSION = 233,
      TK_EXTEND = 234,
      TK_EXTENDED = 235,
      TK_EXTENSION = 236,
      TK_EXTENTSIZE = 237,
      TK_EXTERNAL = 238,
      TK_FALSE = 239,
      TK_FEDERATED = 240,
      TK_FEDERATED_TOOL = 241,
      TK_FENCED = 242,
      TK_FETCH = 243,
      TK_FILE = 244,
      TK_FILTER = 245,
      TK_FINAL = 246,
      TK_FIRST = 247,
      TK_FLOAT = 248,
      TK_FLUSH = 249,
      TK_FOLLOWING = 250,
      TK_FOR = 251,
      TK_FORCE = 252,
      TK_FOREIGN = 253,
      TK__FOREIGNKEY = 254,
      TK_FOUND = 255,
      TK_FREE = 256,
      TK_FREEPAGE = 257,
      TK_FROM = 258,
      TK_FS = 259,
      TK_FULL = 260,
      TK_FUNCTION = 261,
      TK_G = 262,
      TK_GBPCACHE = 263,
      TK_GENERAL = 264,
      TK_GENERATE = 265,
      TK_GENERATED = 266,
      TK_GET = 267,
      TK_GLOBAL = 268,
      TK_GOTO = 269,
      TK_GRANT = 270,
      TK_GRAPHIC = 271,
      TK_GROUP = 272,
      TK_GROUPING = 273,
      TK_HANDLER = 274,
      TK_HASHING = 275,
      TK_HAVING = 276,
      TK_HIDDEN = 277,
      TK_HIERARCHY = 278,
      TK_HIGH = 279,
      TK_HOLD = 280,
      TK_HOUR = 281,
      TK_HOURS = 282,
      TK_HPJ = 283,
      TK_ID = 284,
      TK_IDENTITY = 285,
      TK_IF = 286,
      TK_IGNORE = 287,
      TK_IMMEDIATE = 288,
      TK_IMPLICIT_SCHEMA = 289,
      TK_IN = 290,
      TK_INCLUDE = 291,
      TK_INCLUDES = 292,
      TK_INCLUDING = 293,
      TK_INCREMENT = 294,
      TK_INCREMENTAL = 295,
      TK_INDEX = 296,
      TK_INDEXES = 297,
      TK_INDICATOR = 298,
      TK_INFIX = 299,
      TK_INFO = 300,
      TK_INHERIT = 301,
      TK_INITIALLY = 302,
      TK_INITIAL_INSTS = 303,
      TK_INITIAL_IOS = 304,
      TK_INLINE = 305,
      TK_INNER = 306,
      TK_INOUT = 307,
      TK_INPUT = 308,
      TK_INSENSITIVE = 309,
      TK_INSERT = 310,
      TK_INSTANTIABLE = 311,
      TK_INSTEAD = 312,
      TK_INSTS_PER_ARGBYTE = 313,
      TK_INSTS_PER_INVOC = 314,
      TK_INT = 315,
      TK_INTEGER = 316,
      TK_INTEGRITY = 317,
      TK_INTERSECT = 318,
      TK_INTO = 319,
      TK_IO = 320,
      TK_IOS_PER_ARGBYTE = 321,
      TK_IOS_PER_INVOC = 322,
      TK_IS = 323,
      TK_ISO = 324,
      TK_ITERATE = 325,
      TK_ISOLATION = 326,
      TK_JAVA = 327,
      TK_JIS = 328,
      TK_JOIN = 329,
      TK_K = 330,
      TK_KEEP = 331,
      TK_KEY = 332,
      TK_KEYS = 333,
      TK_L = 334,
      TK_LANGUAGE = 335,
      TK_LARGE = 336,
      TK_LAST = 337,
      TK_LATERAL = 338,
      TK_LC_CTYPE = 339,
      TK_LEADING = 340,
      TK_LEAVE = 341,
      TK_LEFT = 342,
      TK_LENGTH = 343,
      TK_LEVEL = 344,
      TK_LEVEL2 = 345,
      TK_LIBRARY = 346,
      TK_LIBRARYADM = 347,
      TK_LIKE = 348,
      TK_LIMIT = 349,
      TK_LINK = 350,
      TK_LINKTYPE = 351,
      TK_LOAD = 352,
      TK_LOCAL = 353,
      TK_LOCALE = 354,
      TK_LOCALTIME = 355,
      TK_LOCALTIMESTAMP = 356,
      TK_LOCATOR = 357,
      TK_LOCATORS = 358,
      TK_LOCK = 359,
      TK_LOCKS = 360,
      TK_LOCKSIZE = 361,
      TK_LOG = 362,
      TK_LOGGED = 363,
      TK_LONG = 364,
      TK_LONGVAR = 365,
      TK_LOOP = 366,
      TK_LOW = 367,
      TK_M = 368,
      TK_MAIN_PROG = 369,
      TK_MANAGED = 370,
      TK_MANUALSTART = 371,
      TK_MAPPING = 372,
      TK_MATCHED = 373,
      TK_MATERIALIZED = 374,
      TK_MAXFILES = 375,
      TK_MAXFILESIZE = 376,
      TK_MAXVALUE = 377,
      TK_MDC = 378,
      TK_MERGE = 379,
      TK_MESSAGE_TEXT = 380,
      TK_METHOD = 381,
      TK_METHODS = 382,
      TK_MICROSECOND = 383,
      TK_MICROSECONDS = 384,
      TK_MINPCTUSED = 385,
      TK_MINUTE = 386,
      TK_MINUTES = 387,
      TK_MINVALUE = 388,
      TK_MIXED = 389,
      TK_MODE = 390,
      TK_MODIFIES = 391,
      TK_MONITOR = 392,
      TK_MONTH = 393,
      TK_MONTHS = 394,
      TK_MOVEMENT = 395,
      TK_MULTISET = 396,
      TK_N = 397,
      TK_NAME = 398,
      TK_NEW = 399,
      TK_NEW_TABLE = 400,
      TK_NEXT = 401,
      TK_NEXTVAL = 402,
      TK_NICKNAME = 403,
      TK_NO = 404,
      TK_NOCACHE = 405,
      TK_NOCYCLE = 406,
      TK_NODE = 407,
      TK_NODES = 408,
      TK_NODEGROUP = 409,
      TK_NOMAXVALUE = 410,
      TK_NOMINVALUE = 411,
      TK_NONBLOCKED = 412,
      TK_NONE = 413,
      TK_NOORDER = 414,
      TK_NOT = 415,
      TK_NULL = 416,
      TK_NULLS = 417,
      TK_NUM = 418,
      TK_NUMBLOCKPAGES = 419,
      TK_NUMERIC = 420,
      TK_NUM_FREQVALUES = 421,
      TK_NUM_QUANTILES = 422,
      TK_OBJECT = 423,
      TK_OF = 424,
      TK_OFF = 425,
      TK_OLD = 426,
      TK_OLD_TABLE = 427,
      TK_OLE = 428,
      TK_OLEDB = 429,
      TK_ON = 430,
      TK_ONCE = 431,
      TK_ONLINE = 432,
      TK_ONLY = 433,
      TK_OPEN = 434,
      TK_OPTIMIZATION = 435,
      TK_OPTIMIZE = 436,
      TK_OPTION = 437,
      TK_OPTIONS = 438,
      TK_OR = 439,
      TK_ORDER = 440,
      TK_ORGANIZE = 441,
      TK_OUT = 442,
      TK_OUTER = 443,
      TK_OVER = 444,
      TK_OVERFLOW = 445,
      TK_OVERHEAD = 446,
      TK_OVERRIDING = 447,
      TK_P = 448,
      TK_PACKAGE = 449,
      TK_PAGE = 450,
      TK_PAGESIZE = 451,
      TK_PARALLEL = 452,
      TK_PARAMETER = 453,
      TK_PASSTHRU = 454,
      TK_PASSWORD = 455,
      TK_PATH = 456,
      TK_PARTITION = 457,
      TK_PARTITIONING = 458,
      TK_PARTITIONINGS = 459,
      TK_PATROLLER = 460,
      TK_PCTDEACTIVATE = 461,
      TK_PCTFREE = 462,
      TK_PENDING = 463,
      TK_PERCENT_ARGBYTES = 464,
      TK_PERMISSION = 465,
      TK_PIECESIZE = 466,
      TK_PIPE = 467,
      TK_PLAN = 468,
      TK_PRECEDING = 469,
      TK_PRECISION = 470,
      TK_PREDICATES = 471,
      TK_PREFETCHSIZE = 472,
      TK_PREPARE = 473,
      TK_PRESERVE = 474,
      TK_PREVIOUS = 475,
      TK_PREVVAL = 476,
      TK_PRIMARY = 477,
      TK__PRIMARYKEY = 478,
      TK_PRIQTY = 479,
      TK_PRIVILEGES = 480,
      TK_PROCEDURE = 481,
      TK_PROFILE = 482,
      TK_PROGRAM = 483,
      TK_PROPAGATE = 484,
      TK_PROTOCOL = 485,
      TK_PRUNE = 486,
      TK_PUBLIC = 487,
      TK_QUERY = 488,
      TK_QUERYNO = 489,
      TK_QUERYTAG = 490,
      TK_QUIESCE_CONNECT = 491,
      TK_RANGE = 492,
      TK_RATE = 493,
      TK_RATIO = 494,
      TK_READ = 495,
      TK_READS = 496,
      TK_REAL = 497,
      TK_RECOMMEND = 498,
      TK_RECONCILE = 499,
      TK_RECOVERY = 500,
      TK_RECREATE = 501,
      TK_REDUCE = 502,
      TK_REF = 503,
      TK_REFERENCE = 504,
      TK_REFERENCES = 505,
      TK_REFERENCING = 506,
      TK_REFRESH = 507,
      TK_REGISTERS = 508,
      TK_REGULAR = 509,
      TK_RELEASE = 510,
      TK_REMAIN = 511,
      TK_REMOTE = 512,
      TK_RENAME = 513,
      TK_REOPT = 514,
      TK_REPEATABLE = 515,
      TK_REPEAT = 516,
      TK_REPLACE = 517,
      TK_REPLICATED = 518,
      TK_REQUIRING = 519,
      TK_RESET = 520,
      TK_RESIDENT = 521,
      TK_RESIGNAL = 522,
      TK_RESIZE = 523,
      TK_RESOLVE = 524,
      TK_RESTART = 525,
      TK_RESTORE = 526,
      TK_RESTRICT = 527,
      TK_RESULT = 528,
      TK_RESULT_SET_LOCATOR = 529,
      TK_RETAIN = 530,
      TK_RETURN = 531,
      TK_RETURNS = 532,
      TK_RETURN_STATUS = 533,
      TK_REVERSE = 534,
      TK_REVOKE = 535,
      TK_RIGHT = 536,
      TK_ROLLBACK = 537,
      TK_ROLLUP = 538,
      TK_ROUTINE = 539,
      TK_ROW = 540,
      TK_ROW_COUNT = 541,
      TK_ROWS = 542,
      TK_RR = 543,
      TK_RS = 544,
      TK_RUN = 545,
      TK_S = 546,
      TK_SAMPLED = 547,
      TK_SAVEPOINT = 548,
      TK_SBCS = 549,
      TK_SCANS = 550,
      TK_SCHEMA = 551,
      TK_SCOPE = 552,
      TK_SCRATCHPAD = 553,
      TK_SCROLL = 554,
      TK_SEARCH = 555,
      TK_SECOND = 556,
      TK_SECONDS = 557,
      TK_SECQTY = 558,
      TK_SECURITYADM = 559,
      TK_SELECT = 560,
      TK_SELECTION = 561,
      TK_SELECTIVE = 562,
      TK_SELECTIVITY = 563,
      TK_SELF = 564,
      TK_SENSITIVE = 565,
      TK_SEQUENCE = 566,
      TK_SERIALIZABLE = 567,
      TK_SERVER = 568,
      TK_SESSION = 569,
      TK_SESSION_USER = 570,
      TK_SET = 571,
      TK_SETS = 572,
      TK_SETTING = 573,
      TK_SHARE = 574,
      TK_SHRLEVEL = 575,
      TK_SIGNAL = 576,
      TK_SIMPLE = 577,
      TK_SIZE = 578,
      TK_SMALLINT = 579,
      TK_SNAPSHOT = 580,
      TK_SOME = 581,
      TK_SOURCE = 582,
      TK_SPECIAL = 583,
      TK_SPECIFIC = 584,
      TK_SPECIFICATION = 585,
      TK_SPLIT = 586,
      TK_SQL = 587,
      TK_SQLDATA = 588,
      TK_SQLERROR = 589,
      TK_SQLEXCEPTION = 590,
      TK_SQLWARNING = 591,
      TK_SQLID = 592,
      TK_SQLMACRO = 593,
      TK_SQLSTATE = 594,
      TK_SSA = 595,
      TK_STABILITY = 596,
      TK_STAGING = 597,
      TK_START = 598,
      TK_STATE = 599,
      TK_STATEMENT = 600,
      TK_STATEMENTS = 601,
      TK_STATIC = 602,
      TK_STATISTICS = 603,
      TK_STARTING = 604,
      TK_STAY = 605,
      TK_STMT = 606,
      TK_STOGROUP = 607,
      TK_STORAGE = 608,
      TK_STORED = 609,
      TK_STRIP = 610,
      TK_STRIPE = 611,
      TK_STYLE = 612,
      TK_SUB = 613,
      TK_SUBSECTION = 614,
      TK_SUMMARY = 615,
      TK_SWITCH = 616,
      TK_SYMMETRIC = 617,
      TK_SYNONYM = 618,
      TK_SYSTEM = 619,
      TK_SYSTEM_USER = 620,
      TK_T = 621,
      TK_TABLE = 622,
      TK_TABLES = 623,
      TK_TABLESAMPLE = 624,
      TK_TABLESPACE = 625,
      TK_TABLESPACES = 626,
      TK_TARGET = 627,
      TK_TEMPLATE = 628,
      TK_TEMPORARY = 629,
      TK_THEN = 630,
      TK_THREADSAFE = 631,
      TK_THROUGH = 632,
      TK_TIME = 633,
      TK_TIMEOUT = 634,
      TK_TIMESTAMP = 635,
      TK_TIMEZONE = 636,
      TK_TO = 637,
      TK_TOKEN = 638,
      TK_TRAILING = 639,
      TK_TRANSACTIONS = 640,
      TK_TRANSFERRATE = 641,
      TK_TRANSFORM = 642,
      TK_TRANSFORMS = 643,
      TK_TRANSLATE = 644,
      TK_TREAT = 645,
      TK_TRIGGER = 646,
      TK_TRUE = 647,
      TK_TRUNC = 648,
      TK_TWOLEVEL = 649,
      TK_TYPE = 650,
      TK_TYPES = 651,
      TK_UNBOUNDED = 652,
      TK_UNCHECKED = 653,
      TK_UNCOMMITTED = 654,
      TK_UNDER = 655,
      TK_UNDO = 656,
      TK_UNICODE = 657,
      TK_UNION = 658,
      TK_UNIQUE = 659,
      TK_UNLINK = 660,
      TK_UNTIL = 661,
      TK_UPDATE = 662,
      TK_UR = 663,
      TK_URL = 664,
      TK_USA = 665,
      TK_USE = 666,
      TK_USAGE = 667,
      TK_USER = 668,
      TK_USERID = 669,
      TK_USING = 670,
      TK_VALUE = 671,
      TK_VALUES = 672,
      TK_VARCHAR = 673,
      TK_VARGRAPHIC = 674,
      TK_VARIANT = 675,
      TK_VARYING = 676,
      TK_VCAT = 677,
      TK_VERSION = 678,
      TK_VIEW = 679,
      TK_VOLATILE = 680,
      TK_WAIT = 681,
      TK_WHEN = 682,
      TK_WHERE = 683,
      TK_WHILE = 684,
      TK_WITH = 685,
      TK_WITHOUT = 686,
      TK_WORK = 687,
      TK_WRAPPER = 688,
      TK_WRITE = 689,
      TK_WRKSTNNAME = 690,
      TK_X = 691,
      TK_XACT = 692,
      TK_YEAR = 693,
      TK_YEARS = 694,
      TK_YES = 695,
      TK_ABSENT = 696,
      TK_ACCORDING = 697,
      TK_BASE64 = 698,
      TK_DOCUMENT = 699,
      TK_ENCODING = 700,
      TK_HEX = 701,
      TK_LOCATION = 702,
      TK_NAMESPACE = 703,
      TK_NIL = 704,
      TK_ORDINALITY = 705,
      TK_PASSING = 706,
      TK_PI = 707,
      TK_RETURNING = 708,
      TK_URI = 709,
      TK_WHITESPACE = 710,
      TK_XML = 711,
      TK_XMLAGG = 712,
      TK_XMLATTRIBUTES = 713,
      TK_XMLBINARY = 714,
      TK_XMLCAST = 715,
      TK_XMLCOMMENT = 716,
      TK_XMLCONCAT = 717,
      TK_XMLDECLARATION = 718,
      TK_XMLDOCUMENT = 719,
      TK_XMLELEMENT = 720,
      TK_XMLEXISTS = 721,
      TK_XMLFOREST = 722,
      TK_XMLNAMESPACES = 723,
      TK_XMLPARSE = 724,
      TK_XMLPI = 725,
      TK_XMLQUERY = 726,
      TK_XMLSCHEMA = 727,
      TK_XMLSERIALIZE = 728,
      TK_XMLTABLE = 729,
      TK_XMLTEXT = 730,
      TK_XMLVALIDATE = 731,
      TK_EOLN = 732,
      TK_PARSE_ERROR = 733,
      TK_REGULAR_IDENTIFIER = 734,
      TK_DELIMITED_IDENTIFIER = 735,
      TK_EMBEDDED_VARIABLE_NAME = 736,
      TK_UNSIGNED_INTEGER = 737,
      TK_SUFFIXED_UNSIGNED_INTEGER = 738,
      TK_EXACT_NUMERIC_LITERAL = 739,
      TK_APPROXIMATE_NUMERIC_LITERAL = 740,
      TK_NATIONAL_CHAR_STRING_LITERAL = 741,
      TK_NATIONAL_HEX_STRING_LITERAL = 742,
      TK_BIT_STRING_LITERAL = 743,
      TK_HEX_STRING_LITERAL = 744,
      TK_CHAR_STRING_LITERAL = 745,
      TK_COMMENT_STRING = 746,
      TK_DELIMITED_TYPE_IDENTIFIER = 747,
      TK_VERSION_IDENTIFIER = 748,
      TK_DOUBLE_QUOTE = 749,
      TK_PERCENT = 750,
      TK_AMPERSAND = 751,
      TK_QUOTE = 752,
      TK_LEFT_PAREN = 753,
      TK_RIGHT_PAREN = 754,
      TK_ASTERISK = 755,
      TK_PLUS_SIGN = 756,
      TK_COMMA = 757,
      TK_MINUS_SIGN = 758,
      TK_PERIOD = 759,
      TK_SOLIDUS = 760,
      TK_REVERSE_SOLIDUS = 761,
      TK_COLON = 762,
      TK_SEMICOLON = 763,
      TK_LESS_THAN_OPERATOR = 764,
      TK_EQUALS_OPERATOR = 765,
      TK_GREATER_THAN_OPERATOR = 766,
      TK_QUESTION_MARK = 767,
      TK_LEFT_BRACKET = 768,
      TK_RIGHT_BRACKET = 769,
      TK_LEFT_BRACKET_TRIGRAPH = 770,
      TK_RIGHT_BRACKET_TRIGRAPH = 771,
      TK_VERTICAL_BAR = 772,
      TK_NOT_EQUALS_OPERATOR = 773,
      TK_GREATER_THAN_OR_EQUALS_OPERATOR = 774,
      TK_LESS_THAN_OR_EQUALS_OPERATOR = 775,
      TK_CONCAT_OPERATOR = 776,
      TK_DOUBLE_PERIOD = 777,
      TK_RIGHT_ARROW = 778,
      TK_STATEMENT_TERMINATOR = 779,
      TK_HOSTVARIABLE = 780,
      TK_PARAMETER_MARKER = 781,
      TK_LINE_COMMENT = 782,
      TK_MULTILINE_COMMENT = 783,
      TK_LEFT_BRACE = 784,
      TK_RIGHT_BRACE = 785,
      TK_BACK_QUOTE = 786,
      TK_EOF = 787;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "ACCESS",
                 "ACCTNG",
                 "ACTION",
                 "ACTIVATE",
                 "ADD",
                 "ADMIN",
                 "ADMINISTRATION",
                 "AFTER",
                 "AGE",
                 "ALIAS",
                 "ALL",
                 "ALLOCATE",
                 "ALLOW",
                 "ALTER",
                 "ALTERIN",
                 "ALWAYS",
                 "AND",
                 "ANY",
                 "APPEND",
                 "APPL_ID",
                 "APPL_NAME",
                 "APPLNAME",
                 "ARRAY",
                 "AS",
                 "ASC",
                 "ASCII",
                 "ASENSITIVE",
                 "ASSIGNMENT",
                 "ASSOCIATE",
                 "AST",
                 "ASUTIME",
                 "AT",
                 "ATOMIC",
                 "ATTRIBUTE",
                 "ATTRIBUTES",
                 "AUTHORIZATION",
                 "AUTH_ID",
                 "AUTHID",
                 "AUTOMATIC",
                 "AUTOSTART",
                 "AVAILABLE",
                 "B",
                 "BEFORE",
                 "BEGIN",
                 "BERNOULLI",
                 "BETWEEN",
                 "BIGINT",
                 "BINARY",
                 "BIND",
                 "BINDADD",
                 "BIT",
                 "BLOB",
                 "BLOCKED",
                 "BLOCKSIZE",
                 "BOTH",
                 "BUFFER",
                 "BUFFERPOOL",
                 "BUFFERPOOLS",
                 "BUFFERSIZE",
                 "BUILD",
                 "BY",
                 "BYPASS",
                 "C",
                 "CACHE",
                 "CACHING",
                 "CALL",
                 "CALLED",
                 "CALLER",
                 "CAPTURE",
                 "CARDINALITIES",
                 "CARDINALITY",
                 "CASCADE",
                 "CASCADED",
                 "CASE",
                 "CAST",
                 "CCSID",
                 "CHANGE",
                 "CHANGED",
                 "CHANGES",
                 "CHAR",
                 "CHARACTER",
                 "CHECK",
                 "CHECKED",
                 "CLIENT",
                 "CLOB",
                 "CLOSE",
                 "CLR",
                 "CLUSTER",
                 "COBOL",
                 "COLLECT",
                 "COLLID",
                 "COLUMN",
                 "COLUMNS",
                 "COMM",
                 "COMMENT",
                 "COMMIT",
                 "COMMITTED",
                 "COMPACT",
                 "COMPARE",
                 "COMPARISONS",
                 "COMPRESS",
                 "COMPRESSION",
                 "CONCAT",
                 "CONDITION",
                 "CONN",
                 "CONNECT",
                 "CONNECTIONS",
                 "CONNECTOPT",
                 "CONNHEADER",
                 "CONNMEMUSE",
                 "CONSERVATIVE",
                 "CONSTRAINT",
                 "CONSTRAINTS",
                 "CONSTRUCTOR",
                 "CONTAINERS",
                 "CONTAINS",
                 "CONTENT",
                 "CONTINUE",
                 "CONTINUOUSLY",
                 "CONTROL",
                 "COPY",
                 "COUNT",
                 "COUNT_BIG",
                 "CPU",
                 "CREATE",
                 "CREATE_EXTERNAL_ROUTINE",
                 "CREATEIN",
                 "CREATE_NOT_FENCED",
                 "CREATE_NOT_FENCED_ROUTINE",
                 "CREATETAB",
                 "CS",
                 "CUBE",
                 "CURRENT",
                 "CURRENT_DATE",
                 "CURRENT_DEFAULT_TRANSFORM_GROUP",
                 "CURRENT_PATH",
                 "CURRENT_ROLE",
                 "CURRENT_TIME",
                 "CURRENT_TIMESTAMP",
                 "CURRENT_TRANSFORM_GROUP_FOR_TYPE",
                 "CURRENT_USER",
                 "CURRVAL",
                 "CURSOR",
                 "CURSORS",
                 "CYCLE",
                 "DATA",
                 "DATABASE",
                 "DATALINK",
                 "DATE",
                 "DAY",
                 "DAYS",
                 "DB",
                 "DBADM",
                 "DBCLOB",
                 "DBINFO",
                 "DBMEMUSE",
                 "DBPARTITIONNUM",
                 "DBPARTITIONNUMS",
                 "DB2DARI",
                 "DB2GENRL",
                 "DB2GENERAL",
                 "DB2OPTIONS",
                 "DB2SPL",
                 "DB2SQL",
                 "DB2_RETURN_STATUS",
                 "DB2_TOKEN_STRING",
                 "DEACTIVATE",
                 "DEADLOCK",
                 "DEADLOCKS",
                 "DEC",
                 "DECIMAL",
                 "DECLARE",
                 "DEFAULT",
                 "DEFAULTS",
                 "DEFINE",
                 "DEFINITION",
                 "DEGREE",
                 "DEFER",
                 "DEFERRED",
                 "DELETE",
                 "DESC",
                 "DESCRIPTOR",
                 "DETAILED",
                 "DETAILS",
                 "DETERMINED",
                 "DETERMINISTIC",
                 "DEVICE",
                 "DIAGNOSTICS",
                 "DIMENSIONS",
                 "DIRTY",
                 "DISABLE",
                 "DISALLOW",
                 "DISPATCH",
                 "DISTINCT",
                 "DISTRIBUTION",
                 "DLCONN",
                 "DLLOCK",
                 "DO",
                 "DOUBLE",
                 "DROP",
                 "DROPIN",
                 "DROPPED",
                 "DYNAMIC",
                 "EACH",
                 "ELEMENT",
                 "ELSE",
                 "ELSEIF",
                 "EMPTY",
                 "ENABLE",
                 "ENCRYPTION",
                 "END",
                 "ENDING",
                 "ENFORCED",
                 "ERASE",
                 "ESCAPE",
                 "ESTIMATE",
                 "EUR",
                 "EVALUATE",
                 "EVENT",
                 "EXACT",
                 "EXCEPT",
                 "EXCEPTION",
                 "EXCLUDE",
                 "EXCLUDES",
                 "EXCLUDING",
                 "EXCLUSIVE",
                 "EXECNODE",
                 "EXECUTE",
                 "EXISTS",
                 "EXIT",
                 "EXPAND",
                 "EXPLAIN",
                 "EXPRESSION",
                 "EXTEND",
                 "EXTENDED",
                 "EXTENSION",
                 "EXTENTSIZE",
                 "EXTERNAL",
                 "FALSE",
                 "FEDERATED",
                 "FEDERATED_TOOL",
                 "FENCED",
                 "FETCH",
                 "FILE",
                 "FILTER",
                 "FINAL",
                 "FIRST",
                 "FLOAT",
                 "FLUSH",
                 "FOLLOWING",
                 "FOR",
                 "FORCE",
                 "FOREIGN",
                 "_FOREIGNKEY",
                 "FOUND",
                 "FREE",
                 "FREEPAGE",
                 "FROM",
                 "FS",
                 "FULL",
                 "FUNCTION",
                 "G",
                 "GBPCACHE",
                 "GENERAL",
                 "GENERATE",
                 "GENERATED",
                 "GET",
                 "GLOBAL",
                 "GOTO",
                 "GRANT",
                 "GRAPHIC",
                 "GROUP",
                 "GROUPING",
                 "HANDLER",
                 "HASHING",
                 "HAVING",
                 "HIDDEN",
                 "HIERARCHY",
                 "HIGH",
                 "HOLD",
                 "HOUR",
                 "HOURS",
                 "HPJ",
                 "ID",
                 "IDENTITY",
                 "IF",
                 "IGNORE",
                 "IMMEDIATE",
                 "IMPLICIT_SCHEMA",
                 "IN",
                 "INCLUDE",
                 "INCLUDES",
                 "INCLUDING",
                 "INCREMENT",
                 "INCREMENTAL",
                 "INDEX",
                 "INDEXES",
                 "INDICATOR",
                 "INFIX",
                 "INFO",
                 "INHERIT",
                 "INITIALLY",
                 "INITIAL_INSTS",
                 "INITIAL_IOS",
                 "INLINE",
                 "INNER",
                 "INOUT",
                 "INPUT",
                 "INSENSITIVE",
                 "INSERT",
                 "INSTANTIABLE",
                 "INSTEAD",
                 "INSTS_PER_ARGBYTE",
                 "INSTS_PER_INVOC",
                 "INT",
                 "INTEGER",
                 "INTEGRITY",
                 "INTERSECT",
                 "INTO",
                 "IO",
                 "IOS_PER_ARGBYTE",
                 "IOS_PER_INVOC",
                 "IS",
                 "ISO",
                 "ITERATE",
                 "ISOLATION",
                 "JAVA",
                 "JIS",
                 "JOIN",
                 "K",
                 "KEEP",
                 "KEY",
                 "KEYS",
                 "L",
                 "LANGUAGE",
                 "LARGE",
                 "LAST",
                 "LATERAL",
                 "LC_CTYPE",
                 "LEADING",
                 "LEAVE",
                 "LEFT",
                 "LENGTH",
                 "LEVEL",
                 "LEVEL2",
                 "LIBRARY",
                 "LIBRARYADM",
                 "LIKE",
                 "LIMIT",
                 "LINK",
                 "LINKTYPE",
                 "LOAD",
                 "LOCAL",
                 "LOCALE",
                 "LOCALTIME",
                 "LOCALTIMESTAMP",
                 "LOCATOR",
                 "LOCATORS",
                 "LOCK",
                 "LOCKS",
                 "LOCKSIZE",
                 "LOG",
                 "LOGGED",
                 "LONG",
                 "LONGVAR",
                 "LOOP",
                 "LOW",
                 "M",
                 "MAIN_PROG",
                 "MANAGED",
                 "MANUALSTART",
                 "MAPPING",
                 "MATCHED",
                 "MATERIALIZED",
                 "MAXFILES",
                 "MAXFILESIZE",
                 "MAXVALUE",
                 "MDC",
                 "MERGE",
                 "MESSAGE_TEXT",
                 "METHOD",
                 "METHODS",
                 "MICROSECOND",
                 "MICROSECONDS",
                 "MINPCTUSED",
                 "MINUTE",
                 "MINUTES",
                 "MINVALUE",
                 "MIXED",
                 "MODE",
                 "MODIFIES",
                 "MONITOR",
                 "MONTH",
                 "MONTHS",
                 "MOVEMENT",
                 "MULTISET",
                 "N",
                 "NAME",
                 "NEW",
                 "NEW_TABLE",
                 "NEXT",
                 "NEXTVAL",
                 "NICKNAME",
                 "NO",
                 "NOCACHE",
                 "NOCYCLE",
                 "NODE",
                 "NODES",
                 "NODEGROUP",
                 "NOMAXVALUE",
                 "NOMINVALUE",
                 "NONBLOCKED",
                 "NONE",
                 "NOORDER",
                 "NOT",
                 "NULL",
                 "NULLS",
                 "NUM",
                 "NUMBLOCKPAGES",
                 "NUMERIC",
                 "NUM_FREQVALUES",
                 "NUM_QUANTILES",
                 "OBJECT",
                 "OF",
                 "OFF",
                 "OLD",
                 "OLD_TABLE",
                 "OLE",
                 "OLEDB",
                 "ON",
                 "ONCE",
                 "ONLINE",
                 "ONLY",
                 "OPEN",
                 "OPTIMIZATION",
                 "OPTIMIZE",
                 "OPTION",
                 "OPTIONS",
                 "OR",
                 "ORDER",
                 "ORGANIZE",
                 "OUT",
                 "OUTER",
                 "OVER",
                 "OVERFLOW",
                 "OVERHEAD",
                 "OVERRIDING",
                 "P",
                 "PACKAGE",
                 "PAGE",
                 "PAGESIZE",
                 "PARALLEL",
                 "PARAMETER",
                 "PASSTHRU",
                 "PASSWORD",
                 "PATH",
                 "PARTITION",
                 "PARTITIONING",
                 "PARTITIONINGS",
                 "PATROLLER",
                 "PCTDEACTIVATE",
                 "PCTFREE",
                 "PENDING",
                 "PERCENT_ARGBYTES",
                 "PERMISSION",
                 "PIECESIZE",
                 "PIPE",
                 "PLAN",
                 "PRECEDING",
                 "PRECISION",
                 "PREDICATES",
                 "PREFETCHSIZE",
                 "PREPARE",
                 "PRESERVE",
                 "PREVIOUS",
                 "PREVVAL",
                 "PRIMARY",
                 "_PRIMARYKEY",
                 "PRIQTY",
                 "PRIVILEGES",
                 "PROCEDURE",
                 "PROFILE",
                 "PROGRAM",
                 "PROPAGATE",
                 "PROTOCOL",
                 "PRUNE",
                 "PUBLIC",
                 "QUERY",
                 "QUERYNO",
                 "QUERYTAG",
                 "QUIESCE_CONNECT",
                 "RANGE",
                 "RATE",
                 "RATIO",
                 "READ",
                 "READS",
                 "REAL",
                 "RECOMMEND",
                 "RECONCILE",
                 "RECOVERY",
                 "RECREATE",
                 "REDUCE",
                 "REF",
                 "REFERENCE",
                 "REFERENCES",
                 "REFERENCING",
                 "REFRESH",
                 "REGISTERS",
                 "REGULAR",
                 "RELEASE",
                 "REMAIN",
                 "REMOTE",
                 "RENAME",
                 "REOPT",
                 "REPEATABLE",
                 "REPEAT",
                 "REPLACE",
                 "REPLICATED",
                 "REQUIRING",
                 "RESET",
                 "RESIDENT",
                 "RESIGNAL",
                 "RESIZE",
                 "RESOLVE",
                 "RESTART",
                 "RESTORE",
                 "RESTRICT",
                 "RESULT",
                 "RESULT_SET_LOCATOR",
                 "RETAIN",
                 "RETURN",
                 "RETURNS",
                 "RETURN_STATUS",
                 "REVERSE",
                 "REVOKE",
                 "RIGHT",
                 "ROLLBACK",
                 "ROLLUP",
                 "ROUTINE",
                 "ROW",
                 "ROW_COUNT",
                 "ROWS",
                 "RR",
                 "RS",
                 "RUN",
                 "S",
                 "SAMPLED",
                 "SAVEPOINT",
                 "SBCS",
                 "SCANS",
                 "SCHEMA",
                 "SCOPE",
                 "SCRATCHPAD",
                 "SCROLL",
                 "SEARCH",
                 "SECOND",
                 "SECONDS",
                 "SECQTY",
                 "SECURITYADM",
                 "SELECT",
                 "SELECTION",
                 "SELECTIVE",
                 "SELECTIVITY",
                 "SELF",
                 "SENSITIVE",
                 "SEQUENCE",
                 "SERIALIZABLE",
                 "SERVER",
                 "SESSION",
                 "SESSION_USER",
                 "SET",
                 "SETS",
                 "SETTING",
                 "SHARE",
                 "SHRLEVEL",
                 "SIGNAL",
                 "SIMPLE",
                 "SIZE",
                 "SMALLINT",
                 "SNAPSHOT",
                 "SOME",
                 "SOURCE",
                 "SPECIAL",
                 "SPECIFIC",
                 "SPECIFICATION",
                 "SPLIT",
                 "SQL",
                 "SQLDATA",
                 "SQLERROR",
                 "SQLEXCEPTION",
                 "SQLWARNING",
                 "SQLID",
                 "SQLMACRO",
                 "SQLSTATE",
                 "SSA",
                 "STABILITY",
                 "STAGING",
                 "START",
                 "STATE",
                 "STATEMENT",
                 "STATEMENTS",
                 "STATIC",
                 "STATISTICS",
                 "STARTING",
                 "STAY",
                 "STMT",
                 "STOGROUP",
                 "STORAGE",
                 "STORED",
                 "STRIP",
                 "STRIPE",
                 "STYLE",
                 "SUB",
                 "SUBSECTION",
                 "SUMMARY",
                 "SWITCH",
                 "SYMMETRIC",
                 "SYNONYM",
                 "SYSTEM",
                 "SYSTEM_USER",
                 "T",
                 "TABLE",
                 "TABLES",
                 "TABLESAMPLE",
                 "TABLESPACE",
                 "TABLESPACES",
                 "TARGET",
                 "TEMPLATE",
                 "TEMPORARY",
                 "THEN",
                 "THREADSAFE",
                 "THROUGH",
                 "TIME",
                 "TIMEOUT",
                 "TIMESTAMP",
                 "TIMEZONE",
                 "TO",
                 "TOKEN",
                 "TRAILING",
                 "TRANSACTIONS",
                 "TRANSFERRATE",
                 "TRANSFORM",
                 "TRANSFORMS",
                 "TRANSLATE",
                 "TREAT",
                 "TRIGGER",
                 "TRUE",
                 "TRUNC",
                 "TWOLEVEL",
                 "TYPE",
                 "TYPES",
                 "UNBOUNDED",
                 "UNCHECKED",
                 "UNCOMMITTED",
                 "UNDER",
                 "UNDO",
                 "UNICODE",
                 "UNION",
                 "UNIQUE",
                 "UNLINK",
                 "UNTIL",
                 "UPDATE",
                 "UR",
                 "URL",
                 "USA",
                 "USE",
                 "USAGE",
                 "USER",
                 "USERID",
                 "USING",
                 "VALUE",
                 "VALUES",
                 "VARCHAR",
                 "VARGRAPHIC",
                 "VARIANT",
                 "VARYING",
                 "VCAT",
                 "VERSION",
                 "VIEW",
                 "VOLATILE",
                 "WAIT",
                 "WHEN",
                 "WHERE",
                 "WHILE",
                 "WITH",
                 "WITHOUT",
                 "WORK",
                 "WRAPPER",
                 "WRITE",
                 "WRKSTNNAME",
                 "X",
                 "XACT",
                 "YEAR",
                 "YEARS",
                 "YES",
                 "ABSENT",
                 "ACCORDING",
                 "BASE64",
                 "DOCUMENT",
                 "ENCODING",
                 "HEX",
                 "LOCATION",
                 "NAMESPACE",
                 "NIL",
                 "ORDINALITY",
                 "PASSING",
                 "PI",
                 "RETURNING",
                 "URI",
                 "WHITESPACE",
                 "XML",
                 "XMLAGG",
                 "XMLATTRIBUTES",
                 "XMLBINARY",
                 "XMLCAST",
                 "XMLCOMMENT",
                 "XMLCONCAT",
                 "XMLDECLARATION",
                 "XMLDOCUMENT",
                 "XMLELEMENT",
                 "XMLEXISTS",
                 "XMLFOREST",
                 "XMLNAMESPACES",
                 "XMLPARSE",
                 "XMLPI",
                 "XMLQUERY",
                 "XMLSCHEMA",
                 "XMLSERIALIZE",
                 "XMLTABLE",
                 "XMLTEXT",
                 "XMLVALIDATE",
                 "EOLN",
                 "PARSE_ERROR",
                 "REGULAR_IDENTIFIER",
                 "DELIMITED_IDENTIFIER",
                 "EMBEDDED_VARIABLE_NAME",
                 "UNSIGNED_INTEGER",
                 "SUFFIXED_UNSIGNED_INTEGER",
                 "EXACT_NUMERIC_LITERAL",
                 "APPROXIMATE_NUMERIC_LITERAL",
                 "NATIONAL_CHAR_STRING_LITERAL",
                 "NATIONAL_HEX_STRING_LITERAL",
                 "BIT_STRING_LITERAL",
                 "HEX_STRING_LITERAL",
                 "CHAR_STRING_LITERAL",
                 "COMMENT_STRING",
                 "DELIMITED_TYPE_IDENTIFIER",
                 "VERSION_IDENTIFIER",
                 "DOUBLE_QUOTE",
                 "PERCENT",
                 "AMPERSAND",
                 "QUOTE",
                 "LEFT_PAREN",
                 "RIGHT_PAREN",
                 "ASTERISK",
                 "PLUS_SIGN",
                 "COMMA",
                 "MINUS_SIGN",
                 "PERIOD",
                 "SOLIDUS",
                 "REVERSE_SOLIDUS",
                 "COLON",
                 "SEMICOLON",
                 "LESS_THAN_OPERATOR",
                 "EQUALS_OPERATOR",
                 "GREATER_THAN_OPERATOR",
                 "QUESTION_MARK",
                 "LEFT_BRACKET",
                 "RIGHT_BRACKET",
                 "LEFT_BRACKET_TRIGRAPH",
                 "RIGHT_BRACKET_TRIGRAPH",
                 "VERTICAL_BAR",
                 "NOT_EQUALS_OPERATOR",
                 "GREATER_THAN_OR_EQUALS_OPERATOR",
                 "LESS_THAN_OR_EQUALS_OPERATOR",
                 "CONCAT_OPERATOR",
                 "DOUBLE_PERIOD",
                 "RIGHT_ARROW",
                 "STATEMENT_TERMINATOR",
                 "HOSTVARIABLE",
                 "PARAMETER_MARKER",
                 "LINE_COMMENT",
                 "MULTILINE_COMMENT",
                 "LEFT_BRACE",
                 "RIGHT_BRACE",
                 "BACK_QUOTE",
                 "EOF"
             };


    public final static boolean isValidForParser = false;
}
