/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IServerVersionProvider;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.IContentExtension;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class CommonLabelProviderBase
implements ICommonLabelProvider {
    private IExtensionStateModel mStateModel;
    private ITreeContentProvider mContentProvider;
    private ILabelProvider mDelegate;

    public CommonLabelProviderBase(ILabelProvider delegate) {
        this.mDelegate = delegate;
    }

    public void init(IExtensionStateModel aStateModel, ITreeContentProvider aContentProvider) {
        this.mStateModel = aStateModel;
        this.mContentProvider = aContentProvider;
    }

    public String getDescription(Object anElement) {
        return this.getText(anElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public Image getImage(Object element) {
        if (element instanceof IContentExtension) {
            return ((IContentExtension)element).getImage();
        }
        return this.mDelegate.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IContentExtension) {
            IContentExtension ice = (IContentExtension)element;
            IConnection conn = ice.getConnection();
            StringBuffer sb = new StringBuffer(ice.getLabel());
            if (conn instanceof IServerVersionProvider) {
                IServerVersionProvider isvp = (IServerVersionProvider)conn;
                Version techVersion = isvp.getTechnologyVersion();
                String techName = isvp.getTechnologyName();
                if (techName != null && techName.length() > 0) {
                    String versionStr = MessageFormat.format((String)ConnectivityUIPlugin.getDefault().getResourceString("CommonLabelProviderBase.label.version"), (Object[])new String[]{sb.toString(), techName, techVersion.toString()});
                    sb = new StringBuffer(versionStr);
                }
            }
            return sb.toString();
        }
        return this.mDelegate.getText(element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.mDelegate.addListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.mDelegate.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.mDelegate.removeListener(listener);
    }

    public void dispose() {
        this.mDelegate.dispose();
        this.mStateModel = null;
        this.mContentProvider = null;
    }

    protected ITreeContentProvider getContentProvider() {
        return this.mContentProvider;
    }

    protected IExtensionStateModel getStateModel() {
        return this.mStateModel;
    }

    protected ILabelProvider getDelegate() {
        return this.mDelegate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommonLabelProviderBase) {
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.mDelegate.hashCode();
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }
}

