/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.catalog.util;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.ibm.db2.catalog.JavaProcedureInfo;
import org.eclipse.datatools.enablement.ibm.db2.catalog.util.JavaProcedureProvider;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Procedure;

public class JavaProcedureProviderRegistry {
    public static JavaProcedureProviderRegistry INSTANCE = new JavaProcedureProviderRegistry();
    private Map providers = new HashMap();
    private JavaProcedureProvider nullProvider = new JavaProcedureProvider(){

        @Override
        public JavaProcedureInfo getProviderInstance(DB2Procedure sp, Connection connection) {
            return null;
        }
    };

    public JavaProcedureProvider getProvider(DatabaseDefinition definition) {
        if (!this.providers.containsKey(definition)) {
            this.providers.put(definition, this.loadProvider(definition));
        }
        return (JavaProcedureProvider)this.providers.get(definition);
    }

    private JavaProcedureProvider loadProvider(DatabaseDefinition def) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.db2", "javaProcedure");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String version;
                String product;
                if (configElements[j].getName().equals("provider") && (product = configElements[j].getAttribute("product")).equals(def.getProduct()) && (version = configElements[j].getAttribute("version")).equals(def.getVersion())) {
                    try {
                        return (JavaProcedureProvider)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
        return this.nullProvider;
    }

    private JavaProcedureProviderRegistry() {
    }
}

