/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.types.formatting2.MultiLineFormatter;
import org.eclipse.comma.types.services.TypesGrammarAccess;
import org.eclipse.comma.types.types.Dimension;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypesModel;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TypesFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private TypesGrammarAccess _typesGrammarAccess;
    public static final Procedures.Procedure1<IHiddenRegionFormatter> oneSpaceWrap = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.oneSpace();
            p.autowrap();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> oneSpace = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.oneSpace();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> noSpace = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.noSpace();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> newLine = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.newLine();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> emptyLine = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.setNewLines(2);
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> indent = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.indent();
        }
    };
    public static final Procedures.Procedure1<IHiddenRegionFormatter> doubleIndent = new Procedures.Procedure1<IHiddenRegionFormatter>(){

        public void apply(IHiddenRegionFormatter p) {
            p.indent();
            p.indent();
        }
    };

    protected void _format(TypesModel container, @Extension IFormattableDocument document) {
        EList<TypeDecl> _types = container.getTypes();
        for (TypeDecl typeDecl : _types) {
            document.format((Object)typeDecl);
        }
    }

    protected void _format(TypeDecl typeDecl, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)typeDecl);
        document.append(document.prepend(rFinder.keyword(this._typesGrammarAccess.getSimpleTypeDeclAccess().getTypeKeyword_0()), newLine), oneSpace);
    }

    protected void _format(EnumTypeDecl enumTypeDecl, @Extension IFormattableDocument document) {
        Pair brackets;
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)enumTypeDecl);
        ISemanticRegion kwEnum = rFinder.keyword(this._typesGrammarAccess.getEnumTypeDeclAccess().getEnumKeyword_0());
        document.prepend(kwEnum, newLine);
        document.append(kwEnum, oneSpace);
        ISemanticRegion kwRecord = rFinder.keyword(this._typesGrammarAccess.getRecordTypeDeclAccess().getRecordKeyword_0());
        Procedures.Procedure1 _function = it -> {};
        document.prepend(kwRecord, _function);
        List _keywordPairs = rFinder.keywordPairs(this._typesGrammarAccess.getEnumTypeDeclAccess().getLeftCurlyBracketKeyword_2(), this._typesGrammarAccess.getEnumTypeDeclAccess().getRightCurlyBracketKeyword_4());
        Pair _get = null;
        if (_keywordPairs != null) {
            _get = (Pair)_keywordPairs.get(0);
        }
        if ((brackets = _get) != null) {
            document.interior(brackets, indent);
            document.prepend((ISemanticRegion)brackets.getKey(), oneSpace);
            document.append((ISemanticRegion)brackets.getKey(), newLine);
            document.prepend((ISemanticRegion)brackets.getValue(), newLine);
        }
        Consumer<EnumElement> _function_1 = it -> document.format(it);
        enumTypeDecl.getLiterals().forEach(_function_1);
    }

    protected void _format(EnumElement enumElement, @Extension IFormattableDocument document) {
        document.prepend((EObject)enumElement, newLine);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)enumElement);
        ISemanticRegion _keyword = regionFor.keyword(this._typesGrammarAccess.getEnumElementAccess().getEqualsSignKeyword_1_0());
        if (_keyword != null) {
            document.surround(_keyword, oneSpace);
        }
    }

    protected void _format(RecordTypeDecl recordTypeDecl, @Extension IFormattableDocument document) {
        boolean _not;
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)recordTypeDecl);
        ISemanticRegion kwRecord = rFinder.keyword(this._typesGrammarAccess.getRecordTypeDeclAccess().getRecordKeyword_0());
        document.prepend(kwRecord, newLine);
        document.append(kwRecord, oneSpace);
        List allBrackets = rFinder.keywordPairs(this._typesGrammarAccess.getRecordTypeDeclAccess().getLeftCurlyBracketKeyword_3(), this._typesGrammarAccess.getRecordTypeDeclAccess().getRightCurlyBracketKeyword_6());
        boolean _isEmpty = allBrackets.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Pair brackets = (Pair)allBrackets.get(0);
            document.interior(brackets, indent);
            document.prepend((ISemanticRegion)brackets.getKey(), oneSpace);
            document.append((ISemanticRegion)brackets.getKey(), newLine);
            document.prepend((ISemanticRegion)brackets.getValue(), newLine);
        }
        List _keywords = rFinder.keywords(new Keyword[]{this._typesGrammarAccess.getRecordTypeDeclAccess().getCommaKeyword_5_0()});
        for (ISemanticRegion region : _keywords) {
            document.prepend(region, noSpace);
        }
        EList<RecordField> _fields = recordTypeDecl.getFields();
        for (RecordField recField : _fields) {
            document.format((Object)recField);
        }
    }

    protected void _format(RecordField recField, @Extension IFormattableDocument document) {
        document.prepend((EObject)recField, newLine);
    }

    protected void _format(VectorTypeDecl vectorTypeDecl, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)vectorTypeDecl);
        document.append(regionFor.keyword(this._typesGrammarAccess.getVectorTypeDeclAccess().getVectorKeyword_0()), oneSpace);
        document.append(regionFor.assignment(this._typesGrammarAccess.getVectorTypeDeclAccess().getNameAssignment_1()), oneSpace);
        document.append(regionFor.keyword(this._typesGrammarAccess.getVectorTypeDeclAccess().getEqualsSignKeyword_2()), oneSpace);
        document.format((Object)vectorTypeDecl.getConstructor());
        document.append((EObject)vectorTypeDecl, newLine);
    }

    protected void _format(VectorTypeConstructor vectorTypeConstructor, @Extension IFormattableDocument document) {
        document.append((EObject)vectorTypeConstructor, oneSpace);
        document.append((EObject)vectorTypeConstructor.getType(), noSpace);
        Consumer<Dimension> _function = it -> document.format(it);
        vectorTypeConstructor.getDimensions().forEach(_function);
    }

    protected void _format(Dimension dimension, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)dimension);
        document.prepend(regionFor.keyword(this._typesGrammarAccess.getDimensionAccess().getLeftSquareBracketKeyword_1()), noSpace);
        document.prepend(regionFor.assignment(this._typesGrammarAccess.getDimensionAccess().getSizeAssignment_2()), noSpace);
        document.prepend(regionFor.keyword(this._typesGrammarAccess.getDimensionAccess().getRightSquareBracketKeyword_3()), noSpace);
    }

    public ITextReplacer createCommentReplacer(IComment comment) {
        String ruleName;
        boolean _startsWith;
        ITextReplacer _xblockexpression = null;
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule && (_startsWith = (ruleName = ((AbstractRule)grammarElement).getName()).startsWith("ML"))) {
            return new MultiLineFormatter(comment, '*');
        }
        _xblockexpression = super.createCommentReplacer(comment);
        return _xblockexpression;
    }

    public void formatSimpleBrackets(ISemanticRegionsFinder rFinder, Keyword open, Keyword close, @Extension IFormattableDocument document) {
        boolean _not;
        List pairs = rFinder.keywordPairs(open, close);
        boolean _isEmpty = pairs.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Pair brackets = (Pair)pairs.get(0);
            document.prepend((ISemanticRegion)brackets.getKey(), oneSpace);
            document.prepend((ISemanticRegion)brackets.getValue(), newLine);
            document.interior(brackets, indent);
        }
    }

    public void formatSimpleCommas(List<ISemanticRegion> commas, @Extension IFormattableDocument document) {
        for (ISemanticRegion comma : commas) {
            document.append(document.prepend(comma, noSpace), oneSpaceWrap);
        }
    }

    public void formatTopElement(EObject obj, @Extension IFormattableDocument document) {
        boolean _tripleEquals;
        ISemanticRegion _previousSemanticRegion = this.textRegionExtensions.regionForEObject(obj).getPreviousSemanticRegion();
        boolean bl = _tripleEquals = _previousSemanticRegion == null;
        if (_tripleEquals) {
            boolean _not;
            boolean _containsComment = this.textRegionExtensions.regionForEObject(obj).getPreviousHiddenRegion().containsComment();
            boolean bl2 = _not = !_containsComment;
            if (_not) {
                document.prepend(obj, noSpace);
            }
        } else {
            document.append(obj, emptyLine);
        }
    }

    public void indentList(EList<? extends EObject> objects, @Extension IFormattableDocument document) {
        boolean _notEquals;
        int _size = objects.size();
        boolean bl = _notEquals = _size != 0;
        if (_notEquals) {
            EObject first = (EObject)objects.get(0);
            int _size_1 = objects.size();
            int _minus = _size_1 - 1;
            EObject last = (EObject)objects.get(_minus);
            document.set(this.textRegionExtensions.previousHiddenRegion(first), this.textRegionExtensions.nextHiddenRegion(last), indent);
        }
    }

    public void format(Object enumTypeDecl, IFormattableDocument document) {
        if (enumTypeDecl instanceof EnumTypeDecl) {
            this._format((EnumTypeDecl)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof RecordTypeDecl) {
            this._format((RecordTypeDecl)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof VectorTypeDecl) {
            this._format((VectorTypeDecl)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof XtextResource) {
            this._format((XtextResource)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof EnumElement) {
            this._format((EnumElement)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof RecordField) {
            this._format((RecordField)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof TypeDecl) {
            this._format((TypeDecl)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof TypesModel) {
            this._format((TypesModel)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof VectorTypeConstructor) {
            this._format((VectorTypeConstructor)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof Dimension) {
            this._format((Dimension)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl instanceof EObject) {
            this._format((EObject)enumTypeDecl, document);
            return;
        }
        if (enumTypeDecl == null) {
            this._format(null, document);
            return;
        }
        if (enumTypeDecl != null) {
            this._format(enumTypeDecl, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(enumTypeDecl, document).toString());
    }
}

