/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.DecoratingFileSearchLabelProvider;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.FileTableContentProvider;
import org.eclipse.search.internal.ui.text.FileTreeContentProvider;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.internal.ui.text.NewTextSearchActionGroup;
import org.eclipse.search.internal.ui.text.ReplaceAction;
import org.eclipse.search.internal.ui.text.SortAction;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.OpenSearchPreferencesAction;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.navigator.NavigatorDragAdapter;

public class FileSearchPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private static final String KEY_LIMIT = "org.eclipse.search.resultpage.limit";
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private ActionGroup fActionGroup;
    private IFileSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction = new SortAction(SearchMessages.FileSearchPage_sort_name_label, this, 2);
    private SortAction fSortByPathAction = new SortAction(SearchMessages.FileSearchPage_sort_path_label, this, 3);
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = () -> SHOW_IN_TARGETS;

    public FileSearchPage() {
        this.setElementLimit(1000);
    }

    @Override
    public void setElementLimit(Integer elementLimit) {
        super.setElementLimit(elementLimit);
        int limit = elementLimit;
        this.getSettings().put(KEY_LIMIT, limit);
    }

    @Override
    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new NavigatorDragAdapter((ISelectionProvider)viewer));
    }

    @Override
    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider(this, this.fCurrentSortOrder);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingFileSearchLabelProvider(innerLabelProvider));
        viewer.setContentProvider((IContentProvider)new FileTableContentProvider(this));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    @Override
    protected void configureTreeViewer(final TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider(this, 1);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingFileSearchLabelProvider(innerLabelProvider));
        viewer.setContentProvider((IContentProvider)new FileTreeContentProvider(this, (AbstractTreeViewer)viewer));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                FileSearchPage.this.autoExpand(viewer, event.getElement());
            }
        });
    }

    private void autoExpand(TreeViewer viewer, Object toExpand) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        Display.getCurrent().asyncExec(() -> {
            if (viewer.getControl().isDisposed()) {
                return;
            }
            Object current = toExpand;
            while (current != null) {
                Object childToExpand = null;
                Object[] children = contentProvider.getChildren(current);
                if (children != null && children.length == 1) {
                    childToExpand = children[0];
                }
                if (childToExpand != null && !viewer.getExpandedState(childToExpand)) {
                    viewer.setExpandedState(childToExpand, true);
                }
                current = childToExpand;
            }
        });
    }

    @Override
    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        IWorkbenchPage page = this.getSite().getPage();
        if (offset >= 0 && length != 0) {
            this.openAndSelect(page, file, offset, length, activate);
        } else {
            this.open(page, file, activate);
        }
    }

    @Override
    protected void handleOpen(OpenEvent event) {
        TreeViewer treeViewer;
        Object firstElement;
        if (this.showLineMatches() && (firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IFile && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.open(this.getSite().getPage(), (IFile)firstElement, false);
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)SearchMessages.FileSearchPage_open_file_dialog_title, (String)SearchMessages.FileSearchPage_open_file_failed, (IStatus)e.getStatus());
            }
            return;
        }
        super.handleOpen(event);
        firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (firstElement == null) {
            return;
        }
        Viewer viewer = event.getViewer();
        if (viewer instanceof TreeViewer && (treeViewer = (TreeViewer)viewer).getExpandedState(firstElement)) {
            this.autoExpand(treeViewer, firstElement);
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
        FileSearchQuery query = (FileSearchQuery)this.getInput().getQuery();
        if (!query.getSearchString().isEmpty()) {
            IStructuredSelection selection = this.getViewer().getStructuredSelection();
            if (!selection.isEmpty()) {
                ReplaceAction replaceSelection = new ReplaceAction(this.getSite().getShell(), (FileSearchResult)this.getInput(), selection.toArray());
                replaceSelection.setText(SearchMessages.ReplaceAction_label_selected);
                mgr.appendToGroup("group.reorganize", (IAction)replaceSelection);
            }
            ReplaceAction replaceAll = new ReplaceAction(this.getSite().getShell(), (FileSearchResult)this.getInput(), null);
            replaceAll.setText(SearchMessages.ReplaceAction_label_all);
            mgr.appendToGroup("group.reorganize", (IAction)replaceAll);
        }
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.FileSearchPage_sort_by_label);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    @Override
    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup(part);
    }

    @Override
    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.appendToGroup("group.properties", (IAction)new OpenSearchPreferencesAction());
    }

    @Override
    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    @Override
    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    @Override
    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        DecoratingFileSearchLabelProvider lpWrapper = (DecoratingFileSearchLabelProvider)this.getViewer().getLabelProvider();
        ((FileLabelProvider)lpWrapper.getStyledStringProvider()).setOrder(sortOrder);
        this.getViewer().refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    @Override
    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentSortOrder = this.fSortByNameAction.getSortOrder();
        }
        int elementLimit = 1000;
        try {
            elementLimit = this.getSettings().getInt(KEY_LIMIT);
        }
        catch (NumberFormatException numberFormatException) {}
        if (memento != null) {
            Integer value = memento.getInteger(KEY_SORTING);
            if (value != null) {
                this.fCurrentSortOrder = value;
            }
            if ((value = memento.getInteger(KEY_LIMIT)) != null) {
                elementLimit = value;
            }
        }
        this.setElementLimit(elementLimit);
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
        memento.putInteger(KEY_LIMIT, this.getElementLimit().intValue());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IShowInTargetList.class.equals(adapter)) {
            return (T)SHOW_IN_TARGET_LIST;
        }
        if (adapter == IShowInSource.class) {
            ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
            if (selectionProvider == null) {
                return null;
            }
            ISelection selection = selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                HashSet newSelection = new HashSet(structuredSelection.size());
                for (Object element : structuredSelection) {
                    if (element instanceof LineElement) {
                        element = ((LineElement)element).getParent();
                    }
                    newSelection.add(element);
                }
                return (T)((IShowInSource)() -> new ShowInContext(null, (ISelection)new StructuredSelection(new ArrayList(newSelection))));
            }
            return null;
        }
        return null;
    }

    @Override
    public String getLabel() {
        String label = super.getLabel();
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            TableViewer tv = (TableViewer)viewer;
            AbstractTextSearchResult result = this.getInput();
            if (result != null) {
                int itemCount = ((IStructuredContentProvider)tv.getContentProvider()).getElements((Object)this.getInput()).length;
                if (this.showLineMatches()) {
                    int matchCount = this.getInput().getMatchCount();
                    if (itemCount < matchCount) {
                        return Messages.format(SearchMessages.FileSearchPage_limited_format_matches, new Object[]{label, itemCount, matchCount});
                    }
                } else {
                    int fileCount = this.getInput().getElements().length;
                    if (itemCount < fileCount) {
                        return Messages.format(SearchMessages.FileSearchPage_limited_format_files, new Object[]{label, itemCount, fileCount});
                    }
                }
            }
        }
        return label;
    }

    @Override
    public int getDisplayedMatchCount(Object element) {
        if (this.showLineMatches()) {
            if (element instanceof LineElement) {
                LineElement lineEntry = (LineElement)element;
                return lineEntry.getNumberOfMatches(this.getInput());
            }
            return 0;
        }
        return super.getDisplayedMatchCount(element);
    }

    @Override
    public Match[] getDisplayedMatches(Object element) {
        if (this.showLineMatches()) {
            if (element instanceof LineElement) {
                LineElement lineEntry = (LineElement)element;
                return lineEntry.getMatches(this.getInput());
            }
            return new Match[0];
        }
        return super.getDisplayedMatches(element);
    }

    @Override
    protected void evaluateChangedElements(Match[] matches, Set<Object> changedElements) {
        if (this.showLineMatches()) {
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                LineElement lineElement = ((FileMatch)match).getLineElement();
                if (lineElement != null) {
                    changedElements.add(lineElement);
                }
                ++n2;
            }
        } else {
            super.evaluateChangedElements(matches, changedElements);
        }
    }

    private boolean showLineMatches() {
        AbstractTextSearchResult input = this.getInput();
        return this.getLayout() == 2 && input != null && !((FileSearchQuery)input.getQuery()).isFileNameSearch();
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public int category(Object element) {
            if (element instanceof IContainer) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof LineElement && e2 instanceof LineElement) {
                LineElement m1 = (LineElement)e1;
                LineElement m2 = (LineElement)e2;
                return m1.getOffset() - m2.getOffset();
            }
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            int result = this.getComparator().compare(name1, name2);
            return result;
        }
    }
}

