/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains interfaces for stack API.
 * <p>
 *      A stack is a last-in-first-out data structure.
 * <p>
 *      This package contains 3 interfaces:
 * <ul>
 *   <li>
 *       {@link org.eclipse.collections.api.stack.MutableStack} - a mutable stack API.
 *   </li>
 *   <li>
 *       {@link org.eclipse.collections.api.stack.ImmutableStack} - the non-modifiable equivalent interface to {@link org.eclipse.collections.api.stack.MutableStack}.
 *   </li>
 *   <li>
 *       {@link org.eclipse.collections.api.stack.StackIterable} - a read-only stack API.
 *   </li>
 * </ul>
 */
package org.eclipse.collections.api.stack;
