/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.console.CloudConsoleManager;
import org.eclipse.cft.server.ui.internal.console.ConsoleManagerRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.actions.CloseConsoleAction;
import org.eclipse.ui.part.IPageBookViewPage;

public class CloudFoundryConsolePageParticipant
implements IConsolePageParticipant {
    public void activated() {
    }

    public void deactivated() {
    }

    public void dispose() {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void init(IPageBookViewPage page, IConsole console) {
        if (this.isCloudFoundryConsole(console)) {
            CloseConsoleAction closeAction = new CloseConsoleAction(console);
            closeAction.setImageDescriptor(CloudFoundryImages.CLOSE_CONSOLE);
            IToolBarManager manager = page.getSite().getActionBars().getToolBarManager();
            manager.appendToGroup("launchGroup", (IAction)closeAction);
        }
    }

    protected boolean isCloudFoundryConsole(IConsole console) {
        if (console instanceof MessageConsole) {
            MessageConsole messageConsole = (MessageConsole)console;
            Object cfServerObj = messageConsole.getAttribute("org.eclipse.cft.server.Server");
            Object cfAppModuleObj = messageConsole.getAttribute("org.eclipse.cft.server.CloudApp");
            if (cfServerObj instanceof CloudFoundryServer && cfAppModuleObj instanceof CloudFoundryApplicationModule) {
                CloudFoundryServer cfServer = (CloudFoundryServer)cfServerObj;
                CloudFoundryApplicationModule appModule = (CloudFoundryApplicationModule)cfAppModuleObj;
                CloudConsoleManager manager = ConsoleManagerRegistry.getConsoleManager(cfServer);
                if (manager != null) {
                    MessageConsole existingConsole = manager.findCloudFoundryConsole(cfServer.getServer(), appModule);
                    return messageConsole == existingConsole;
                }
            }
        }
        return false;
    }
}

