/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.notification;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IMarkerResolution;

public class DeleteQuickFix
implements IMarkerResolution {
    ArtifactMetaModelAdapter artifactAdapter = (ArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().get();
    private String label;

    DeleteQuickFix(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        List<Connection> toDelete = new ArrayList();
        TracePersistenceAdapter tracePersistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        EObject traceModel = tracePersistenceAdapter.getTraceModel((ResourceSet)resourceSet);
        TraceHelper traceHelper = new TraceHelper(traceModel);
        TraceMetaModelAdapter traceMetamodelAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
        EObject artifactModel = tracePersistenceAdapter.getArtifactWrappers((ResourceSet)new ResourceSetImpl());
        List artifacts = this.artifactAdapter.getAllArtifacts(artifactModel);
        String artifactContainerFileName = artifactModel.eResource().getURI().lastSegment();
        String markerContainerFileName = new File(marker.getResource().toString()).getName();
        String markerUri = marker.getAttribute("oldArtifactUri", null);
        if (markerContainerFileName.equals(artifactContainerFileName)) {
            int index = -1;
            for (EObject aw : artifacts) {
                if (this.artifactAdapter.getArtifactUri(aw).equals(markerUri)) {
                    toDelete = traceMetamodelAdapter.getConnectedElements(aw, traceModel);
                }
                ++index;
            }
            traceMetamodelAdapter.deleteTrace(toDelete, traceModel);
            EObject toRemove = (EObject)artifacts.get(index);
            EcoreUtil.delete((EObject)toRemove);
            URI artifactModelURI = EcoreUtil.getURI((EObject)artifactModel);
            Resource resourceForArtifacts = resourceSet.createResource(artifactModelURI);
            resourceForArtifacts.getContents().add((Object)artifactModel);
            try {
                resourceForArtifacts.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                marker.delete();
                MessageDialog.openWarning(null, (String)"TraceLinkDeleted", (String)"Links successfully deleted");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            URI deletedEObjectUri = URI.createURI((String)markerUri);
            block7: for (Connection c : traceMetamodelAdapter.getAllTraceLinks(traceModel)) {
                for (EObject item : traceHelper.getTracedElements(c)) {
                    URI itemUri = CapraNotificationHelper.getFileUri(item);
                    if (!deletedEObjectUri.equals(itemUri)) continue;
                    toDelete.add(c);
                    continue block7;
                }
            }
            traceMetamodelAdapter.deleteTrace(toDelete, traceModel);
            try {
                marker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

